/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) MenuItemShadow.java 1.23 - last change made 08/02/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.base.Global;
import java.awt.Font;
import java.awt.MenuItem;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    enabled         java.lang.Boolean         true 
    separator       java.lang.Boolean         false 
    text            java.lang.String          menuitem 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see MenuItem
 * @version 	1.23, 08/02/96
 */
public class MenuItemShadow extends MenuComponentShadow {
  boolean hasSeparator = false;

  public MenuItemShadow() {
    attributes.add("enabled", "java.lang.Boolean", Boolean.TRUE, 0);
    attributes.add("text", "java.lang.String", "menuitem", NOEDITOR);
    attributes.add("separator", "java.lang.Boolean", Boolean.FALSE,
		   NONBODY | CONTAINER);

    if (Global.isMotif())
      attributes.add("font", "java.awt.Font",
		     new Font("Dialog", Font.PLAIN, 12), DONTFETCH);
    else if (Global.isIrix())
      attributes.add("font", "java.awt.Font",
		     new Font("Helvetica", Font.PLAIN, 12), DONTFETCH);
  }

  protected Object getOnBody(String key) {
    if (key.equals("enabled"))
      return(new Boolean(((MenuItem) body).isEnabled()));
    else if (key.equals("text"))
      return(((MenuItem) body).getLabel());
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("enabled"))
      ((MenuItem) body).enable(((Boolean) value).booleanValue());
    else if (key.equals("text"))
      ((MenuItem) body).setLabel((String) value);
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    body = new MenuItem((String) getFromTable("text"));
  }
}
