/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) @(#) ListShadow.java 1.26 - last change made 07/19/96 
 */
     
package sunsoft.jws.visual.rt.shadow.java.awt;
     
import sunsoft.jws.visual.rt.awt.GBConstraints;
import java.awt.List;
     
/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    allowMultipleSelections java.lang.Boolean false 
    items           [Ljava.lang.String;       item1,item2 
    selectedItem    java.lang.String          null
    visibleRows     java.lang.Integer         4 
 * </pre>
 *
 * selectedItem: is the item (amoung the the strings in the "items"
 * attribute) that is currently showing in the list.  This attribute is
 * not available in the attribute editor, but is instead expected to be
 * used programmatically to change or check the setting.
 * <p>
 * Check the super class for additional attributes.
 *
 * @see List
 * @version 	1.26, 07/19/96
 */
public class ListShadow extends ComponentShadow {
  public ListShadow() {
    String sa[] = {"item1","item2"};
    attributes.add("visibleRows", "java.lang.Integer", new Integer(4),
		   CONSTRUCTOR);
    attributes.add("allowMultipleSelections", "java.lang.Boolean",
		   Boolean.FALSE, 0);
    attributes.add("items", "[Ljava.lang.String;", sa, 0);
    attributes.add("selectedItem", "java.lang.String", null, HIDDEN);

    GBConstraints c = (GBConstraints)get("GBConstraints");
    c.fill = GBConstraints.BOTH;
    attributes.add("GBConstraints",
		   "sunsoft.jws.visual.rt.awt.GBConstraints", c);
  }
       
  protected Object getOnBody(String key) {
    if (key.equals("visibleRows"))
      return(new Integer(((List) body).getRows()));
    else if (key.equals("allowMultipleSelections"))
      return(new Boolean(((List) body).allowsMultipleSelections()));
    else if (key.equals("items")) {
      if (((List) body).countItems() == 0)
	return null;
      else {
	int index;
	String[] listContents = new String[((List)body).countItems()];
	for (index=0;index<listContents.length;index++)
	  listContents[index] = ((List)body).getItem(index);
	return listContents;
      }
    }
    else if (key.equals("selectedItem")) {
      List list = (List)body;
      return list.getSelectedItem();
    }
    else
      return(super.getOnBody(key));
  }
       
  /**
   * This efficiently makes changes to the List body when the user changes
   * items in it.  it updates the List body from the new data.
   */
  private void equalizeLists(Object value) {
    String[] newList = ((String[]) (value));
	 
    int newListIndex = 0, oldListIndex = 0;
    int dummyIndex;

    // If the user deleted all of the entries, the newList would be null
    if (newList == null) {
      if (((List) body).countItems() > 0) {
	((List) body).delItems(0,((List)body).countItems()-1);
      }
    }
    else {
      while (newListIndex < newList.length &&
	     oldListIndex < ((List) body).countItems())
	{
	  String curOldItem = ((List) (body)).getItem(oldListIndex);
	       
	  if (newList[newListIndex].equals(curOldItem)) {
	    newListIndex++;
	    oldListIndex++;
	  }
	  else {
	    for (dummyIndex=newListIndex;
		 dummyIndex<newList.length;dummyIndex++) {
	      if (curOldItem.equals(newList[dummyIndex])) {
		((List) body).delItem(oldListIndex);
		break;
	      }
	    }
	    ((List) body).addItem(newList[newListIndex], oldListIndex);
	    newListIndex++;
	    oldListIndex++;
	  }
	}
	   
      if (oldListIndex < ((List) body).countItems()) {
	((List) body).delItems(oldListIndex,((List)body).countItems()-1);
      }
	   
      while (newListIndex < newList.length) {
	((List) body).addItem(newList[newListIndex]);
	newListIndex++;
      }
    }
  }
       
  protected void setOnBody(String key, Object value) {
    if (key.equals("allowMultipleSelections"))
      ((List) body).setMultipleSelections(((Boolean)value).booleanValue());
    else if (key.equals("items"))
      equalizeLists(value);
    else if (key.equals("visibleRows"))
      return;	// this must be set in constructor
    else if (key.equals("selectedItem")) {
      List list = (List)body;
      String s = (String)value;
      if (s != null) {
	for(int i=0; i<list.countItems(); ++i) {
	  if (s.equals(list.getItem(i))) {
	    list.select(i);
	    break;
	  }
	}
      }
    }
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    body = new List(
	((Integer) getFromTable("visibleRows")).intValue(),
	((Boolean) getFromTable("allowMultipleSelections")).booleanValue());
  }
}
