/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ColumnListShadow.java 1.28 - last change made 08/02/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.awt.ColumnList;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.shadow.java.awt.CanvasShadow;
import java.awt.Color;
import java.awt.Font;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    autoWidth       java.lang.Boolean         true 
    visibleChars    java.lang.Integer         0
    visibleRows     java.lang.Integer         5 
    headers         [Ljava.lang.String;       header1,header2,header3 
    highlightItems  java.lang.Boolean         false 
    selectable      java.lang.Boolean         true 
    showHeaders     java.lang.Boolean         true 
 * </pre>
 *
 * headers: An array of Strings. The size of this array determines the
 * number of columns in the list. There will be one additional, hidden
 * column that can be used for any Object. The length of the header
 * string defines the initial width of the column. To make it wider,
 * add spaces to the end of the string. If a header field is of the
 * form "name=header", then only the "header" part will actually be
 * used for the visible header. The "name" part is available through
 * getNames() or getNameColumn() interfaces on the ColumnList widget.
 * If the "name" part is started with a '*', then that column is
 * considered a "key column."  When addItem() is used to add a new row
 * of data to the column list, a check is made to see if the key
 * columns of data in the new item exactly match all of the key
 * columns in any of the current rows.  If there is a match, the new
 * data replaces what was in the matched row, rather than the new data
 * being added to the end in a new row.
 * <p>
 * selectable: If true, records (rows) can be selected with the
 * mouse. A LIST_EVENT gets posted.
 * <p>
 * highlight_items: If true, new entries will be highlighted in
 * orange, slowly fading out.
 * <p>
 * showHeaders: If set to false, the headers will not be shown.
 * <p>
 * autoWidth: when set to true, a column will automatically become
 * wider to accomodate a new piece of data in that column that doesn't
 * fit within the current width of the column.
 * <p>
 * Check the super class for additional attributes.
 *
 * @see ColumnList
 * @version 1.28, 08/02/96
 */
public class ColumnListShadow extends CanvasShadow {
  public ColumnListShadow() {
    String sa[] = {"header1", "header2", "header3"};
    attributes.add("headers", "[Ljava.lang.String;", sa, 0);
    attributes.add("showHeaders", "java.lang.Boolean", Boolean.TRUE, 0);
    attributes.add("visibleRows", "java.lang.Integer", new Integer(5), 0);
    attributes.add("visibleChars", "java.lang.Integer", new Integer(0), 0);
    attributes.add("selectable", "java.lang.Boolean", Boolean.TRUE, 0);
    attributes.add("highlightItems", "java.lang.Boolean", Boolean.FALSE, 0);
    attributes.add("autoWidth", "java.lang.Boolean", Boolean.TRUE, 0);

    GBConstraints c = (GBConstraints)get("GBConstraints");
    c.fill = GBConstraints.BOTH;
    attributes.add("GBConstraints",
		   "sunsoft.jws.visual.rt.awt.GBConstraints", c);
  }

  protected Object getOnBody(String key) {
    if (key.equals("headers"))
      return(getFromTable("headers"));
    else if (key.equals("showHeaders"))
      return(getFromTable("showHeaders"));
    else if (key.equals("visibleRows"))
      return(getFromTable("visibleRows"));
    else if (key.equals("visibleChars"))
      return(getFromTable("visibleChars"));
    else if (key.equals("selectable"))
      return(getFromTable("selectable"));
    else if (key.equals("highlightItems"))
      return(getFromTable("highlightItems"));
    else if (key.equals("autoWidth"))
      return(getFromTable("autoWidth"));
    else if (key.equals("foreground"))
      return(((ColumnList)body).getCanvasForeground());
    else if (key.equals("background"))
      return(((ColumnList)body).getCanvasBackground());
    else if (key.equals("font"))
      return(((ColumnList)body).getCanvasFont());
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("headers"))
      ((ColumnList) body).setHeaders((String []) value);
    else if (key.equals("showHeaders"))
      ((ColumnList) body).setShowHeaders(((Boolean) value).booleanValue());
    else if (key.equals("visibleRows"))
      ((ColumnList) body).setVisibleRows(((Integer) value).intValue());
    else if (key.equals("visibleChars"))
      ((ColumnList) body).setVisibleChars(((Integer) value).intValue());
    else if (key.equals("selectable"))
      ((ColumnList) body).setSelectable(((Boolean) value).booleanValue());
    else if (key.equals("highlightItems"))
      ((ColumnList) body).setHighlightItems(((Boolean) value).booleanValue());
    else if (key.equals("autoWidth"))
      ((ColumnList) body).setAutoWidth(((Boolean) value).booleanValue());
    else if (key.equals("foreground"))
      ((ColumnList)body).setCanvasForeground((Color)value);
    else if (key.equals("background"))
      ((ColumnList)body).setCanvasBackground((Color)value);
    else if (key.equals("font"))
      ((ColumnList)body).setCanvasFont((Font)value);
    else
      super.setOnBody(key, value);
  }

  public void createBody() {
    body = new ColumnList(
	(String[]) getFromTable("headers"), 
	((Boolean) getFromTable("selectable")).booleanValue(),
	((Boolean) getFromTable("highlightItems")).booleanValue());
    ((ColumnList) body).setVisibleRows(((Integer) getFromTable("visibleRows")).intValue());
    ((ColumnList) body).setVisibleChars(((Integer) getFromTable("visibleChars")).intValue());
    ((ColumnList) body).setShowHeaders(((Boolean) getFromTable("showHeaders")).booleanValue());
    ((ColumnList) body).setAutoWidth(((Boolean) getFromTable("autoWidth")).booleanValue());
  }
}
