/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) RootObserver.java 1.4 - last change made 04/25/96
 */

package sunsoft.jws.visual.rt.base;

/**
 * Interface to be provided by those who which to watch the comings and
 * goings of WindowShadows and Groups in a particular Root object.  This
 * is used in the visual designer to keep a list of the top-level windows
 * currently under the main application root.  It registers itself as an
 * observer with the root object and then through this interface receives
 * updates.
 *
 * @version 	1.4, 04/25/96
 */
public interface RootObserver {
  public void add(AttributeManager mgr);
  public void remove(AttributeManager mgr);
  public void select(AttributeManager mgr);
  public void clear();
}
