/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) VJButton.java 1.2 - last change made 05/17/96
 */

package sunsoft.jws.visual.rt.awt;

import sunsoft.jws.visual.rt.base.Global;
import java.awt.*;

public class VJButton extends Button {
  private boolean isStandard = true;

  public VJButton() {
    super();
  }

  public VJButton(String label) {
    super(label);
  }

  public Dimension minimumSize() {
    Dimension d = super.minimumSize();
    if (isStandard) {
      d.width = Math.max(d.width, 75);
      if (!Global.isWindows())
	d.height += 6;
    }
    return d;
  }

  public Dimension preferredSize() {
    Dimension d = super.preferredSize();
    if (isStandard) {
      d.width = Math.max(d.width, 75);
      if (!Global.isWindows())
	d.height += 6;
    }
    return d;
  }

  public boolean isStandard() {
    return isStandard;
  }

  public void setStandard(boolean value) {
    isStandard = value;
  }
}
