/**
 * CLCheckbox.java
 *
 * Copyright 1995-1996 Active Software Inc.
 *
 * @version @(#)CLCheckbox.java 1.2 96/06/22
 * @author  Tilman Sporkert
 */


package sunsoft.jws.visual.rt.awt;

/**
 * A CLCheckbox is a special Object that the ColumnList draws like a flat
 * checkbox. This has two advantages over putting java.awt.Checkboxes into
 * the ColumnList:
 * - under Motif, the java.awt.Checkbox has some extra space around it, 
 *   making the rows very high.
 * - highlighting a row with a java.awt.Checkbox in it looks ugly
 * - significant performance improvements (measured 10x in one application)
 * - the Checkbox is always drawn flat, not in 3D look. Flat is the correct
 *   look in a scrollable area with a white background.
 *
 * Notes on usage:
 * - if the state of a CLCheckbox gets changed, needsRepaint() should be
 *   called on the ColumnList to make the change visible
 * - If a CLCheckbox is in a column list, clicking on the box changes the
 *   state and sends out an ACTION_EVENT. The row will not get selected.
 *   Unlike AWT Checkboxes, clicking on the label does not change the
 *   status. It just selects the row in the ColumnList (which triggers a
 *   LIST_EVENT).
 *
 * @author  Tilman Sporkert
 */
public class CLCheckbox {

    private boolean state = false;
    private String text;

    /**
     * ...
     *
     * @param ...    ...
     * @return       ...
     * @exception    ...
     */
    public CLCheckbox(String text, boolean state) {
	this.text = text;
	this.state = state;
    }


    public String getText() {
	return text;
    }

    public void setText(String text) {
	this.text = text;
    }

    public boolean getState() {
	return state;
    }

    public void setState(boolean state) {
	this.state = state;
    }

    public String toString() {
	return text;
    }
}
