/******************************************************************************/
/*                                                                            */
/*                                JBOS2 V.1.0                                 */
/*                         (C) 2003 - Mikkel Troest                           */
/*                                                                            */
/* This is a Rexx launcher for Borland JBuilder 9 Personal!                   */
/* Unlike other Rexx solutions, it parses the JBuilder config files and sets  */
/* up the environment accordingly.                                            */
/*                                                                            */
/* It requires Golden Codes J2SE SDK 1.4.1_03 for proper operation.           */
/* Also, JBuilder 9 Personal should be installed in the root of a drive       */
/* - e.g. d:\jbuilder - otherwise the command line and environment strings    */
/* will be too long for OS/2 to handle... :(                                  */
/*                                                                            */
/* First step, of course, is to install JBuilder. While this may be possible  */
/* to do with Odin (I haven't tried this approach), the safe choice is to     */
/* install JBuilder on a Win32 system, and then copy the whole installation   */
/* hierarchy to an OS/2 system. To save space, one can delete the folder      */
/* containing the Win32 JDK that ships with JBuilder.                         */
/*                                                                            */
/* This file must reside in the %JBUILDER_HOME%\bin directory, where          */
/* %JBUILDER_HOME% is the installation root - e.g. d:\jbuilder                */
/* Likewise, if you create a program object that points to this script, make  */
/* sure that "Working directory" is set to %JBUILDER_HOME%\bin                */
/*                                                                            */
/* A few environment variables should be set up prior tu running this script. */
/* While not strictly necessary to have them in the global environment        */
/* (i.e. stated in CONFIG.SYS), I find this approach, well, neater... :)      */
/* The environment variables are:                                             */
/*  %JAVA_HOME%     - should be set to the root of your JDK - e.g. d:\java141 */
/*  %JBUILDER_HOME% - should be set to the JBuilder root - e.g. d:\jbuilder   */
/*  %TMP%           - should be set to a suitable temp dir - e.g. c:\tmp      */
/*  %TEMP%          - optional if you prefer this to %TMP% - same story...    */
/*  %USER%          - should be set to the current users name - e.g. mikkle   */
/*  %HOME%          - should be set to a sort of home dir - e.g. d:\mikkle    */
/*                                                                            */
/* If you prefer not to have these environment variables set, you can chose   */
/* to override these settings below. Do this by editing the lines containing  */
/* comments like "Change this to..."                                          */
/* Note that the overridden settings will only be used if the corresponding   */
/* environment variables are empty!                                           */
/* If you're not happy with this, please feel free to change this script to   */
/* suit your needs! :O)                                                       */
/*                                                                            */
/* You may need to change a couple of settings in the JBuilder config files   */
/* I had to change: "vmparam -Xmx256m" to "vmparam -Xmx128m to get Java       */
/* running at all. I also changed the javapath property to:                   */
/* "javapath %java_home%/jre/bin/client/jvm.dll" I don't know if it makes any */
/* difference - I don't use that property in this script... :)                */
/*                                                                            */
/* Known problems:                                                            */
/*   I can only get JBuilder9 to run using Golden Code's JDK1.4.1_03          */
/*   - Borland states that JBuilder is built to run on a certain JDK, though  */
/*     it is possible to use other JDKS for building and running applications */
/*     JBuilder 9 is built to run un JDK 1.4.1, and I guess that is why GC's  */
/*     JDK works, and Innoteks JDK1.4.2 does not. The same problem exists in  */
/*     Windows - JBuilder won't work if forced to use JDK1.4.2...             */
/*                                                                            */
/*   When you build/run an application in JBuilder, a "Completed: JAVA.EXE"   */
/*   OS/2 prompt remains in the background.                                   */
/*   - This is a known problem in Golden Codes JDK. Please refer to the       */
/*     readme file of their JDK distribution for further information.         */
/*                                                                            */
/*	When building/running an application in JBuilder, output to "System.out"  */
/*  and "System.err" is not captured and shown in the JBuilder IDE.           */
/*  - I don't have an explanation for that. Tough luck! Live with it! ;-)     */
/*                                                                            */
/*  I tried to set my test project to use Innotek's JDK 1.4.2 - it built the  */
/*  project, but JBuilder was unable to run it. I could run it from a command */
/*  line, though, using the JBuilder generated command string...(?)           */
/*  - I haven't really looked into this. There may be a solution somewhere... */
/*                                                                            */
/*  There may be a whole lot of other weird stuff going on. Please read the   */
/*  readme file from Golden Code before anything else - it explains a lot of  */
/*  weird stuff! :)                                                           */
/*                                                                            */
/* Apart from the above, everything seems to be in working order.             */
/* I'm currently doing all my Java development in JBuilder on eCS 1.1, and if */
/* I can live with a bit of weirdness, so can you! :O)                        */
/*                                                                            */
/* Pleas excuse the messy REXX code - Hey, it works! ;-)                      */
/* If you wonder what some of by hard-coded -D options are, take a look at    */
/* JBuilder's environment when running under Windows. They were there - I put */
/* them here! ;-)                                                             */
/*                                                                            */
/* Feedback would be nice! This script is absolutely free, you can change it, */
/* re-use it, or whatever. Any products, names and stuff mentioned are the    */
/* property of their respective owners!                                       */
/*                                                                            */
/* :O) Mikkle <mikkle@mikkle.dk>                                              */
/*                                                                            */
/******************************************************************************/
Call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
Call SysLoadFuncs

Env.JBHome = Value( "JBUILDER_HOME",, "OS2ENVIRONMENT" )
If Env.JBHome = "" then Env.JBHome = "d:\jbuilder" /* Change this to point to your jbuilder installation root! */

Env.JHome = Value( "JAVA_HOME",, "OS2ENVIRONMENT" )
If Env.JHome = "" then Env.JHome = "d:\java141" /* Change this to point to your JDK root! */

Env.Tmp = Value( "TMP",, "OS2ENVIRONMENT" )
If Env.Tmp = "" then Env.Tmp = Value( "TEMP",, "OS2ENVIRONMENT" )
If Env.Tmp = "" then Env.Tmp = "c:\tmp" /* Change this to a suitable Temp-dir! */

Env.UserName = Value( "USER",, "OS2ENVIRONMENT" )
If Env.UserName = "" then Env.UserName = "mikkle" /* Change this to your user name */

Env.UserHome = Value( "HOME",, "OS2ENVIRONMENT" )
If Env.UserHome = "" then Env.UserHome = "d:\mikkle" /* Change this to your home directory */

Config.Main =Env.JBHome || "\bin\jbuilder.config"
Config.0 = 0
Env.ClassPath = ""
Env.BootClassPath = ""
Env.VMParam = "-Djava.io.tmpdir=" || Env.Tmp || " -Dsun.cpu.isalist=""pentium i486 i386"" -Duser.name=" || Env.UserName || " -Duser.home=" || Env.UserHome

Env.Java = ""
Env.MainClass = ""
Env.Export = ""

Call ReadFile Config.Main
Call GetIncludes
Call ParseConfig

Call Value "CLASSPATH", Env.ClassPath, "OS2ENVIRONMENT"

Env.JHome || "\jre\bin\java.exe " || Env.VMParam "-Xbootclasspath/p:" || Env.BootClassPath Env.MainClass

If Env.Export <> "" then "del " || Env.Export

Exit 0

/*** addpath <path> - Adds a path entry to the Java classpath ***/
AddPath: Procedure Expose Env.
Parse Arg Path
Path = Translate( Path, "\", "/" ) /*  use "\" instead of "/" as path seperator */

If Pos( "%java_home%", Path ) <> 0 then Path = Env.JHome || SubStr( Path, Length( "%java_home%" ) + 1 )

Env.ClassPath = Env.ClassPath || Path || ";"

Return

/*** addjars <path> - Adds all JAR files in the specified directory to the Java classpath ***/
AddJars: Procedure Expose Env.
Parse Arg JarDir

JarDir = Translate( JarDir, "\", "/" ) /*  use "\" instead of "/" as path seperator */


Call SysFileTree JarDir || "\*.jar", "Jar", "FO"
Do I = 1 to Jar.0
   Call AddPath Jar.I
End

Return

/*** addbootpath <path> - Adds a path entry to the Java boot path ***/
AddBootPath: Procedure Expose Env.
Parse Arg Boot
Boot = Translate( Boot, "\", "/" ) /*  use "\" instead of "/" as path seperator */
If Pos( "..", Boot ) <> 0 then Boot = Env.JBHome || SubStr( Boot, Length( ".." ) + 1 )
  Env.BootClassPath = Env.BootClassPath || Boot || ";"
Return

/*** addbootjars <path> - Adds all JAR files in the specified directory to the Java boot path ***/
AddBootJars: Procedure

Return

/*** Read and parse the specified config file ***/
ReadFile: Procedure Expose Config.
Parse Arg File

I = Config.0

Do While Lines( File ) > 0
  Tmp = LineIn( File )
  If Pos( "#", Tmp ) | Strip( Tmp ) = "" then Iterate
  Else Do
    I = I + 1
    Config.I = Tmp
  End
End
Call Stream File, "C", "CLOSE"
Config.0 = I

Return

GetIncludes: Procedure Expose Config.
  Do I = 1 to Config.0
    Key = Translate( Word( Config.I, 1 ) )
    Value = Subword( Config.I, 2 )
    Select
      When Key = "INCLUDE" then Do
        Call ReadFile Value
        Config.I = ""
      End /* When key = "INCLUDE" */

      When Key = "INCLUDEDIR" then Do
        Call IncludeDir Value
        Config.I = ""
      End /* When key = "INCLUDEDIR" */

      Otherwise /* Dummy statement */
    End /* Select */
  End  /* Do I = 1 to Config.0 */
Return

IncludeDir: Procedure Expose Config.
Parse Arg Dir
Dir = Translate( Dir, "\", "/" ) /*  use "\" instead of "/" as path seperator */

Call SysFileTree Dir || "\*.config", "IncludeFile", "FO"
Do I = 1 to IncludeFile.0
   Call ReadFile IncludeFile.I
End

Return

ExportEnv: Procedure Expose Env.

  Env.Export = SysTempFileName( Env.Tmp || "\JB9P????.TMP" )
  "SET > " || Env.Export
  Call PatchEnv
  Call VMParam "-Dborland.exportenv=" || Env.Export


Return

ParseConfig: Procedure Expose config. Env.
  Do I = 1 to Config.0
    If Pos( "#", Config.I ) | Strip( Config.I ) = "" then Iterate /* Don't want to work on blanks and comments */

    Key = Translate( Word( Config.I, 1 ) )
    If Words( Config.I ) > 1  then Value = Subword( Config.I, 2 )

    Select
      When Key = "VMPARAM" then Call VMParam Value

      When Key = "ADDBOOTPATH" then Call AddBootPath Value

      When Key = "ADDPATH" then Call AddPath Value

      When Key = "ADDJARS" then call AddJars Value

      When Key = "SOCKET" then Call VMParam "-Dborland.socket=" || Value

      When Key = "JAVAPATH" then Env.Java = Value

      When Key = "MAINCLASS" then Env.MainClass = Value

      When Key = "EXPORTENV" then Call ExportEnv

      Otherwise /* Dummy statement */
    End /* Select */
  End   /* Do I = 1 to Config.0 */

Return

VMParam: Procedure Expose Env.
Parse Arg Param
  Env.VMParam = Env.VMParam || " " || Param
Return

PatchEnv: Procedure Expose Env.Export

I = 0
Do While Lines( Env.Export ) > 0
  I = I + 1
  Line.I = LineIn( Env.Export )
End
Call Stream Env.Export, "C", "CLOSE"
Line.0 = I

"DEL " Env.Export

P = 0
Do I = 1 to Line.0
  Tmp = Line.I
  P = Pos( "\", Tmp )
  If P <> 0 then Do While P <> 0
    Tmp = Insert( "\", Tmp, P )
    P = Pos( "\", Tmp, P + 2 )
  End
  Line.I = Tmp
  Call LineOut Env.Export, Line.I
End
Call Stream Env.Export, "C", "CLOSE"

Return
