/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceStripeWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, int x, int y, int width, int height) {
        this.drawWatermarkImage((Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        int row;
        Color stampColor = null;
        stampColor = isPreview ? (SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? Color.lightGray : Color.darkGray) : SubstanceColorUtilities.getWatermarkStampColor();
        graphics.setColor(stampColor);
        for (row = y; row < y + height; row += 2) {
            graphics.drawLine(x, row, x + width, row);
        }
        if (isPreview) {
            graphics.setColor(Color.gray);
            for (row = y + 1; row < y + height; row += 2) {
                graphics.drawLine(x, row, x + width, row);
            }
        }
        return true;
    }

    public String getDisplayName() {
        return SubstanceStripeWatermark.getName();
    }

    public static String getName() {
        return "Stripes";
    }

    public boolean isDependingOnTheme() {
        return true;
    }

    public void dispose() {
        watermarkImage = null;
    }
}

