/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jvnet.substance.SubstanceDefaultTreeCellRenderer;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceTreeUI
extends MetalTreeUI {
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();

    public static ComponentUI createUI(JComponent tree) {
        return new SubstanceTreeUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (SubstanceLookAndFeel.toBleedWatermark()) {
            this.tree.setOpaque(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int leadIndex;
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        if (this.tree.hasFocus()) {
            TreePath leadPath = this.tree.getLeadSelectionPath();
            leadIndex = this.getRowForPath(this.tree, leadPath);
        } else {
            leadIndex = -1;
        }
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, leadIndex == row);
        if (this.tree.isRowSelected(row)) {
            backgroundDelegate.update(g, component, bounds, SubstanceLookAndFeel.getColorScheme(), true);
        }
        if (component instanceof JComponent) {
            JComponent jRenderer;
            JComponent jComponent = jRenderer = (JComponent)component;
            synchronized (jComponent) {
                boolean newOpaque;
                boolean bl = newOpaque = !this.tree.isRowSelected(row);
                if (SubstanceLookAndFeel.toBleedWatermark()) {
                    newOpaque = false;
                }
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            }
        } else {
            this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new SubstanceDefaultTreeCellRenderer();
    }
}

