/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class NimRODTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color selectColor;
    private int inclTab = 12;
    private int anchoFocoH = 4;
    private int anchoCarpetas = 18;
    private int rollover = -1;
    private int antRollover = -1;
    private MiML miml;
    private Polygon shape;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.rollover = -1;
        this.selectColor = NimRODLookAndFeel.getFocusColor();
        this.tabAreaInsets.right = this.anchoCarpetas;
    }

    protected void installListeners() {
        super.installListeners();
        this.miml = new MiML();
        this.tabPane.addMouseMotionListener(this.miml);
        this.tabPane.addMouseListener(this.miml);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseMotionListener(this.miml);
        this.tabPane.removeMouseListener(this.miml);
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        Rectangle rectangle4 = new Rectangle(rectangle);
        rectangle4.width -= this.inclTab;
        super.layoutLabel(n, fontMetrics, n2, string, icon, rectangle4, rectangle2, rectangle3, bl);
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        if (this.runCount > 1) {
            int n3;
            int[] nArray = new int[this.runCount];
            for (n3 = 0; n3 < this.runCount; ++n3) {
                nArray[n3] = this.rects[this.tabRuns[n3]].y + (n == 1 ? this.maxTabHeight : 0);
            }
            Arrays.sort(nArray);
            if (n == 1) {
                n3 = this.runCount;
                int n4 = 0;
                while (n4 < nArray.length - 1) {
                    Polygon polygon = new Polygon();
                    polygon.addPoint(0, nArray[n4]);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n3 - 2, nArray[n4]);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n3, nArray[n4] + 3);
                    if (n4 < nArray.length - 2) {
                        polygon.addPoint(this.tabPane.getWidth() - 2 * n3, nArray[n4 + 1]);
                        polygon.addPoint(0, nArray[n4 + 1]);
                    } else {
                        polygon.addPoint(this.tabPane.getWidth() - 2 * n3, nArray[n4] + this.rects[n2].height);
                        polygon.addPoint(0, nArray[n4] + this.rects[n2].height);
                    }
                    polygon.addPoint(0, nArray[n4]);
                    graphics.setColor(this.hazAlfa(n3));
                    graphics.fillPolygon(polygon);
                    graphics.setColor(this.darkShadow.darker());
                    graphics.drawPolygon(polygon);
                    ++n4;
                    --n3;
                }
            } else {
                n3 = 0;
                int n5 = 0;
                while (n5 < nArray.length - 1) {
                    Polygon polygon = new Polygon();
                    polygon.addPoint(0, nArray[n5]);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n3 - 1, nArray[n5]);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n3 - 1, nArray[n5 + 1] - 3);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n3 - 3, nArray[n5 + 1]);
                    polygon.addPoint(0, nArray[n5 + 1]);
                    polygon.addPoint(0, nArray[n5]);
                    graphics.setColor(this.hazAlfa(n3 + 2));
                    graphics.fillPolygon(polygon);
                    graphics.setColor(this.darkShadow.darker());
                    graphics.drawPolygon(polygon);
                    ++n5;
                    ++n3;
                }
            }
        }
        super.paintTabArea(graphics, n, n2);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        GradientPaint gradientPaint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int[] nArray = null;
        int[] nArray2 = null;
        switch (n) {
            case 2: {
                nArray = new int[]{n3, n3, n3 + n5, n3 + n5, n3};
                nArray2 = new int[]{n4, n4 + n6 - 3, n4 + n6 - 3, n4, n4};
                gradientPaint = new GradientPaint(n3, n4, NimRODUtils.brillo, n3, n4 + n6, NimRODUtils.sombra);
                break;
            }
            case 4: {
                nArray = new int[]{n3, n3, n3 + n5 - 2, n3 + n5 - 2, n3};
                nArray2 = new int[]{n4, n4 + n6 - 3, n4 + n6 - 3, n4, n4};
                gradientPaint = new GradientPaint(n3, n4, NimRODUtils.brillo, n3, n4 + n6, NimRODUtils.sombra);
                break;
            }
            case 3: {
                nArray = new int[]{n3, n3, n3 + 3, n3 + n5 - this.inclTab - 6, n3 + n5 - this.inclTab - 2, n3 + n5 - this.inclTab, n3 + n5 - 3, n3};
                nArray2 = new int[]{n4, n4 + n6 - 3, n4 + n6, n4 + n6, n4 + n6 - 1, n4 + n6 - 3, n4, n4};
                gradientPaint = new GradientPaint(n3, n4, NimRODUtils.brillo, n3, n4 + n6, NimRODUtils.sombra);
                break;
            }
            default: {
                nArray = new int[]{n3, n3, n3 + 3, n3 + n5 - this.inclTab - 6, n3 + n5 - this.inclTab - 2, n3 + n5 - this.inclTab, n3 + n5, n3};
                nArray2 = new int[]{n4 + n6, n4 + 3, n4, n4, n4 + 1, n4 + 3, n4 + n6, n4 + n6};
                gradientPaint = new GradientPaint(n3, n4, NimRODUtils.brillo, n3, n4 + n6, NimRODUtils.sombra);
            }
        }
        this.shape = new Polygon(nArray, nArray2, nArray.length);
        if (bl) {
            graphics2D.setColor(this.selectColor);
        } else {
            graphics2D.setColor(this.tabPane.getBackgroundAt(n2));
        }
        graphics2D.fill(this.shape);
        if (this.runCount > 1) {
            graphics2D.setColor(this.hazAlfa(this.getRunForTab(this.tabPane.getTabCount(), n2) - 1));
            graphics2D.fill(this.shape);
        }
        if (n2 == this.rollover) {
            graphics2D.setColor(NimRODUtils.getRolloverColor());
            graphics2D.fill(this.shape);
        }
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(this.shape);
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        return 8 + this.inclTab + super.calculateTabWidth(n, n2, fontMetrics);
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        if (n == 2 || n == 4) {
            return super.calculateTabHeight(n, n2, n3);
        }
        return this.anchoFocoH + super.calculateTabHeight(n, n2, n3);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.tabPane.hasFocus() && bl) {
            BasicStroke basicStroke = new BasicStroke(3.0f);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(UIManager.getColor("ScrollBar.thumbShadow"));
            graphics2D.drawPolygon(this.shape);
            graphics2D.setStroke(stroke);
        }
    }

    protected Color hazAlfa(int n) {
        int n2 = 0;
        if (n >= 0) {
            n2 = 50 + (n > 7 ? 70 : 10 * n);
        }
        return new Color(0, 0, 0, n2);
    }

    public class MiML
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseExited(MouseEvent mouseEvent) {
            NimRODTabbedPaneUI.this.rollover = -1;
            NimRODTabbedPaneUI.this.tabPane.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            NimRODTabbedPaneUI.this.rollover = NimRODTabbedPaneUI.this.tabForCoordinate(NimRODTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (NimRODTabbedPaneUI.this.rollover == -1 && NimRODTabbedPaneUI.this.antRollover == NimRODTabbedPaneUI.this.rollover) {
                return;
            }
            NimRODTabbedPaneUI.this.tabPane.repaint();
            NimRODTabbedPaneUI.this.antRollover = NimRODTabbedPaneUI.this.rollover;
        }
    }
}

