/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.JTracker;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    JTrackerExtension handle;
    boolean stippled;
    org.eclipse.swt.graphics.Cursor cursor;
    boolean hasRectangles;

    public Tracker(Composite composite, int n2) {
        super(composite, Tracker.checkStyle(n2));
        this.parent = composite;
        this.createWidget();
    }

    public Tracker(Display display, int n2) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n2);
        this.display = display;
        this.createWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x24480) == 0) {
            n2 |= 0x24480;
        }
        return n2;
    }

    public void close() {
        this.checkWidget();
        this.handle.hide();
    }

    void createWidget() {
        Control control = this.display.getCursorControl();
        Window window = control != null && !Compatibility.IS_JAVA_5_OR_GREATER ? SwingUtilities.getWindowAncestor(control.handle) : null;
        Container container = this.parent == null ? null : ((CControl)((Object)this.parent.handle)).getClientArea();
        this.handle = new JTrackerExtension(this, (Component)container, (this.style & 0x10) != 0, window, null);
        this.handle.addTrackerListener((JTracker.TrackerListener)((Object)new JTracker.TrackerWindow(this){
            final /* synthetic */ JTrackerExtension this$1;
            {
                this.this$1 = jTrackerExtension;
            }

            public Cursor getCursor() {
                return Utils.globalCursor != null ? Utils.globalCursor : super.getCursor();
            }
        }));
        int n2 = 0;
        if ((this.style & 0x80) != 0) {
            n2 |= 1;
        }
        if ((this.style & 0x4000) != 0) {
            n2 |= 2;
        }
        if ((this.style & 0x400) != 0) {
            n2 |= 4;
        }
        if ((this.style & 0x20000) != 0) {
            n2 |= 8;
        }
        this.handle.setConstraints(n2);
    }

    public org.eclipse.swt.graphics.Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = this.handle.getRectangles();
        int n2 = 0;
        if (rectangleArray != null) {
            n2 = rectangleArray.length;
        }
        org.eclipse.swt.graphics.Rectangle[] rectangleArray2 = new org.eclipse.swt.graphics.Rectangle[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Rectangle rectangle = rectangleArray[i2];
            rectangleArray2[i2] = new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return rectangleArray2;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    public boolean open() {
        this.checkWidget();
        if (!this.hasRectangles) {
            return false;
        }
        Utils.setGlobalCursor(this.cursor == null ? null : this.cursor.handle);
        boolean bl = this.handle.show();
        Utils.setGlobalCursor(null);
        return bl;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void setCursor(org.eclipse.swt.graphics.Cursor cursor) {
        this.checkWidget();
        if (this.cursor == cursor) {
            return;
        }
        this.cursor = cursor;
        if (this.handle.isVisible()) {
            Utils.setGlobalCursor(this.cursor == null ? null : this.cursor.handle);
        }
        this.handle.updateCursor();
    }

    public void setRectangles(org.eclipse.swt.graphics.Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            org.eclipse.swt.graphics.Rectangle rectangle = rectangleArray[i2];
            if (rectangle == null) {
                this.error(4);
            }
            rectangleArray2[i2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.hasRectangles = true;
        this.handle.setRectangles(rectangleArray2);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
        this.handle.setAppearance(bl ? 1 : 0);
    }

    protected final class JTrackerExtension
    extends JTracker {
        protected final Window window;

        private JTrackerExtension(Component component, boolean isResizeType, Window window) {
            super(component, isResizeType);
            this.window = window;
        }

        protected JTracker.TrackerWindow createTrackerWindow(Window ownerWindow) {
            return new /* invalid duplicate definition of identical inner class */;
        }

        protected Window createSharedOwnerWindow() {
            return this.window != null ? this.window : super.createSharedOwnerWindow();
        }

        protected void releaseSharedOwnerWindow(Window sharedOwnerWindow) {
            if (this.window == null) {
                super.releaseSharedOwnerWindow(sharedOwnerWindow);
            }
        }

        protected void processMouseEvent(MouseEvent me) {
            if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                Utils.trackMouseProperties(me);
            }
            super.processMouseEvent(me);
            if (Utils.capturedControl != null) {
                Container target = ((CControl)((Object)Utils.capturedControl.handle)).getClientArea();
                Point point = SwingUtilities.convertPoint((Component)me.getSource(), me.getX(), me.getY(), target);
                if (me.getID() == 507) {
                    MouseWheelEvent mwe = (MouseWheelEvent)me;
                    me = new MouseWheelEvent((Component)target, mwe.getID(), mwe.getWhen(), mwe.getModifiers(), point.x, point.y, mwe.getClickCount(), mwe.isPopupTrigger(), mwe.getScrollType(), mwe.getScrollAmount(), mwe.getWheelRotation());
                } else {
                    me = new MouseEvent(target, me.getID(), me.getWhen(), me.getModifiers(), point.x, point.y, me.getClickCount(), me.isPopupTrigger());
                }
                target.dispatchEvent(me);
            }
        }

        public void updateCursor() {
            Window ownerWindow = this.getSharedOwnerWindow();
            if (ownerWindow == null) {
                return;
            }
            Window w2 = new Window(this, ownerWindow){
                final /* synthetic */ JTrackerExtension this$1;
                {
                    this.this$1 = jTrackerExtension;
                }

                public boolean isFocusable() {
                    return false;
                }

                public Cursor getCursor() {
                    return Utils.globalCursor != null ? Utils.globalCursor : super.getCursor();
                }
            };
            w2.setFocusableWindowState(false);
            Point mouseLocation = Compatibility.IS_JAVA_5_OR_GREATER ? MouseInfo.getPointerInfo().getLocation() : this.getLastMouseLocation();
            if (mouseLocation != null) {
                w2.setBounds(mouseLocation.x, mouseLocation.y, 1, 1);
                w2.setVisible(true);
                w2.dispose();
            }
        }

        public void hide() {
            Utils.setGlobalCursor(null);
            this.updateCursor();
            super.hide();
        }
    }
}

