/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.CTable;
import org.eclipse.swt.internal.swing.CTableItem;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    ArrayList itemList;
    ArrayList columnList;
    TableItem currentItem;
    int lastIndexOf;
    static final int INSET = 4;
    static final int GRID_WIDTH = 1;
    static final int HEADER_MARGIN = 10;
    TableColumn sortColumn;
    int sortDirection;
    boolean isAdjustingSelection;

    public Table(Composite composite, int n2) {
        super(composite, Table.checkStyle(n2));
    }

    void adjustColumnWidth() {
        if (this.getColumnCount() == 0) {
            CTable cTable = (CTable)((Object)this.handle);
            cTable.getColumnModel().getColumn(0).setPreferredWidth(cTable.getPreferredColumnWidth(0));
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    boolean checkData(TableItem tableItem, boolean bl) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        return this.checkData(tableItem, this.indexOf(tableItem), bl);
    }

    boolean checkData(TableItem tableItem, int n2, boolean bl) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!tableItem.cached) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = n2;
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n2) {
        this.checkWidget();
        TableItem tableItem = (TableItem)this.itemList.get(n2);
        if (tableItem != null) {
            tableItem.clear();
        }
        this.handle.repaint();
    }

    public void clear(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            TableItem tableItem = (TableItem)this.itemList.get(i2);
            if (tableItem == null) continue;
            tableItem.clear();
        }
        this.handle.repaint();
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TableItem tableItem = (TableItem)this.itemList.get(i2);
            if (tableItem == null) continue;
            tableItem.clear();
        }
        this.handle.repaint();
    }

    public void clearAll() {
        this.checkWidget();
        for (int i2 = this.itemList.size() - 1; i2 >= 0; --i2) {
            TableItem tableItem = (TableItem)this.itemList.get(i2);
            if (tableItem == null) continue;
            tableItem.clear();
        }
        this.handle.repaint();
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        CTable cTable = (CTable)((Object)this.handle);
        return super.computeTrim(n2, n3, n4 += cTable.getVerticalScrollBar().getPreferredSize().width, n5 += cTable.getHorizontalScrollBar().getPreferredSize().height);
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state &= 0xFFFFFEFD;
    }

    protected Container createHandle() {
        return (Container)((Object)CTable.Factory.newInstance(this, this.style));
    }

    void createItem(TableColumn tableColumn, int n2) {
        Object object;
        for (int i2 = 0; i2 < this.itemList.size(); ++i2) {
            object = (TableItem)this.itemList.get(i2);
            if (object == null) continue;
            ((TableItem)object).handle.insertColumn(n2);
            if (n2 != 0) continue;
            ((TableItem)object).text = "";
            ((TableItem)object).image = null;
        }
        TableColumnModel tableColumnModel = ((CTable)((Object)this.handle)).getColumnModel();
        object = (javax.swing.table.TableColumn)((Object)tableColumn.handle);
        if (this.columnList.isEmpty()) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        this.columnList.add(n2, tableColumn);
        for (int i3 = tableColumnModel.getColumnCount() - 1; i3 >= 0; --i3) {
            javax.swing.table.TableColumn tableColumn2 = tableColumnModel.getColumn(i3);
            int n3 = tableColumn2.getModelIndex();
            if (n3 < n2) continue;
            tableColumn2.setModelIndex(n3 + 1);
        }
        tableColumnModel.addColumn((javax.swing.table.TableColumn)object);
        ((javax.swing.table.TableColumn)object).setModelIndex(n2);
        ((CTable)((Object)this.handle)).moveColumn(this.getColumnCount() - 1, n2);
        this.handle.repaint();
    }

    void createItem(TableItem tableItem, int n2) {
        int n3 = this.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.itemList.add(n2, tableItem);
        ((CTable)((Object)this.handle)).addItem(n2);
    }

    void createWidget() {
        this.itemList = new ArrayList();
        this.columnList = new ArrayList();
        super.createWidget();
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        DefaultListSelectionModel defaultListSelectionModel = ((CTable)((Object)this.handle)).getSelectionModel();
        this.isAdjustingSelection = true;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            defaultListSelectionModel.removeSelectionInterval(n2, n2);
        }
        this.isAdjustingSelection = false;
    }

    public void deselect(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        this.isAdjustingSelection = true;
        ((CTable)((Object)this.handle)).getSelectionModel().removeSelectionInterval(n2, n2);
        this.isAdjustingSelection = false;
    }

    public void deselect(int n2, int n3) {
        this.checkWidget();
        this.isAdjustingSelection = true;
        ((CTable)((Object)this.handle)).getSelectionModel().removeSelectionInterval(n2, n3);
        this.isAdjustingSelection = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.isAdjustingSelection = true;
        ((CTable)((Object)this.handle)).getSelectionModel().clearSelection();
        this.isAdjustingSelection = false;
    }

    void destroyItem(TableColumn tableColumn) {
        Object object;
        int n2 = this.columnList.indexOf(tableColumn);
        for (int i2 = 0; i2 < this.itemList.size(); ++i2) {
            object = (TableItem)this.itemList.get(i2);
            if (object == null) continue;
            ((TableItem)object).handle.removeColumn(n2);
        }
        this.columnList.remove(n2);
        if (this.columnList.isEmpty()) {
            TableColumnModel tableColumnModel = ((CTable)((Object)this.handle)).getColumnModel();
            object = new javax.swing.table.TableColumn(0);
            tableColumnModel.addColumn((javax.swing.table.TableColumn)object);
        }
        if (this.sortColumn == tableColumn) {
            this.sortColumn = null;
            this.sortDirection = 0;
        }
        this.handle.repaint();
    }

    void destroyItem(TableItem tableItem) {
        int n2 = this.indexOf(tableItem);
        this.itemList.remove(tableItem);
        ((CTable)((Object)this.handle)).removeItem(n2);
    }

    public TableColumn getColumn(int n2) {
        this.checkWidget();
        if (this.columnList == null) {
            this.error(6);
        }
        int n3 = this.getColumnCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return (TableColumn)this.columnList.get(n2);
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnList == null ? 0 : this.columnList.size();
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        return ((CTable)((Object)this.handle)).getColumnOrder();
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        if (this.columnList == null) {
            return new TableColumn[0];
        }
        return this.columnList.toArray(new TableColumn[0]);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        JTableHeader jTableHeader = ((CTable)((Object)this.handle)).getTableHeader();
        return jTableHeader.isVisible() ? jTableHeader.getHeight() : 0;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((CTable)((Object)this.handle)).getTableHeader().isVisible();
    }

    public TableItem getItem(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return this._getItem(n2);
    }

    public TableItem getItem(Point point) {
        int n2;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((n2 = ((CTable)((Object)this.handle)).rowAtPoint(new java.awt.Point(point.x, point.y))) < 0) {
            return null;
        }
        return this._getItem(n2);
    }

    TableItem _getItem(int n2) {
        TableItem tableItem = (TableItem)this.itemList.get(n2);
        if ((this.style & 0x10000000) == 0) {
            return tableItem;
        }
        if (tableItem != null) {
            return tableItem;
        }
        tableItem = new TableItem(this, 0, -1, false);
        this.itemList.set(n2, tableItem);
        return tableItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemList == null ? 0 : this.itemList.size();
    }

    public int getItemHeight() {
        this.checkWidget();
        return ((CTable)((Object)this.handle)).getRowHeight();
    }

    public TableItem[] getItems() {
        this.checkWidget();
        if ((this.style & 0x10000000) != 0) {
            TableItem[] tableItemArray = new TableItem[this.getItemCount()];
            for (int i2 = 0; i2 < tableItemArray.length; ++i2) {
                tableItemArray[i2] = this._getItem(i2);
            }
            return tableItemArray;
        }
        return this.itemList.toArray(new TableItem[0]);
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((CTable)((Object)this.handle)).isGridVisible();
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        DefaultListSelectionModel defaultListSelectionModel = ((CTable)((Object)this.handle)).getSelectionModel();
        int n2 = defaultListSelectionModel.getMinSelectionIndex();
        int n3 = defaultListSelectionModel.getMaxSelectionIndex();
        if (n2 == -1 || n3 == -1) {
            return new TableItem[0];
        }
        TableItem[] tableItemArray = new TableItem[1 + n3 - n2];
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!defaultListSelectionModel.isSelectedIndex(i2)) continue;
            tableItemArray[n4++] = this._getItem(i2);
        }
        TableItem[] tableItemArray2 = new TableItem[n4];
        System.arraycopy(tableItemArray, 0, tableItemArray2, 0, n4);
        return tableItemArray2;
    }

    public int getSelectionCount() {
        this.checkWidget();
        DefaultListSelectionModel defaultListSelectionModel = ((CTable)((Object)this.handle)).getSelectionModel();
        int n2 = defaultListSelectionModel.getMinSelectionIndex();
        int n3 = defaultListSelectionModel.getMaxSelectionIndex();
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!defaultListSelectionModel.isSelectedIndex(i2)) continue;
            ++n4;
        }
        return n4;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        DefaultListSelectionModel defaultListSelectionModel = ((CTable)((Object)this.handle)).getSelectionModel();
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        DefaultListSelectionModel defaultListSelectionModel = ((CTable)((Object)this.handle)).getSelectionModel();
        int n2 = defaultListSelectionModel.getMinSelectionIndex();
        int n3 = defaultListSelectionModel.getMaxSelectionIndex();
        if (n2 == -1 || n3 == -1) {
            return new int[0];
        }
        int[] nArray = new int[1 + n3 - n2];
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!defaultListSelectionModel.isSelectedIndex(i2)) continue;
            nArray[n4++] = i2;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        return Math.max(0, ((CTable)((Object)this.handle)).getTopIndex());
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        return this.columnList.indexOf(tableColumn);
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (1 <= this.lastIndexOf && this.lastIndexOf < n2 - 1) {
            if (this.itemList.get(this.lastIndexOf) == tableItem) {
                return this.lastIndexOf;
            }
            if (this.itemList.get(this.lastIndexOf + 1) == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.itemList.get(this.lastIndexOf - 1) == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < n2 / 2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.itemList.get(i2) != tableItem) continue;
                this.lastIndexOf = i2;
                return this.lastIndexOf;
            }
        } else {
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                if (this.itemList.get(i3) != tableItem) continue;
                this.lastIndexOf = i3;
                return this.lastIndexOf;
            }
        }
        return -1;
    }

    public boolean isSelected(int n2) {
        this.checkWidget();
        return ((CTable)((Object)this.handle)).getSelectionModel().isSelectedIndex(n2);
    }

    Point minimumSize(int n2, int n3, boolean bl) {
        Dimension dimension = this.handle.getPreferredSize();
        return new Point(dimension.width, dimension.height);
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n2;
        if (this.itemList != null) {
            for (n2 = this.itemList.size() - 1; n2 >= 0; --n2) {
                item = (TableItem)this.itemList.get(n2);
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.itemList = null;
        }
        if (this.columnList != null) {
            for (n2 = 0; n2 < this.columnList.size(); ++n2) {
                item = (TableColumn)this.columnList.get(n2);
                if (item.isDisposed()) continue;
                item.release(false);
            }
            this.columnList = null;
        }
        super.releaseChildren(bl);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = nArray2[nArray2.length - 1];
        int n3 = nArray2[0];
        int n4 = this.getItemCount();
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n5 = nArray2[i2];
            TableItem tableItem = (TableItem)this.itemList.get(n5);
            if (tableItem != null) {
                tableItem.dispose();
                continue;
            }
            this.itemList.remove(n5);
            ((CTable)((Object)this.handle)).removeItem(n5);
        }
    }

    public void remove(int n2) {
        TableItem tableItem;
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        if ((tableItem = (TableItem)this.itemList.get(n2)) != null) {
            tableItem.dispose();
        } else {
            this.itemList.remove(n2);
            ((CTable)((Object)this.handle)).removeItem(n2);
        }
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = this.getItemCount();
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        for (int i2 = n3; i2 >= n2; --i2) {
            TableItem tableItem = (TableItem)this.itemList.get(i2);
            if (tableItem != null) {
                tableItem.dispose();
                continue;
            }
            this.itemList.remove(i2);
            ((CTable)((Object)this.handle)).removeItem(i2);
        }
    }

    public void removeAll() {
        this.checkWidget();
        for (int i2 = this.itemList.size() - 1; i2 >= 0; --i2) {
            TableItem tableItem = (TableItem)this.itemList.get(i2);
            if (tableItem != null) {
                tableItem.dispose();
                continue;
            }
            this.itemList.remove(i2);
            ((CTable)((Object)this.handle)).removeItem(i2);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        DefaultListSelectionModel defaultListSelectionModel = ((CTable)((Object)this.handle)).getSelectionModel();
        this.isAdjustingSelection = true;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            defaultListSelectionModel.addSelectionInterval(n3, n3);
        }
        this.isAdjustingSelection = false;
    }

    public void select(int n2) {
        this.checkWidget();
        this.isAdjustingSelection = true;
        ((CTable)((Object)this.handle)).getSelectionModel().addSelectionInterval(n2, n2);
        this.isAdjustingSelection = false;
    }

    public void select(int n2, int n3) {
        this.checkWidget();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        this.isAdjustingSelection = true;
        ((CTable)((Object)this.handle)).getSelectionModel().addSelectionInterval(n2, n3);
        this.isAdjustingSelection = false;
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (!this.itemList.isEmpty()) {
            this.isAdjustingSelection = true;
            ((CTable)((Object)this.handle)).getSelectionModel().addSelectionInterval(0, this.itemList.size() - 1);
            this.isAdjustingSelection = false;
        }
    }

    public void setColumnOrder(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length != (n2 = this.getColumnCount())) {
            this.error(5);
        }
        ((CTable)((Object)this.handle)).setColumnOrder(nArray);
    }

    void setFocusIndex(int n2) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        DefaultListSelectionModel defaultListSelectionModel = ((CTable)((Object)this.handle)).getSelectionModel();
        defaultListSelectionModel.addSelectionInterval(n2, n2);
        defaultListSelectionModel.setAnchorSelectionIndex(n2);
        defaultListSelectionModel.setLeadSelectionIndex(n2);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        ((CTable)((Object)this.handle)).setHeaderVisible(bl);
    }

    public void setItemCount(int n2) {
        this.checkWidget();
        n2 = Math.max(0, n2);
        int n3 = this.getItemCount();
        if (n2 == n3) {
            return;
        }
        boolean bl = (this.style & 0x10000000) != 0;
        int n4 = n2;
        for (int i2 = n3; n4 < i2; --i2) {
            TableItem tableItem = (TableItem)this.itemList.get(i2 - 1);
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(true);
                continue;
            }
            this.itemList.remove(n4);
            ((CTable)((Object)this.handle)).removeItem(n4);
        }
        this.itemList.ensureCapacity(n2);
        for (int i3 = n3; i3 < n2; ++i3) {
            if (bl) {
                this.itemList.add(null);
                ((CTable)((Object)this.handle)).addItem(i3);
                continue;
            }
            new TableItem(this, 0, i3, true);
        }
        ((CTable)((Object)this.handle)).getModel().fireTableDataChanged();
    }

    void setItemHeight(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(5);
        }
        ((CTable)((Object)this.handle)).setRowHeight(n2);
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        ((CTable)((Object)this.handle)).setGridVisible(bl);
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray);
        int n3 = nArray[0];
        if (n3 != -1) {
            this.setFocusIndex(n3);
        }
        this.showSelection();
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.isAdjustingSelection = true;
        this.deselectAll();
        this.isAdjustingSelection = false;
        int n2 = tableItemArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        int n3 = -1;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n4 = this.indexOf(tableItemArray[i2]);
            if (n4 == -1) continue;
            n3 = n4;
            this.select(n3);
        }
        if (n3 != -1) {
            this.setFocusIndex(n3);
        }
        this.showSelection();
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.deselectAll();
        this.select(n2);
        if (n2 != -1) {
            this.setFocusIndex(n2);
        }
        this.showSelection();
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        this.deselectAll();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        ((CTable)((Object)this.handle)).getSelectionModel().setSelectionInterval(n2, n3);
        this.showSelection();
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        this.sortColumn = tableColumn;
        this.handle.repaint();
    }

    public void setSortDirection(int n2) {
        this.checkWidget();
        if ((n2 & 0x480) == 0 && n2 != 0) {
            return;
        }
        this.sortDirection = n2;
        this.handle.repaint();
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        ((CTable)((Object)this.handle)).setTopIndex(n2);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        int n2 = this.indexOf(tableColumn);
        if (n2 == -1) {
            return;
        }
        ((CTable)((Object)this.handle)).ensureColumnVisible(n2);
    }

    public void showItem(TableItem tableItem) {
        int n2;
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n2 = this.indexOf(tableItem)) != -1) {
            ((CTable)((Object)this.handle)).ensureRowVisible(n2);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n2 = this.getSelectionIndex();
        if (n2 == -1) {
            return;
        }
        ((CTable)((Object)this.handle)).ensureRowVisible(n2);
    }

    static int checkStyle(int n2) {
        return Table.checkBits(n2 |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        block37: {
            block36: {
                if (!(eventObject instanceof CTable.CellPaintEvent)) break block36;
                switch (((CTable.CellPaintEvent)eventObject).getType()) {
                    case 1: {
                        if (!this.hooks(40)) {
                            super.processEvent(eventObject);
                            return;
                        }
                        break block37;
                    }
                    case 2: {
                        if (!this.hooks(42)) {
                            super.processEvent(eventObject);
                            return;
                        }
                        break block37;
                    }
                    case 3: {
                        if (!this.hooks(41)) {
                            super.processEvent(eventObject);
                            return;
                        }
                        break block37;
                    }
                    default: {
                        super.processEvent(eventObject);
                        return;
                    }
                }
            }
            if (eventObject instanceof ListSelectionEvent) {
                if (!this.hooks(13) || this.isAdjustingSelection) {
                    super.processEvent(eventObject);
                    return;
                }
            } else {
                super.processEvent(eventObject);
                return;
            }
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(eventObject);
            return;
        }
        try {
            if (eventObject instanceof CTable.CellPaintEvent) {
                CTable.CellPaintEvent cellPaintEvent = (CTable.CellPaintEvent)eventObject;
                switch (cellPaintEvent.getType()) {
                    case 1: {
                        TableItem tableItem = cellPaintEvent.tableItem.getTableItem();
                        Rectangle rectangle = tableItem.getBounds(cellPaintEvent.column);
                        Event event = new Event();
                        event.x = rectangle.x;
                        event.y = rectangle.y;
                        event.width = rectangle.width;
                        event.height = rectangle.height;
                        event.item = tableItem;
                        event.index = cellPaintEvent.column;
                        if (!cellPaintEvent.ignoreDrawForeground) {
                            event.detail |= 0x10;
                        }
                        if (!cellPaintEvent.ignoreDrawBackground) {
                            event.detail |= 8;
                        }
                        if (!cellPaintEvent.ignoreDrawSelection) {
                            event.detail |= 2;
                        }
                        if (!cellPaintEvent.ignoreDrawFocused) {
                            event.detail |= 4;
                        }
                        event.gc = new GC(this);
                        event.gc.handle.setUserClip(((CTable)((Object)this.handle)).getCellRect(cellPaintEvent.row, cellPaintEvent.column, false));
                        this.sendEvent(40, event);
                        if (event.doit) {
                            cellPaintEvent.ignoreDrawForeground = (event.detail & 0x10) == 0;
                            cellPaintEvent.ignoreDrawBackground = (event.detail & 8) == 0;
                            cellPaintEvent.ignoreDrawSelection = (event.detail & 2) == 0;
                            cellPaintEvent.ignoreDrawFocused = (event.detail & 4) == 0;
                            break;
                        }
                        cellPaintEvent.ignoreDrawForeground = true;
                        cellPaintEvent.ignoreDrawBackground = true;
                        cellPaintEvent.ignoreDrawSelection = true;
                        cellPaintEvent.ignoreDrawFocused = true;
                        break;
                    }
                    case 2: {
                        TableItem tableItem = cellPaintEvent.tableItem.getTableItem();
                        Rectangle rectangle = tableItem.getBounds(cellPaintEvent.column);
                        Event event = new Event();
                        event.x = rectangle.x;
                        event.y = rectangle.y;
                        event.width = rectangle.width;
                        event.height = rectangle.height;
                        event.item = tableItem;
                        event.index = cellPaintEvent.column;
                        if (!cellPaintEvent.ignoreDrawForeground) {
                            event.detail |= 0x10;
                        }
                        if (!cellPaintEvent.ignoreDrawBackground) {
                            event.detail |= 8;
                        }
                        if (!cellPaintEvent.ignoreDrawSelection) {
                            event.detail |= 2;
                        }
                        if (!cellPaintEvent.ignoreDrawFocused) {
                            event.detail |= 4;
                        }
                        event.gc = new GC(this);
                        event.gc.handle.setUserClip(((CTable)((Object)this.handle)).getCellRect(cellPaintEvent.row, cellPaintEvent.column, false));
                        this.sendEvent(42, event);
                        break;
                    }
                    case 3: {
                        TableItem tableItem = cellPaintEvent.tableItem.getTableItem();
                        Event event = new Event();
                        event.height = cellPaintEvent.rowHeight;
                        event.item = tableItem;
                        event.index = cellPaintEvent.column;
                        event.gc = new GC(this);
                        this.sendEvent(41, event);
                        cellPaintEvent.rowHeight = event.height;
                    }
                }
            } else if (eventObject instanceof ListSelectionEvent && !((ListSelectionEvent)eventObject).getValueIsAdjusting()) {
                Event event = new Event();
                int n2 = ((CTable)((Object)this.handle)).getSelectionModel().getLeadSelectionIndex();
                if (n2 != -1) {
                    event.item = this._getItem(n2);
                }
                this.sendEvent(13, event);
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        Object object;
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 401: {
                object = (KeyEvent)aWTEvent;
                if (((KeyEvent)object).getKeyCode() == 10 && ((CTable)((Object)this.handle)).getSelectionModel().getLeadSelectionIndex() != -1 && this.hooks(14)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 501: {
                object = (MouseEvent)aWTEvent;
                if (((AWTEvent)object).getID() == 501 && ((MouseEvent)object).getClickCount() == 2 && ((CTable)((Object)this.handle)).getSelectionModel().getLeadSelectionIndex() != -1 && this.hooks(14)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 701: {
                if (this.hooks(13) && !this.isAdjustingSelection) break;
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            switch (n2) {
                case 401: {
                    if (((CTable)((Object)this.handle)).getSelectionModel().getLeadSelectionIndex() == -1) break;
                    object = new Event();
                    ((Event)object).item = this._getItem(((CTable)((Object)this.handle)).getSelectionModel().getLeadSelectionIndex());
                    this.sendEvent(14, (Event)object);
                    break;
                }
                case 501: {
                    if (((CTable)((Object)this.handle)).getSelectionModel().getLeadSelectionIndex() == -1) break;
                    object = new Event();
                    ((Event)object).item = this._getItem(((CTable)((Object)this.handle)).getSelectionModel().getLeadSelectionIndex());
                    this.sendEvent(14, (Event)object);
                    break;
                }
                case 701: {
                    object = new Event();
                    ((Event)object).detail = 32;
                    ((Event)object).item = ((CTableItem)((ItemEvent)aWTEvent).getItem()).getTableItem();
                    this.sendEvent(13, (Event)object);
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

