/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.RootPaneContainer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CCombo;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    public static final int LIMIT = Integer.MAX_VALUE;
    boolean isAdjustingSelection;

    public Combo(Composite composite, int n2) {
        super(composite, Combo.checkStyle(n2));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.isAdjustingSelection = true;
        ((CCombo)((Object)this.handle)).addItem(string);
        this.isAdjustingSelection = false;
    }

    public void add(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.isAdjustingSelection = true;
        ((CCombo)((Object)this.handle)).insertElementAt(string, n2);
        this.isAdjustingSelection = false;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n2) {
        n2 &= 0xFFFFFCFF;
        if (((n2 = Combo.checkBits(n2, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n2 & 0xFFFFFFF7;
        }
        return n2;
    }

    public void clearSelection() {
        this.checkWidget();
        this.isAdjustingSelection = true;
        ((CCombo)((Object)this.handle)).setEditorCaretPosition(0);
        this.isAdjustingSelection = false;
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        if ((this.style & 0x40) != 0) {
            return super.computeSize(n2, n3, bl);
        }
        Dimension dimension = this.handle.getPreferredSize();
        if (n2 == -1) {
            return new Point(dimension.width, dimension.height);
        }
        Point point = super.computeSize(n2, n3, bl);
        return new Point(point.x, dimension.height);
    }

    public void copy() {
        this.checkWidget();
        ((CCombo)((Object)this.handle)).copyEditor();
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state &= 0xFFFFFEFD;
    }

    protected Container createHandle() {
        return (Container)((Object)CCombo.Factory.newInstance(this, this.style));
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        ((CCombo)((Object)this.handle)).cutEditor();
    }

    public void deselect(int n2) {
        this.checkWidget();
        CCombo cCombo = (CCombo)((Object)this.handle);
        if (n2 == cCombo.getSelectedIndex()) {
            this.isAdjustingSelection = true;
            cCombo.setSelectedIndex(-1);
            this.isAdjustingSelection = false;
            this.sendEvent(24);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.isAdjustingSelection = true;
        ((CCombo)((Object)this.handle)).clearEditorSelection();
        this.isAdjustingSelection = false;
        this.sendEvent(24);
    }

    public String getItem(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(8);
        }
        try {
            return (String)((CCombo)((Object)this.handle)).getItemAt(n2);
        }
        catch (Exception exception) {
            this.error(6);
            return "";
        }
    }

    public int getItemCount() {
        this.checkWidget();
        return ((CCombo)((Object)this.handle)).getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        Utils.notImplemented();
        return 15;
    }

    public String[] getItems() {
        this.checkWidget();
        int n2 = this.getItemCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.getItem(i2);
        }
        return stringArray;
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, this.getText().length());
        }
        CCombo cCombo = (CCombo)((Object)this.handle);
        return new Point(cCombo.getEditorSelectionStart(), cCombo.getEditorSelectionEnd());
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return ((CCombo)((Object)this.handle)).getSelectedIndex();
    }

    public String getText() {
        this.checkWidget();
        return ((CCombo)((Object)this.handle)).getEditorText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return ((CCombo)((Object)this.handle)).getEditorSize().height;
    }

    public int getTextLimit() {
        this.checkWidget();
        return ((CCombo)((Object)this.handle)).getEditorTextLimit();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return ((CCombo)((Object)this.handle)).getMaximumRowCount();
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getItemCount();
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!string.equals(this.getItem(i2))) continue;
            return i2;
        }
        return -1;
    }

    Point minimumSize(int n2, int n3, boolean bl) {
        Dimension dimension = this.handle.getPreferredSize();
        if ((this.style & 0x40) != 0) {
            return new Point(dimension.width, dimension.height);
        }
        Point point = super.minimumSize(n2, n3, bl);
        point.y = dimension.height;
        return point;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        ((CCombo)((Object)this.handle)).pasteEditor();
    }

    public void remove(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(15);
        }
        this.isAdjustingSelection = true;
        ((CCombo)((Object)this.handle)).removeItemAt(n2);
        this.isAdjustingSelection = false;
        this.sendEvent(24);
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = this.getItemCount();
        if (0 > n2 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        this.isAdjustingSelection = true;
        CCombo cCombo = (CCombo)((Object)this.handle);
        for (int i2 = n2; i2 <= n3; ++i2) {
            cCombo.removeItemAt(i2);
        }
        this.isAdjustingSelection = false;
    }

    public void remove(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n2);
    }

    public void removeAll() {
        this.checkWidget();
        this.isAdjustingSelection = true;
        ((CCombo)((Object)this.handle)).removeAllItems();
        this.isAdjustingSelection = false;
        this.sendEvent(24);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n2) {
        CCombo cCombo;
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 <= n2 && n2 < n3 && n2 != (cCombo = (CCombo)((Object)this.handle)).getSelectedIndex()) {
            this.isAdjustingSelection = true;
            cCombo.setSelectedIndex(n2);
            this.isAdjustingSelection = false;
            this.sendEvent(24);
        }
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.remove(n2);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, n2);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] != null) continue;
            this.error(5);
        }
        this.isAdjustingSelection = true;
        CCombo cCombo = (CCombo)((Object)this.handle);
        cCombo.removeAllItems();
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            cCombo.addItem(stringArray[i3]);
        }
        this.isAdjustingSelection = false;
        this.sendEvent(24);
    }

    public void setOrientation(int n2) {
        this.checkWidget();
        int n3 = 0x6000000;
        if ((n2 & n3) == 0 || (n2 & n3) == n3) {
            return;
        }
        this.style &= ~n3;
        this.style |= n2 & n3;
        ComponentOrientation componentOrientation = (this.style & 0x4000000) != 0 ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
        ((CCombo)((Object)this.handle)).setComponentOrientation(componentOrientation);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        CCombo cCombo = (CCombo)((Object)this.handle);
        cCombo.setEditorSelectionStart(point.x);
        cCombo.setEditorSelectionEnd(point.y);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n2 = this.indexOf(string);
            if (n2 != -1) {
                this.select(n2);
            }
            return;
        }
        ((CCombo)((Object)this.handle)).setEditorText(string);
        this.sendEvent(24);
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            this.error(7);
        }
        ((CCombo)((Object)this.handle)).setEditorTextLimit(n2);
    }

    public void setVisibleItemCount(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        ((CCombo)((Object)this.handle)).setMaximumRowCount(n2);
    }

    boolean traverseEscape() {
        if ((this.style & 4) != 0) {
            return ((CCombo)((Object)this.handle)).isPopupVisible();
        }
        return super.traverseEscape();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 1001: {
                if (this.hooks(31) || this.hooks(14)) break;
                super.processEvent(aWTEvent);
                JButton jButton = ((RootPaneContainer)((Object)this.getShell().handle)).getRootPane().getDefaultButton();
                if (jButton != null) {
                    jButton.doClick();
                }
                return;
            }
            case 701: {
                if (this.hooks(13) && !this.isAdjustingSelection) break;
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            switch (n2) {
                case 1001: {
                    JButton jButton;
                    Event event = new Event();
                    event.detail = 4;
                    this.sendEvent(31, event);
                    boolean bl = true;
                    if (event.doit && (jButton = ((RootPaneContainer)((Object)this.getShell().handle)).getRootPane().getDefaultButton()) != null) {
                        bl = false;
                        jButton.doClick();
                    }
                    if (!bl) break;
                    this.sendEvent(14);
                    break;
                }
                case 701: {
                    this.sendEvent(13);
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

