/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.eclipse.swt.internal.swing.JCoolBar;

public class JCoolBarItem
extends JToolBar {
    protected int xSpacing;
    protected Point mouseLocation;
    protected boolean isInGrip;
    protected boolean isDragging;
    protected boolean isWrapped;
    protected boolean isFloating;

    protected int getXSpacing() {
        return this.xSpacing;
    }

    protected void setXSpacing(int n2) {
        this.xSpacing = n2;
    }

    protected JCoolBar getCoolBar() {
        return (JCoolBar)super.getParent();
    }

    public ComponentOrientation getComponentOrientation() {
        Container container = this.getParent();
        if (container != null) {
            return container.getComponentOrientation();
        }
        return super.getComponentOrientation();
    }

    public JCoolBarItem() {
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i2 = 0; i2 < mouseListenerArray.length; ++i2) {
            this.removeMouseListener(mouseListenerArray[i2]);
        }
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        for (int i3 = 0; i3 < mouseMotionListenerArray.length; ++i3) {
            this.removeMouseMotionListener(mouseMotionListenerArray[i3]);
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e2) {
                JCoolBarItem.this.isInGrip = JCoolBarItem.this.isInGrip(e2.getPoint());
            }

            public void mouseExited(MouseEvent e2) {
                JCoolBarItem.this.isInGrip = false;
            }

            public void mousePressed(MouseEvent e2) {
                if (!JCoolBarItem.this.isLocked() && JCoolBarItem.this.isInGrip && (e2.getModifiers() & 0x10) != 0) {
                    JCoolBarItem.this.isDragging = true;
                    if (!JCoolBarItem.this.isFloating) {
                        JCoolBarItem.this.getCoolBar().processItemMouseEvent(e2);
                    } else {
                        JCoolBarItem.this.mouseLocation = e2.getPoint();
                    }
                }
            }

            public void mouseReleased(MouseEvent e2) {
                if (JCoolBarItem.this.isDragging && (e2.getModifiers() & 0x10) != 0) {
                    if (!JCoolBarItem.this.isFloating) {
                        JCoolBarItem.this.getCoolBar().processItemMouseEvent(e2);
                    } else {
                        JCoolBarItem.this.mouseLocation = null;
                    }
                    JCoolBarItem.this.isDragging = false;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e2) {
                if (JCoolBarItem.this.isDragging) {
                    if (!JCoolBarItem.this.isFloating) {
                        JCoolBarItem.this.getCoolBar().processItemMouseEvent(e2);
                    } else {
                        Point mouseLocation = e2.getPoint();
                        int offsetX = JCoolBarItem.this.mouseLocation.x - mouseLocation.x;
                        int offsetY = JCoolBarItem.this.mouseLocation.y - mouseLocation.y;
                        Window window = SwingUtilities.getWindowAncestor(JCoolBarItem.this);
                        Point location = window.getLocation();
                        window.setLocation(location.x - offsetX, location.y - offsetY);
                    }
                }
            }

            public void mouseMoved(MouseEvent e2) {
                JCoolBarItem.this.isInGrip = JCoolBarItem.this.isInGrip(e2.getPoint());
            }
        });
    }

    public Cursor getCursor() {
        if (!this.isLocked() && (this.isDragging || this.isInGrip || this.getCoolBar().isDragging())) {
            return JCoolBar.GRIP_CURSOR;
        }
        return super.getCursor();
    }

    private int getGripWidth() {
        return this.getInsets().left - 2;
    }

    private boolean isInGrip(Point point) {
        Rectangle rectangle = new Rectangle();
        int n2 = this.getGripWidth();
        int n3 = this.getComponentOrientation().isLeftToRight() ? 0 : this.getWidth() - n2;
        rectangle.setBounds(n3, 0, n2, this.getHeight());
        return rectangle.contains(point);
    }

    public void setLocked(boolean bl) {
        this.setFloatable(!bl);
    }

    public boolean isLocked() {
        return !this.isFloatable();
    }

    public void setWrapped(boolean bl) {
        this.isWrapped = bl;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (!this.isLocked()) {
            dimension.width += this.getGripWidth() + 2;
        }
        return dimension;
    }

    protected void setFloating(boolean bl, Point point) {
        if (bl == this.isFloating) {
            return;
        }
        if (this.getCoolBar() == null) {
            if (!bl) {
                this.isFloating = false;
            }
            return;
        }
        ToolBarUI toolBarUI = this.getUI();
        if (toolBarUI instanceof BasicToolBarUI) {
            Object object;
            this.isFloating = bl;
            if (bl && this.isWrapped()) {
                this.setWrapped(false);
                object = this.getCoolBar();
                int n2 = ((JCoolBar)object).getItemIndex(this);
                if (n2 + 1 < ((Container)object).getComponentCount()) {
                    ((JCoolBar)object).getItem(n2 + 1).setWrapped(true);
                }
            }
            object = (BasicToolBarUI)toolBarUI;
            ((BasicToolBarUI)object).setFloating(bl, null);
            if (bl) {
                Window window = SwingUtilities.getWindowAncestor(this);
                Point point2 = new Point(0, 0);
                if (this.xSpacing < 0) {
                    point2.x = -this.xSpacing;
                }
                point2 = SwingUtilities.convertPoint(this, point2, window);
                System.err.println(point.x + ", " + point2.x);
                window.setLocation(point.x - point2.x, point.y - point2.y);
                this.setXSpacing(0);
            }
        }
    }

    public Dimension getItemPreferredSize() {
        return this.getPreferredSize();
    }

    static /* synthetic */ boolean access$000(JCoolBarItem jCoolBarItem, Point point) {
        return jCoolBarItem.isInGrip(point);
    }
}

