/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class ComponentBorderResizer {
    protected ComponentBorderResizer() {
    }

    public static void handle(Component component, JComponent jComponent) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            protected boolean moveTop;
            protected boolean moveLeft;
            protected boolean moveBottom;
            protected boolean moveRight;
            protected Point originalLocation;
            protected static final int MIN_WIDTH = 100;
            protected static final int MIN_HEIGHT = 60;
            protected int THRESHOLD = 20;

            public void mousePressed(MouseEvent e2) {
                if (e2.getButton() != 1) {
                    return;
                }
                this.originalLocation = e2.getPoint();
            }

            public void mouseReleased(MouseEvent e2) {
                if (e2.getButton() != 1) {
                    return;
                }
                this.originalLocation = null;
            }

            public void mouseDragged(MouseEvent e2) {
                int minHeight;
                int diffY;
                int minWidth;
                Insets borderInsets;
                int diffX;
                if (this.originalLocation == null) {
                    return;
                }
                Rectangle bounds = component.getBounds();
                if (this.moveLeft) {
                    diffX = e2.getX() - this.originalLocation.x;
                    bounds.x += diffX;
                    bounds.width -= diffX;
                    borderInsets = borderedComponent.getBorder().getBorderInsets(borderedComponent);
                    minWidth = 100 + borderInsets.left + borderInsets.right;
                    if (bounds.width < minWidth) {
                        bounds.x -= minWidth - bounds.width;
                        bounds.width = minWidth;
                    }
                    component.setBounds(bounds);
                } else if (this.moveRight) {
                    diffX = e2.getX() - this.originalLocation.x;
                    this.originalLocation.x += diffX;
                    bounds.width += diffX;
                    borderInsets = borderedComponent.getBorder().getBorderInsets(borderedComponent);
                    minWidth = 100 + borderInsets.left + borderInsets.right;
                    if (bounds.width < minWidth) {
                        this.originalLocation.x += minWidth - bounds.width;
                        bounds.width = minWidth;
                    }
                    component.setBounds(bounds);
                }
                if (this.moveTop) {
                    diffY = e2.getY() - this.originalLocation.y;
                    bounds.y += diffY;
                    bounds.height -= diffY;
                    borderInsets = borderedComponent.getBorder().getBorderInsets(borderedComponent);
                    minHeight = 60 + borderInsets.top + borderInsets.bottom;
                    if (bounds.height < minHeight) {
                        bounds.y -= minHeight - bounds.height;
                        bounds.height = minHeight;
                    }
                    component.setBounds(bounds);
                } else if (this.moveBottom) {
                    diffY = e2.getY() - this.originalLocation.y;
                    this.originalLocation.y += diffY;
                    bounds.height += diffY;
                    borderInsets = borderedComponent.getBorder().getBorderInsets(borderedComponent);
                    minHeight = 60 + borderInsets.top + borderInsets.bottom;
                    if (bounds.height < minHeight) {
                        this.originalLocation.y += minHeight - bounds.height;
                        bounds.height = minHeight;
                    }
                    component.setBounds(bounds);
                }
            }

            public void mouseMoved(MouseEvent e2) {
                this.adjustResizing(e2.getPoint());
            }

            public void mouseEntered(MouseEvent e2) {
                this.adjustResizing(e2.getPoint());
            }

            public void mouseExited(MouseEvent e2) {
                this.adjustResizing(e2.getPoint());
            }

            protected void adjustResizing(Point point) {
                if (this.originalLocation != null) {
                    return;
                }
                this.moveTop = false;
                this.moveLeft = false;
                this.moveBottom = false;
                this.moveRight = false;
                Insets borderInsets = borderedComponent.getBorder().getBorderInsets(borderedComponent);
                Dimension size = borderedComponent.getSize();
                if (!new Rectangle(borderInsets.left, borderInsets.top, size.width - borderInsets.left - borderInsets.right, size.height - borderInsets.top - borderInsets.bottom).contains(point)) {
                    if (point.x < this.THRESHOLD) {
                        this.moveLeft = true;
                    } else if (point.x > size.width - this.THRESHOLD) {
                        this.moveRight = true;
                    }
                    if (point.y < this.THRESHOLD) {
                        this.moveTop = true;
                    } else if (point.y >= size.height - borderInsets.bottom) {
                        this.moveBottom = true;
                    }
                }
                if (this.moveTop && this.moveLeft || this.moveBottom && this.moveRight) {
                    borderedComponent.setCursor(Cursor.getPredefinedCursor(6));
                } else if (this.moveTop && this.moveRight || this.moveBottom && this.moveLeft) {
                    borderedComponent.setCursor(Cursor.getPredefinedCursor(7));
                } else if (this.moveTop || this.moveBottom) {
                    borderedComponent.setCursor(Cursor.getPredefinedCursor(8));
                } else if (this.moveLeft || this.moveRight) {
                    borderedComponent.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    borderedComponent.setCursor(null);
                }
            }
        };
        jComponent.addMouseListener(mouseInputAdapter);
        jComponent.addMouseMotionListener(mouseInputAdapter);
    }
}

