/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.swt.internal.swing.CComposite;
import org.eclipse.swt.internal.swing.CTreeImplementation;
import org.eclipse.swt.internal.swing.CTreeItem;
import org.eclipse.swt.internal.swing.DefaultMutableTreeTableNode;
import org.eclipse.swt.widgets.Tree;

public interface CTree
extends CComposite {
    public void clearSelection();

    public void selectAll();

    public TreeSelectionModel getSelectionModel();

    public void setGridVisible(boolean var1);

    public boolean isGridVisible();

    public JTableHeader getTableHeader();

    public void expandPath(TreePath var1);

    public void collapsePath(TreePath var1);

    public boolean isExpanded(TreePath var1);

    public DefaultMutableTreeTableNode getRoot();

    public DefaultTreeModel getModel();

    public Rectangle getCellRect(int var1, int var2, boolean var3);

    public int getRowForPath(TreePath var1);

    public TableColumnModel getColumnModel();

    public TreePath getPathForLocation(int var1, int var2);

    public int getPreferredColumnWidth(int var1);

    public int getRowHeight();

    public void setRowHeight(int var1);

    public void ensureRowVisible(int var1);

    public void ensureColumnVisible(int var1);

    public int getTopIndex();

    public void setTopIndex(int var1);

    public TreePath getPathForRow(int var1);

    public void setHeaderVisible(boolean var1);

    public void setColumnOrder(int[] var1);

    public int[] getColumnOrder();

    public Rectangle getImageBounds(int var1, int var2);

    public static class Factory {
        private Factory() {
        }

        public static CTree newInstance(Tree tree, int style) {
            return new CTreeImplementation(tree, style);
        }
    }

    public static class CellPaintEvent
    extends EventObject {
        public static final int ERASE_TYPE = 1;
        public static final int PAINT_TYPE = 2;
        public static final int MEASURE_TYPE = 3;
        protected int type;
        public int row;
        public int column;
        public CTreeItem treeItem;
        public boolean ignoreDrawForeground;
        public boolean ignoreDrawBackground;
        public boolean ignoreDrawSelection;
        public boolean ignoreDrawFocused;
        public int rowHeight;

        CellPaintEvent(Object source, int type) {
            super(source);
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

