/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.PaintEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.eclipse.swt.internal.swing.CComposite;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.UnmanagedScrollPane;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class CCompositeImplementation
extends JPanel
implements CComposite {
    protected Composite handle;
    protected JPanel contentPane;
    protected JScrollPane scrollPane;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this.contentPane;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CCompositeImplementation(Composite composite, int n2) {
        super(new BorderLayout(0, 0));
        this.handle = composite;
        this.init(n2);
    }

    public boolean isFocusable() {
        return this.contentPane.isFocusable();
    }

    public void requestFocus() {
        this.contentPane.requestFocus();
    }

    public void setCursor(Cursor cursor) {
        this.contentPane.setCursor(cursor);
    }

    protected void init(int n2) {
        if ((n2 & 0x800) != 0) {
            this.setBorder(LookAndFeelUtils.getStandardBorder());
        } else {
            this.setBorder(null);
        }
        JPanel jPanel = new JPanel(null){
            protected Graphics graphics;

            public Graphics getGraphics() {
                Graphics g2 = this.graphics != null ? this.graphics.create() : super.getGraphics();
                return g2;
            }

            public boolean isOptimizedDrawingEnabled() {
                return this.getComponentCount() < 2 || Utils.isFlatLayout(CCompositeImplementation.this.handle);
            }

            public boolean isOpaque() {
                return CCompositeImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                this.graphics = g2;
                this.putClientProperty("SWTSwingGraphics2DClientProperty", g2);
                if (!(this.getParent() instanceof JViewport)) {
                    Utils.paintTiledImage(this, g2, CCompositeImplementation.this.backgroundImageIcon);
                }
                super.paintComponent(g2);
                CCompositeImplementation.this.handle.processEvent(new PaintEvent(this, 800, null));
                this.putClientProperty("SWTSwingGraphics2DClientProperty", null);
                this.graphics = null;
            }

            public Color getBackground() {
                return CCompositeImplementation.this != null && CCompositeImplementation.this.userAttributeHandler != null && CCompositeImplementation.this.userAttributeHandler.background != null ? CCompositeImplementation.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CCompositeImplementation.this != null && CCompositeImplementation.this.userAttributeHandler != null && CCompositeImplementation.this.userAttributeHandler.foreground != null ? CCompositeImplementation.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CCompositeImplementation.this != null && CCompositeImplementation.this.userAttributeHandler != null && CCompositeImplementation.this.userAttributeHandler.font != null ? CCompositeImplementation.this.userAttributeHandler.font : super.getFont();
            }

            public Cursor getCursor() {
                if (Utils.globalCursor != null) {
                    return Utils.globalCursor;
                }
                return CCompositeImplementation.this != null && CCompositeImplementation.this.userAttributeHandler != null && CCompositeImplementation.this.userAttributeHandler.cursor != null ? CCompositeImplementation.this.userAttributeHandler.cursor : super.getCursor();
            }

            protected void processEvent(AWTEvent e2) {
                if (Utils.redispatchEvent(CCompositeImplementation.this.getSWTHandle(), e2)) {
                    return;
                }
                super.processEvent(e2);
            }
        };
        this.userAttributeHandler = new CControl.UserAttributeHandler(jPanel);
        if ((n2 & 0x300) != 0) {
            UnmanagedScrollPane unmanagedScrollPane = new UnmanagedScrollPane((n2 & 0x200) != 0 ? 22 : 21, (n2 & 0x100) != 0 ? 32 : 31){

                protected UnmanagedScrollPane.DisconnectedViewport createDisconnectedViewport() {
                    return new UnmanagedScrollPane.DisconnectedViewport(this){
                        protected boolean isCreated;
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            this.isCreated = true;
                        }

                        public boolean isOpaque() {
                            return 2.access$0(this.this$1).backgroundImageIcon == null && super.isOpaque();
                        }

                        protected void paintComponent(Graphics g2) {
                            Utils.paintTiledImage(this, g2, 2.access$0(this.this$1).backgroundImageIcon);
                            super.paintComponent(g2);
                        }

                        public Color getBackground() {
                            return this.isCreated ? 2.access$0(this.this$1).userAttributeHandler.background : super.getBackground();
                        }
                    };
                }

                static /* synthetic */ CCompositeImplementation access$0(2 var0) {
                    return var0.CCompositeImplementation.this;
                }
            };
            this.scrollPane = unmanagedScrollPane;
            unmanagedScrollPane.setBorder(null);
            this.add((Component)unmanagedScrollPane, "Center");
            unmanagedScrollPane.getViewport().setView(jPanel);
        } else {
            this.add((Component)jPanel, "Center");
        }
        this.contentPane = jPanel;
        this.contentPane.setFocusable(true);
        Utils.installMouseListener(this.contentPane, this.handle);
        Utils.installKeyListener(this.contentPane, this.handle);
        Utils.installFocusListener(this.contentPane, this.handle);
        Utils.installComponentListener(this, this.handle);
    }

    public Container getClientArea() {
        return this.contentPane;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane == null ? null : this.scrollPane.getVerticalScrollBar();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.scrollPane == null ? null : this.scrollPane.getHorizontalScrollBar();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                this.contentPane.setOpaque(true);
                if (this.scrollPane == null) break;
                this.scrollPane.setOpaque(true);
                this.scrollPane.getViewport().setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
                this.contentPane.setOpaque(false);
                if (this.scrollPane == null) break;
                this.scrollPane.setOpaque(false);
                this.scrollPane.getViewport().setOpaque(false);
            }
        }
    }
}

