/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.swing.CGC;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class GC
extends Resource {
    public CGC handle;
    Drawable drawable;
    GCData data;
    private AffineTransform saveAT;
    private AffineTransform gcAT;
    private int fillRule = 1;
    boolean isXORMode = false;
    static final float[] lineDashArray = new float[]{18.0f, 6.0f};
    static final float[] lineDotArray = new float[]{3.0f, 3.0f};
    static final float[] lineDashDotArray = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] lineDashDotDotArray = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n2) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n2);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = gCData.device = device;
        CGC cGC = drawable.internal_new_GC(gCData);
        if (cGC == null) {
            SWT.error(2);
        }
        gCData.background = java.awt.Color.WHITE;
        this.init(drawable, gCData, cGC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x2000000) != 0) {
            n2 &= 0xFBFFFFFF;
        }
        return n2 & 0x6000000;
    }

    public void copyArea(Image image, int n2, int n3) {
        if (this.drawable instanceof Control) {
            Control control = (Control)this.drawable;
            Graphics graphics = image.handle.getGraphics();
            graphics.translate(-n2, -n3);
            control.handle.paint(graphics);
            graphics.translate(n2, n3);
            return;
        }
        if (this.drawable instanceof Display) {
            Rectangle rectangle = image.getBounds();
            try {
                image.handle = new Robot().createScreenCapture(new java.awt.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            return;
        }
        if (this.handle == null) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Composite composite = this.handle.getComposite();
        Composite composite2 = new Composite(){

            public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
                return new CompositeContext(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
                    }

                    public void dispose() {
                    }
                };
            }
        };
        this.handle.setComposite(composite2);
        this.handle.setComposite(composite);
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.copyArea(n2, n3, n4, n5, n6, n7, true);
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.handle.copyArea(n2, n3, n4, n5, n6 - n2, n7 - n3);
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        this.handle.dispose();
        Device device = this.data.device;
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data = null;
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
        }
        if (n4 == 0 || n5 == 0 || n7 == 0) {
            return;
        }
        this.handle.drawArc(n2, n3, n4, n5, n6, n7);
    }

    public void drawFocus(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        java.awt.Color color = this.handle.getColor();
        this.handle.setColor(LookAndFeelUtils.getFocusColor());
        this.handle.drawRect(n2, n3, n4, n5);
        this.handle.setColor(color);
    }

    public void drawImage(Image image, int n2, int n3) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n2, n3, -1, -1, true);
    }

    public void drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 == 0 || n5 == 0 || n8 == 0 || n9 == 0) {
            return;
        }
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n8 < 0 || n9 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, false);
    }

    void drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        if (n4 == -1) {
            n4 = image.handle.getWidth();
        }
        if (n5 == -1) {
            n5 = image.handle.getHeight();
        }
        if (n8 == -1) {
            n8 = n4;
        }
        if (n9 == -1) {
            n9 = n5;
        }
        if (!bl || n4 == n8 && n5 == n9) {
            this.handle.drawImage(image.handle, n6, n7, n6 + n8, n7 + n9, n2, n3, n2 + n4, n3 + n5, null);
        } else {
            this.handle.drawImage(image.handle, n6, n7, n6 + n8, n7 + n9, n2, n3, n2 + n4, n3 + n5, null);
        }
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.handle.drawLine(n2, n3, n4, n5);
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.handle.drawOval(n2, n3, n4, n5);
    }

    public void drawPath(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path.handle == null) {
            SWT.error(5);
        }
        this.handle.draw(path.handle);
    }

    public void drawPoint(int n2, int n3) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.handle.drawLine(n2, n3, n2, n3);
    }

    public void drawPolygon(int[] nArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int[] nArray2 = new int[nArray.length / 2];
        int[] nArray3 = new int[nArray2.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = nArray[i2 * 2];
            nArray3[i2] = nArray[i2 * 2 + 1];
        }
        this.handle.drawPolygon(nArray2, nArray3, nArray2.length);
    }

    public void drawPolyline(int[] nArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int[] nArray2 = new int[nArray.length / 2];
        int[] nArray3 = new int[nArray2.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = nArray[i2 * 2];
            nArray3[i2] = nArray[i2 * 2 + 1];
        }
        this.handle.drawPolyline(nArray2, nArray3, nArray2.length);
    }

    public void drawRectangle(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.handle.drawRect(n2, n3, n4, n5);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.handle.drawRoundRect(n2, n3, n4, n5, n6, n7);
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, n2, n3, false);
    }

    public void drawString(String string, int n2, int n3, boolean bl) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.drawText(string, n2, n3, bl ? 1 : 0);
    }

    public void drawText(String string, int n2, int n3) {
        this.drawText(string, n2, n3, 6);
    }

    public void drawText(String string, int n2, int n3, boolean bl) {
        int n4 = 6;
        if (bl) {
            n4 |= 1;
        }
        this.drawText(string, n2, n3, n4);
    }

    public void drawText(String string, int n2, int n3, int n4) {
        Object object;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        if ((n4 & 4) != 0) {
            string = string.replaceAll("\t", "    ");
        }
        int n5 = -1;
        if ((n4 & 8) != 0) {
            n5 = this.findMnemonicIndex(string);
            if (n5 > 0) {
                object = string.substring(0, n5 - 1).replaceAll("&&", "&");
                string = (String)object + string.substring(n5).replaceAll("&&", "&");
                n5 -= n5 - 1 - ((String)object).length();
                --n5;
            } else {
                string = string.replaceAll("&&", "&");
            }
        }
        object = (n4 & 2) != 0 ? string.split("\n") : new String[]{string};
        boolean bl = (n4 & 1) != 0;
        java.awt.FontMetrics fontMetrics = this.handle.getFontMetrics();
        int n6 = fontMetrics.getHeight();
        int n7 = fontMetrics.getMaxAscent();
        int n8 = 0;
        for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
            n3 += n8;
            n8 += n6;
            if (!bl) {
                java.awt.Color color = this.handle.getColor();
                this.handle.setColor(this.data.background);
                this.fillRectangle(n2, n3, this.stringExtent((String)object[i2]).x, n8);
                this.handle.setColor(color);
            }
            this.handle.drawString((String)object[i2], n2, n3 + n7);
        }
    }

    int findMnemonicIndex(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return -1;
            }
            if (string.charAt(n2) != '&') {
                return n2;
            }
            if (++n2 >= n3) break;
        }
        return -1;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
        }
        if (n4 == 0 || n5 == 0 || n7 == 0) {
            return;
        }
        java.awt.Color color = this.handle.getColor();
        this.handle.setColor(this.data.background);
        this.handle.fillArc(n2, n3, n4, n5, n6, n7);
        this.handle.setColor(color);
    }

    public void fillGradientRectangle(int n2, int n3, int n4, int n5, boolean bl) {
        java.awt.Point point;
        java.awt.Point point2;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        java.awt.Color color = this.handle.getColor();
        java.awt.Color color2 = this.handle.getBackground();
        Paint paint = this.handle.getPaint();
        if (bl) {
            point2 = new java.awt.Point(n2, n3);
            point = new java.awt.Point(n2, n3 + n5);
        } else {
            point2 = new java.awt.Point(n2, n3);
            point = new java.awt.Point(n2 + n4, n3);
        }
        this.handle.setPaint(new GradientPaint(point2, color, point, color2));
        this.handle.fill(new java.awt.Rectangle(n2, n3, n4, n5));
        this.handle.setPaint(paint);
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        java.awt.Color color = this.handle.getColor();
        this.handle.setColor(this.data.background);
        this.handle.fillOval(n2, n3, n4, n5);
        this.handle.setColor(color);
    }

    public void fillPath(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path.handle == null) {
            SWT.error(5);
        }
        int n2 = this.fillRule == 1 ? 0 : 1;
        path.handle.setWindingRule(n2);
        Paint paint = this.handle.getPaint();
        this.handle.setPaint(this.handle.getBackground());
        this.handle.fill(path.handle);
        this.handle.setPaint(paint);
    }

    public void fillPolygon(int[] nArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int[] nArray2 = new int[nArray.length / 2];
        int[] nArray3 = new int[nArray2.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = nArray[i2 * 2];
            nArray3[i2] = nArray[i2 * 2 + 1];
            n2 = Math.max(n2, nArray2[i2]);
            n3 = Math.max(n3, nArray3[i2]);
            n4 = Math.min(n4, nArray2[i2]);
            n5 = Math.min(n5, nArray3[i2]);
        }
        java.awt.Color color = this.handle.getColor();
        this.handle.setColor(this.data.background);
        this.handle.fillPolygon(nArray2, nArray3, nArray2.length);
        this.handle.setColor(color);
    }

    public void fillRectangle(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        java.awt.Color color = this.handle.getColor();
        this.handle.setColor(this.data.background);
        this.handle.fillRect(n2, n3, n4, n5);
        this.handle.setColor(color);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        java.awt.Color color = this.handle.getColor();
        this.handle.setColor(this.data.background);
        this.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.handle.setColor(color);
    }

    public void fillRoundRectangle(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.handle == null) {
            SWT.error(44);
        }
        java.awt.Color color = this.handle.getColor();
        this.handle.setColor(this.data.background);
        this.handle.fillRoundRect(n2, n3, n4, n5, n6, n7);
        this.handle.setColor(color);
    }

    public int getAdvanceWidth(char c2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.handle.getFontMetrics().charWidth(c2);
    }

    public boolean getAdvanced() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.advanced;
    }

    public int getAlpha() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        Object object;
        if (this.handle == null) {
            SWT.error(44);
        }
        if ((object = this.handle.getRenderingHint(RenderingHints.KEY_ANTIALIASING)) == RenderingHints.VALUE_ANTIALIAS_OFF) {
            return 0;
        }
        if (object == RenderingHints.VALUE_ANTIALIAS_ON) {
            return 1;
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return Color.swing_new(this.data.device, this.handle.getBackground());
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char c2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.handle.getFontMetrics().charWidth(c2);
    }

    public Rectangle getClipping() {
        Shape shape;
        if (this.handle == null) {
            SWT.error(44);
        }
        java.awt.Rectangle rectangle = (shape = this.handle.getUserClip()) != null ? shape.getBounds() : new java.awt.Rectangle(this.handle.getDeviceSize());
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void getClipping(Region region) {
        Shape shape;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if ((shape = this.handle.getUserClip()) == null) {
            shape = new java.awt.Rectangle(this.handle.getDeviceSize());
        }
        region.add(new Region(this.data.device, shape));
    }

    public int getFillRule() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.fillRule;
    }

    public Font getFont() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return Font.swing_new(this.data.device, this.handle.getFont());
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return FontMetrics.swing_new(this.handle.getFontMetrics());
    }

    public Color getForeground() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return Color.swing_new(this.data.device, this.handle.getColor());
    }

    public Pattern getForegroundPattern() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == null) {
            SWT.error(44);
        }
        Utils.notImplemented();
        return -1;
    }

    public int getLineCap() {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (this.getCurrentBasicStroke().getEndCap()) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 1;
    }

    public int[] getLineDash() {
        float[] fArray;
        if (this.handle == null) {
            SWT.error(44);
        }
        if ((fArray = this.getCurrentBasicStroke().getDashArray()) == null) {
            return null;
        }
        int[] nArray = new int[fArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = Math.round(fArray[i2]);
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (this.getCurrentBasicStroke().getLineJoin()) {
            case 2: {
                return 3;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public int getLineStyle() {
        float[] fArray;
        if (this.handle == null) {
            SWT.error(44);
        }
        if ((fArray = this.getCurrentBasicStroke().getDashArray()) == null) {
            return 1;
        }
        if (fArray == lineDashArray) {
            return 2;
        }
        if (fArray == lineDotArray) {
            return 3;
        }
        if (fArray == lineDashDotArray) {
            return 4;
        }
        if (fArray == lineDashDotDotArray) {
            return 5;
        }
        if (fArray != null && fArray == this.data.dashes) {
            return 6;
        }
        return 1;
    }

    public int getLineWidth() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return (int)this.getCurrentBasicStroke().getLineWidth();
    }

    public int getStyle() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        Object object;
        if (this.handle == null) {
            SWT.error(44);
        }
        if ((object = this.handle.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
            return 0;
        }
        if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
            return 1;
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        transform.handle = this.gcAT == null ? new AffineTransform() : new AffineTransform(this.gcAT);
    }

    public boolean getXORMode() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.isXORMode;
    }

    void init(Drawable drawable, GCData gCData, CGC cGC) {
        if (gCData.foreground != null) {
            cGC.setColor(gCData.foreground);
        }
        if (gCData.background != null) {
            cGC.setBackground(gCData.background);
        }
        if (gCData.hFont != null) {
            cGC.setFont(gCData.hFont);
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = cGC;
    }

    public int hashCode() {
        return this.handle == null ? 0 : this.handle.hashCode();
    }

    public boolean isClipped() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.handle.getUserClip() != null;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public void setAdvanced(boolean bl) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.data.advanced = bl;
    }

    public void setAntialias(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (n2) {
            case -1: {
                this.handle.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                break;
            }
            case 0: {
                this.handle.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 1: {
                this.handle.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    public void setAlpha(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.data.alpha = n2 & 0xFF;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, (float)this.data.alpha / 255.0f);
        this.handle.setComposite(alphaComposite);
    }

    public void setBackground(Color color) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.handle.setBackground(color.handle);
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        Utils.notImplemented();
        this.data.backgroundPattern = pattern;
    }

    public void setClipping(int n2, int n3, int n4, int n5) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.setClipping(new Rectangle(n2, n3, n4, n5));
    }

    public void setClipping(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.handle.setUserClip(path.handle);
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == null) {
            SWT.error(44);
        }
        java.awt.Rectangle rectangle2 = rectangle == null ? null : new java.awt.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.handle.setUserClip(rectangle2);
    }

    public void setClipping(Region region) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.handle.setUserClip(region.handle);
    }

    public void setFillRule(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.fillRule = n2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    public void setFont(Font font) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (font == null) {
            this.handle.setFont(LookAndFeelUtils.getSystemFont());
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            this.handle.setFont(font.handle);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.handle.setColor(color.handle);
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        Utils.notImplemented();
        this.data.foregroundPattern = pattern;
    }

    public void setInterpolation(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        Utils.notImplemented();
    }

    public void setLineCap(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        BasicStroke basicStroke = this.getCurrentBasicStroke();
        int n3 = 0;
        switch (n2) {
            case 2: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 0;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle.setStroke(new BasicStroke(basicStroke.getLineWidth(), n3, basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), 0.0f));
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        BasicStroke basicStroke = this.getCurrentBasicStroke();
        if (nArray == null) {
            nArray = new int[]{};
        }
        this.data.dashes = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.data.dashes[i2] = nArray[i2];
        }
        this.handle.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), this.data.dashes, 0.0f));
    }

    public void setLineJoin(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        BasicStroke basicStroke = this.getCurrentBasicStroke();
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), n3, basicStroke.getMiterLimit(), basicStroke.getDashArray(), 0.0f));
    }

    public void setLineStyle(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        BasicStroke basicStroke = this.getCurrentBasicStroke();
        float[] fArray = null;
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                fArray = lineDashArray;
                break;
            }
            case 3: {
                fArray = lineDotArray;
                break;
            }
            case 4: {
                fArray = lineDashDotArray;
                break;
            }
            case 5: {
                fArray = lineDashDotDotArray;
                break;
            }
            case 6: {
                fArray = this.data.dashes;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), fArray, 0.0f));
    }

    public void setLineWidth(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        BasicStroke basicStroke = this.getCurrentBasicStroke();
        this.handle.setStroke(new BasicStroke(n2, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
    }

    public void setXORMode(boolean bl) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (bl) {
            this.handle.setXORMode(this.getBackground().handle);
        } else {
            this.handle.setPaintMode();
        }
        this.isXORMode = bl;
    }

    public void setTextAntialias(int n2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (n2) {
            case -1: {
                this.handle.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                break;
            }
            case 0: {
                this.handle.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                break;
            }
            case 1: {
                this.handle.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    public void setTransform(Transform transform) {
        AffineTransform affineTransform;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.saveAT == null) {
            this.saveAT = this.handle.getTransform();
        } else {
            this.handle.setTransform(this.saveAT);
        }
        if (transform == null) {
            affineTransform = new AffineTransform();
            this.gcAT = null;
        } else {
            this.gcAT = affineTransform = transform.handle;
        }
        this.handle.transform(affineTransform);
    }

    public Point stringExtent(String string) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int n2) {
        int n3;
        Object object;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((n2 & 4) != 0) {
            string = string.replaceAll("\t", "    ");
        }
        int n4 = -1;
        if ((n2 & 8) != 0) {
            n4 = this.findMnemonicIndex(string);
            if (n4 > 0) {
                object = string.substring(0, n4 - 1).replaceAll("&&", "&");
                string = (String)object + string.substring(n4).replaceAll("&&", "&");
                n4 -= n4 - 1 - ((String)object).length();
                --n4;
            } else {
                string = string.replaceAll("&&", "&");
            }
        }
        object = (n2 & 2) != 0 ? string.split("\n") : new String[]{string};
        java.awt.FontMetrics fontMetrics = this.handle.getFontMetrics();
        int n5 = n3 = fontMetrics.getHeight();
        int n6 = 0;
        int n7 = 0;
        FontRenderContext fontRenderContext = this.handle.getFontRenderContext();
        java.awt.Font font = this.handle.getFont();
        for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
            n6 = Math.max(n6, font.getStringBounds((String)object[i2], (FontRenderContext)fontRenderContext).getBounds().width);
            n7 = n5;
            n5 += n3;
        }
        return new Point(n6, n7);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC swing_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        CGC cGC = drawable.internal_new_GC(gCData);
        gC.init(drawable, gCData, cGC);
        return gC;
    }

    public static GC swing_new(CGC cGC, GCData gCData) {
        GC gC = new GC();
        gC.init(null, gCData, cGC);
        return gC;
    }

    BasicStroke getCurrentBasicStroke() {
        Stroke stroke = this.handle.getStroke();
        if (stroke instanceof BasicStroke) {
            return (BasicStroke)stroke;
        }
        return new BasicStroke();
    }
}

