/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.NoDragAndDropEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragAndDropEffect effect;
    static final String DROPTARGETID = "DropTarget";
    protected int lastAction;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DropTarget;

    public DropTarget(Control control, int n2) {
        super(control, DropTarget.checkStyle(n2));
        this.control = control;
        if (control.getData(DROPTARGETID) != null) {
            DND.error(2001);
        }
        control.setData(DROPTARGETID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        new java.awt.dnd.DropTarget(((CControl)((Object)control.handle)).getSwingComponent(), Utils.convertDnDActionsToSwing(n2), new java.awt.dnd.DropTargetListener(){

            public void dragEnter(DropTargetDragEvent e2) {
                DropTarget.this.lastAction = 16;
                this.processDropTargetDragEvent(e2, 2002);
            }

            public void dragOver(DropTargetDragEvent e2) {
                this.processDropTargetDragEvent(e2, 2004);
            }

            public void dropActionChanged(DropTargetDragEvent e2) {
                this.processDropTargetDragEvent(e2, 2005);
            }

            public void processDropTargetDragEvent(DropTargetDragEvent e2, int notificationType) {
                DNDEvent event = new DNDEvent();
                if (DropTarget.this.setDragEventData(event, e2)) {
                    int allowedOperations = event.operations;
                    DropTarget.this.notifyListeners(notificationType, event);
                    if (Utils.isLocalDragAndDropInProgress && !DropTarget.this.hasMetas()) {
                        DropTarget.this.lastAction = event.detail;
                    }
                    if (event.detail == 16) {
                        event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
                    }
                    int action = 0;
                    if ((allowedOperations & event.detail) != 0) {
                        action = Utils.convertDnDActionsToSwing(event.detail);
                    }
                    if (action == 0) {
                        e2.rejectDrag();
                    } else {
                        e2.acceptDrag(action);
                    }
                    DropTarget.this.effect.showDropTargetEffect(event.feedback, event.x, event.y);
                } else {
                    e2.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent e2) {
                DNDEvent event = new DNDEvent();
                event.widget = DropTarget.this;
                event.time = Utils.getCurrentTime();
                event.detail = 0;
                DropTarget.this.notifyListeners(2003, event);
            }

            public void drop(DropTargetDropEvent e2) {
                DNDEvent event = new DNDEvent();
                if (!DropTarget.this.setDropEventData(event, e2)) {
                    e2.rejectDrop();
                    e2.dropComplete(false);
                }
                int allowedOperations = event.operations;
                int action = 0;
                if (event.detail == 16) {
                    int n2 = event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
                }
                if ((allowedOperations & event.detail) != 0) {
                    action = Utils.convertDnDActionsToSwing(event.detail);
                }
                if (action == 0) {
                    e2.rejectDrop();
                    e2.dropComplete(true);
                    return;
                }
                boolean isLocalTransfer = e2.isLocalTransfer();
                e2.acceptDrop(isLocalTransfer ? action : 2);
                Object object = null;
                int i2 = 0;
                while (i2 < DropTarget.this.transferAgents.length) {
                    if (DropTarget.this.transferAgents[i2].isSupportedType(event.dataType)) {
                        object = DropTarget.this.transferAgents[i2].nativeToJava(event.dataType);
                        break;
                    }
                    ++i2;
                }
                if (object == null) {
                    event.detail = 0;
                }
                try {
                    event.data = object;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                DropTarget.this.notifyListeners(2006, event);
                if (event.detail == 2) {
                    e2.dropComplete(true);
                }
                DropTarget.this.effect.showDropTargetEffect(event.feedback, event.x, event.y);
            }
        }, true);
        this.effect = new NoDragAndDropEffect(control);
    }

    protected boolean hasMetas() {
        return (Utils.modifiersEx & 0x2C0) != 0;
    }

    boolean setDragEventData(DNDEvent dNDEvent, DropTargetDragEvent dropTargetDragEvent) {
        ArrayList<TransferData> arrayList = new ArrayList<TransferData>();
        Transferable transferable = dropTargetDragEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
            TransferData[] transferDataArray = this.transferAgents[i2].getSupportedTypes();
            for (int i3 = 0; i3 < dataFlavorArray.length; ++i3) {
                for (int i4 = 0; i4 < transferDataArray.length; ++i4) {
                    TransferData transferData = new TransferData();
                    transferData.dataFlavor = dataFlavorArray[i3];
                    if (!transferDataArray[i4].dataFlavor.equals(transferData.dataFlavor)) continue;
                    transferData.transferable = transferable;
                    arrayList.add(transferData);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        dNDEvent.widget = this;
        Point point = dropTargetDragEvent.getLocation();
        dNDEvent.x = point.x;
        dNDEvent.y = point.y;
        dNDEvent.time = Utils.getCurrentTime();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = arrayList.toArray(new TransferData[0]);
        dNDEvent.dataType = dNDEvent.dataTypes[0];
        dNDEvent.item = this.effect.getItem(point.x, point.y);
        dNDEvent.operations = Utils.convertDnDActionsToSWT(dropTargetDragEvent.getSourceActions());
        dNDEvent.detail = !Utils.isLocalDragAndDropInProgress || this.hasMetas() ? Utils.convertDnDActionsToSWT(dropTargetDragEvent.getDropAction()) : this.lastAction;
        return true;
    }

    boolean setDropEventData(DNDEvent dNDEvent, DropTargetDropEvent dropTargetDropEvent) {
        ArrayList<TransferData> arrayList = new ArrayList<TransferData>();
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
            TransferData[] transferDataArray = this.transferAgents[i2].getSupportedTypes();
            for (int i3 = 0; i3 < dataFlavorArray.length; ++i3) {
                for (int i4 = 0; i4 < transferDataArray.length; ++i4) {
                    TransferData transferData = new TransferData();
                    transferData.dataFlavor = dataFlavorArray[i3];
                    if (!transferDataArray[i4].dataFlavor.equals(transferData.dataFlavor)) continue;
                    transferData.transferable = transferable;
                    arrayList.add(transferData);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        dNDEvent.widget = this;
        Point point = dropTargetDropEvent.getLocation();
        dNDEvent.x = point.x;
        dNDEvent.y = point.y;
        dNDEvent.time = Utils.getCurrentTime();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = arrayList.toArray(new TransferData[0]);
        dNDEvent.dataType = dNDEvent.dataTypes[0];
        dNDEvent.item = this.effect.getItem(point.x, point.y);
        dNDEvent.operations = Utils.convertDnDActionsToSWT(dropTargetDropEvent.getSourceActions());
        dNDEvent.detail = !Utils.isLocalDragAndDropInProgress || this.hasMetas() ? Utils.convertDnDActionsToSWT(dropTargetDropEvent.getDropAction()) : this.lastAction;
        return true;
    }

    static int checkStyle(int n2) {
        if (n2 == 0) {
            return 2;
        }
        return n2;
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = (class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$((String)"org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget).getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DROPTARGETID, null);
        this.transferAgents = null;
        this.control = null;
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setTransfer(Transfer[] transferArray) {
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
    }
}

