/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import net.beeger.squareness.util.SquarenessButtonPainter;
import net.beeger.squareness.util.SquarenessListenerFactory;

public class SquarenessToggleButtonUI
extends BasicToggleButtonUI {
    private static SquarenessToggleButtonUI _buttonUI = new SquarenessToggleButtonUI();

    public static ComponentUI createUI(JComponent component) {
        return _buttonUI;
    }

    public void installUI(JComponent component) {
        component.putClientProperty("SquarenessRollover", Boolean.FALSE);
        component.addMouseListener(SquarenessListenerFactory.getButtonRolloverMouseListener());
        super.installUI(component);
    }

    public void uninstallUI(JComponent component) {
        component.removeMouseListener(SquarenessListenerFactory.getButtonRolloverMouseListener());
        super.uninstallUI(component);
    }

    public void paint(Graphics graphics, JComponent component) {
        Color oldColor = graphics.getColor();
        SquarenessButtonPainter.paintButton(graphics, (AbstractButton)component);
        AbstractButton b2 = (AbstractButton)component;
        ButtonModel model = b2.getModel();
        Dimension size = b2.getSize();
        FontMetrics fm = graphics.getFontMetrics();
        Insets i2 = component.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i2.left;
        viewRect.y += i2.top;
        viewRect.width -= i2.right + viewRect.x;
        viewRect.height -= i2.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f2 = component.getFont();
        graphics.setFont(f2);
        String text = SwingUtilities.layoutCompoundLabel(component, fm, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : b2.getIconTextGap());
        graphics.setColor(b2.getBackground());
        if (model.isArmed() && model.isPressed() || model.isSelected()) {
            this.paintButtonPressed(graphics, b2);
        }
        if (b2.getIcon() != null) {
            this.paintIcon(graphics, b2, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v2 = (View)component.getClientProperty("html");
            if (v2 != null) {
                v2.paint(graphics, textRect);
            } else {
                this.paintText(graphics, b2, textRect, text);
            }
        }
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(graphics, b2, viewRect, textRect, iconRect);
        }
        graphics.setColor(oldColor);
    }
}

