/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF;

import com.lipstikLF.theme.DefaultTheme;
import com.lipstikLF.theme.LipstikColorTheme;
import com.lipstikLF.util.LipstikBorderFactory;
import com.lipstikLF.util.LipstikIconFactory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LipstikLookAndFeel
extends MetalLookAndFeel {
    private static List do;
    private static LipstikColorTheme do;
    private static String[] do;

    static {
        do = new String[]{"KlearlooksTheme", "LightGrayTheme", "DefaultTheme"};
    }

    public LipstikLookAndFeel() {
        if (LipstikLookAndFeel.getMyCurrentTheme() == null) {
            String string = LipstikLookAndFeel.getSystemProperty("lipstikLF.theme");
            if (string != null) {
                int n2 = 0;
                while (n2 < do.length) {
                    if (string.equals(do[n2])) {
                        LipstikLookAndFeel.setMyCurrentTheme(LipstikLookAndFeel.createTheme(string));
                        return;
                    }
                    ++n2;
                }
            }
            LipstikLookAndFeel.setMyCurrentTheme(new DefaultTheme());
        }
    }

    public String getID() {
        return "Lipstik";
    }

    public String getName() {
        return "Lipstik";
    }

    public String getDescription() {
        return "Lipstik Look And Feel: Based on original Lipstik KDE theme";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        uIDefaults.putDefaults(new Object[]{"ButtonUI", "com.lipstikLF.delegate.LipstikButtonUI", "CheckBoxUI", "com.lipstikLF.delegate.LipstikCheckBoxUI", "CheckBoxMenuItemUI", "com.lipstikLF.delegate.LipstikCheckBoxMenuItemUI", "MenuItemUI", "com.lipstikLF.delegate.LipstikMenuItemUI", "MenuUI", "com.lipstikLF.delegate.LipstikMenuUI", "PopupMenuSeparatorUI", "com.lipstikLF.delegate.LipstikPopupMenuSeparatorUI", "RadioButtonUI", "com.lipstikLF.delegate.LipstikRadioButtonUI", "RadioButtonMenuItemUI", "com.lipstikLF.delegate.LipstikRadioButtonMenuItemUI", "ScrollBarUI", "com.lipstikLF.delegate.LipstikScrollBarUI", "ComboBoxUI", "com.lipstikLF.delegate.LipstikComboBoxUI", "TabbedPaneUI", "com.lipstikLF.delegate.LipstikTabbedPaneUI", "ProgressBarUI", "com.lipstikLF.delegate.LipstikProgressBarUI", "TreeUI", "com.lipstikLF.delegate.LipstikTreeUI", "PasswordFieldUI", "com.lipstikLF.delegate.LipstikPasswordFieldUI", "SeparatorUI", "com.lipstikLF.delegate.LipstikSeparatorUI", "TableHeaderUI", "com.lipstikLF.delegate.LipstikTableHeaderUI", "ToggleButtonUI", "com.lipstikLF.delegate.LipstikButtonUI", "ToolBarUI", "com.lipstikLF.delegate.LipstikToolBarUI", "SliderUI", "com.lipstikLF.delegate.LipstikSliderUI", "SplitPaneUI", "com.lipstikLF.delegate.LipstikSplitPaneUI", "FileChooserUI", "com.lipstikLF.delegate.LipstikFileChooserUI", "InternalFrameUI", "com.lipstikLF.delegate.LipstikInternalFrameUI", "RootPaneUI", "com.lipstikLF.delegate.LipstikRootPaneUI"});
    }

    public static void setMyCurrentTheme(LipstikColorTheme lipstikColorTheme) {
        do = lipstikColorTheme;
        LipstikLookAndFeel.setCurrentTheme(lipstikColorTheme);
    }

    public static LipstikColorTheme getMyCurrentTheme() {
        return do;
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        super.initSystemColorDefaults(uIDefaults);
        uIDefaults.put("textHighlight", LipstikLookAndFeel.getTextHighlightColor());
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        this.createDefaultTheme();
        UIDefaults.LazyValue lazyValue = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getScrollPaneBorder();
            }
        };
        UIDefaults.LazyValue lazyValue2 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getControlBorderWithMargin();
            }
        };
        UIDefaults.LazyValue lazyValue3 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getRoundControlBorderWithoutMargin();
            }
        };
        UIDefaults.LazyValue lazyValue4 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getButtonMenuBorder();
            }
        };
        UIDefaults.LazyValue lazyValue5 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getMenuItemBorder();
            }
        };
        UIDefaults.LazyValue lazyValue6 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                int n2;
                block4: {
                    int n3;
                    block3: {
                        block2: {
                            n2 = 0;
                            Boolean bl = LipstikLookAndFeel.getBooleanSystemProperty("lipstikLF.sharpMenu");
                            if (bl == null || !bl.booleanValue()) break block2;
                            n3 = 1;
                            break block3;
                        }
                        Boolean bl = LipstikLookAndFeel.getBooleanSystemProperty("lipstikLF.shadowMenu");
                        if (bl != null && !bl.booleanValue()) break block4;
                        n3 = 2;
                    }
                    n2 = n3;
                }
                return LipstikBorderFactory.getPopupMenuBorder(n2);
            }
        };
        UIDefaults.LazyValue lazyValue7 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getToolBarBorder();
            }
        };
        UIDefaults.LazyValue lazyValue8 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getButtonToolBorder();
            }
        };
        UIDefaults.LazyValue lazyValue9 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getButtonPushBorder();
            }
        };
        UIDefaults.LazyValue lazyValue10 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getArrowBorder();
            }
        };
        UIDefaults.LazyValue lazyValue11 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getSpinBorder();
            }
        };
        UIDefaults.LazyValue lazyValue12 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getFocusBorder();
            }
        };
        UIDefaults.LazyValue lazyValue13 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getTableHeaderCellBorder();
            }
        };
        UIDefaults.LazyValue lazyValue14 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getInternalFrameBorder(false);
            }
        };
        UIDefaults.LazyValue lazyValue15 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getInternalFrameBorder(true);
            }
        };
        UIDefaults.LazyValue lazyValue16 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getToolTipBorder();
            }
        };
        UIDefaults.LazyValue lazyValue17 = new UIDefaults.LazyValue(this){

            public final Object createValue(UIDefaults uIDefaults) {
                return LipstikBorderFactory.getMenuBarBorder();
            }
        };
        LipstikColorTheme lipstikColorTheme = LipstikLookAndFeel.getMyCurrentTheme();
        InsetsUIResource insetsUIResource = new InsetsUIResource(1, 2, 1, 1);
        InsetsUIResource insetsUIResource2 = new InsetsUIResource(3, 0, 3, 0);
        uIDefaults.put("Button.textShiftOffset", new Integer(5));
        uIDefaults.put("Button.border", lazyValue9);
        uIDefaults.put("Button.borderColor", lipstikColorTheme.getBorderNormal());
        uIDefaults.put("Button.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("CheckBox.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("CheckBox.unselectedEnabledIcon", LookAndFeel.makeIcon(this.getClass(), "icons/checkbox0.gif"));
        uIDefaults.put("CheckBox.selectedEnabledIcon", LookAndFeel.makeIcon(this.getClass(), "icons/checkbox1.gif"));
        uIDefaults.put("CheckBox.unselectedDisabledIcon", LookAndFeel.makeIcon(this.getClass(), "icons/checkbox0_disabled.gif"));
        uIDefaults.put("CheckBox.selectedDisabledIcon", LookAndFeel.makeIcon(this.getClass(), "icons/checkbox1_disabled.gif"));
        uIDefaults.put("CheckBoxMenuItem.background", lipstikColorTheme.getMenuBackground());
        uIDefaults.put("CheckBoxMenuItem.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("CheckBoxMenuItem.border", lazyValue5);
        uIDefaults.put("CheckBoxMenuItem.borderPainted", Boolean.FALSE);
        uIDefaults.put("CheckBoxMenuItem.checkIcon", LipstikIconFactory.checkBoxMenuIcon);
        uIDefaults.put("CheckBoxMenuItem.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("CheckBoxMenuItem.margin", insetsUIResource2);
        uIDefaults.put("ComboBox.arrowButtonBorder", lazyValue10);
        uIDefaults.put("ComboBox.background", lipstikColorTheme.getMenuBackground());
        uIDefaults.put("ComboBox.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("ComboBox.editorBorder", lazyValue2);
        uIDefaults.put("ComboBox.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("ComboPopup.border", lazyValue4);
        uIDefaults.put("FormattedTextField.border", lazyValue2);
        uIDefaults.put("FormattedTextField.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("FormattedTextField.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("FormattedTextField.border", lazyValue2);
        uIDefaults.put("FileChooser.newFolderIcon", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/file_new.gif"));
        uIDefaults.put("FileChooser.upFolderIcon", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/file_back.gif"));
        uIDefaults.put("FileChooser.homeFolderIcon", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/file_home.gif"));
        uIDefaults.put("FileChooser.newFolderIconDisabled", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/file_new_disabled.gif"));
        uIDefaults.put("FileChooser.upFolderIconDisabled", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/file_back_disabled.gif"));
        uIDefaults.put("FileChooser.detailsViewIcon", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/file_viewlist.gif"));
        uIDefaults.put("FileChooser.listViewIcon", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/file_multicolumn.gif"));
        uIDefaults.put("FileChooser.folderIcon", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/folder_closed.gif"));
        uIDefaults.put("FileView.fileIcon", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/leaf.gif"));
        uIDefaults.put("FileView.directoryIcon", LipstikLookAndFeel.makeIcon(this.getClass(), "icons/folder_closed.gif"));
        uIDefaults.put("InternalFrame.border", lazyValue15);
        uIDefaults.put("InternalFrame.paletteBorder", lazyValue14);
        uIDefaults.put("InternalFrame.optionDialogBorder", lazyValue14);
        uIDefaults.put("InternalFrame.font", MetalLookAndFeel.getWindowTitleFont());
        uIDefaults.put("InternalFrame.closeIcon", LookAndFeel.makeIcon(this.getClass(), "icons/frame_close.gif"));
        uIDefaults.put("InternalFrame.icon", LookAndFeel.makeIcon(this.getClass(), "icons/frame_icon.gif"));
        uIDefaults.put("InternalFrame.maximizeIcon", LookAndFeel.makeIcon(this.getClass(), "icons/frame_max.gif"));
        uIDefaults.put("InternalFrame.minimizeIcon", LookAndFeel.makeIcon(this.getClass(), "icons/frame_res.gif"));
        uIDefaults.put("InternalFrame.iconifyIcon", LookAndFeel.makeIcon(this.getClass(), "icons/frame_min.gif"));
        uIDefaults.put("InternalFrame.activeTitleForeground", Color.WHITE);
        uIDefaults.put("InternalFrame.inactiveTitleForeground", Color.BLACK);
        uIDefaults.put("InternalFrame.paletteTitleHeight", new Integer(11));
        uIDefaults.put("Label.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("List.focusCellHighlightBorder", lazyValue12);
        uIDefaults.put("List.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("List.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("List.scrollPaneBorder", lazyValue);
        uIDefaults.put("Menu.border", lazyValue4);
        uIDefaults.put("Menu.borderPainted", Boolean.TRUE);
        uIDefaults.put("Menu.background", lipstikColorTheme.getMenuBackground());
        uIDefaults.put("Menu.font", lipstikColorTheme.getStdBoldFont());
        uIDefaults.put("Menu.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("MenuBar.border", lazyValue17);
        uIDefaults.put("MenuBar.background", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("MenuItem.border", lazyValue5);
        uIDefaults.put("MenuItem.background", lipstikColorTheme.getMenuBackground());
        uIDefaults.put("MenuItem.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("MenuItem.borderPainted", Boolean.FALSE);
        uIDefaults.put("MenuItem.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("MenuItem.margin", insetsUIResource2);
        uIDefaults.put("OptionPane.buttonAreaBorder", (Object)null);
        uIDefaults.put("OptionPane.warningIcon", LookAndFeel.makeIcon(this.getClass(), "icons/icon_warning.gif"));
        uIDefaults.put("OptionPane.questionIcon", LookAndFeel.makeIcon(this.getClass(), "icons/icon_question.gif"));
        uIDefaults.put("OptionPane.informationIcon", LookAndFeel.makeIcon(this.getClass(), "icons/icon_info.gif"));
        uIDefaults.put("OptionPane.errorIcon", LookAndFeel.makeIcon(this.getClass(), "icons/icon_error.gif"));
        uIDefaults.put("Panel.font", lipstikColorTheme.getStdBoldFont());
        uIDefaults.put("PasswordField.border", lazyValue2);
        uIDefaults.put("PasswordField.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("PasswordField.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("PasswordField.margin", insetsUIResource);
        uIDefaults.put("PopupMenu.border", lazyValue6);
        uIDefaults.put("PopupMenuSeparator.foreground", lipstikColorTheme.getControlShadow());
        uIDefaults.put("ProgressBar.background", new ColorUIResource(Color.WHITE));
        uIDefaults.put("ProgressBar.foreground", lipstikColorTheme.getProgressForeground());
        uIDefaults.put("ProgressBar.border", lazyValue3);
        uIDefaults.put("ProgressBar.font", lipstikColorTheme.getStdBoldFont());
        uIDefaults.put("RadioButton.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("RadioButton.unselectedEnabledIcon", LookAndFeel.makeIcon(this.getClass(), "icons/radio0.gif"));
        uIDefaults.put("RadioButton.selectedEnabledIcon", LookAndFeel.makeIcon(this.getClass(), "icons/radio1.gif"));
        uIDefaults.put("RadioButton.unselectedDisabledIcon", LookAndFeel.makeIcon(this.getClass(), "icons/radio0_disabled.gif"));
        uIDefaults.put("RadioButton.selectedDisabledIcon", LookAndFeel.makeIcon(this.getClass(), "icons/radio1_disabled.gif"));
        uIDefaults.put("RadioButtonMenuItem.background", lipstikColorTheme.getMenuBackground());
        uIDefaults.put("RadioButtonMenuItem.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("RadioButtonMenuItem.border", lazyValue5);
        uIDefaults.put("RadioButtonMenuItem.borderPainted", Boolean.FALSE);
        uIDefaults.put("RadioButtonMenuItem.checkIcon", LipstikIconFactory.radioButtonMenuIcon);
        uIDefaults.put("RadioButtonMenuItem.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("RadioButtonMenuItem.margin", insetsUIResource2);
        uIDefaults.put("ScrollBar.width", new Integer(15));
        uIDefaults.put("ScrollPane.viewportBorder", (Object)null);
        uIDefaults.put("ScrollPane.border", lazyValue);
        uIDefaults.put("Separator.foreground", lipstikColorTheme.getControlShadow());
        uIDefaults.put("Separator.background", lipstikColorTheme.getControlHighlight());
        uIDefaults.put("Spinner.border", (Object)null);
        uIDefaults.put("Spinner.foreground", Color.BLACK);
        uIDefaults.put("Spinner.font", lipstikColorTheme.getStdBoldFont());
        uIDefaults.put("Spinner.arrowButtonBorder", lazyValue11);
        uIDefaults.put("Spinner.editorBorderPainted", Boolean.TRUE);
        uIDefaults.put("SplitPane.dividerSize", new Integer(8));
        uIDefaults.put("SplitPane.oneTouchDividerSize", new Integer(8));
        uIDefaults.put("SplitPane.border", (Object)null);
        uIDefaults.put("SplitPane.highlight", lipstikColorTheme.getControlHighlight());
        uIDefaults.put("TableHeader.cellBorder", lazyValue13);
        uIDefaults.put("TableHeader.font", lipstikColorTheme.getStdBoldFont());
        uIDefaults.put("TabbedPane.font", lipstikColorTheme.getStdBoldFont());
        uIDefaults.put("Table.cellBorder", lazyValue13);
        uIDefaults.put("Table.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("Table.scrollPaneBorder", lazyValue);
        uIDefaults.put("Table.gridColor", lipstikColorTheme.getControlHighlight());
        uIDefaults.put("Table.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
        uIDefaults.put("Table.focusCellHighlightBorder", lazyValue12);
        uIDefaults.put("TextArea.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("TextArea.margin", insetsUIResource);
        uIDefaults.put("TextArea.selectionBackground", LipstikLookAndFeel.getTextHighlightColor());
        uIDefaults.put("TextField.border", lazyValue2);
        uIDefaults.put("TextField.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("TextField.selectionBackground", LipstikLookAndFeel.getTextHighlightColor());
        uIDefaults.put("TextField.margin", insetsUIResource);
        uIDefaults.put("TitledBorder.font", lipstikColorTheme.getStdBoldFont());
        uIDefaults.put("TitledBorder.border", lazyValue3);
        uIDefaults.put("ToolBar.background", lipstikColorTheme.getControl());
        uIDefaults.put("ToolBar.border", lazyValue7);
        uIDefaults.put("ToolBar.rolloverBorder", lazyValue8);
        uIDefaults.put("ToolTip.border", lazyValue16);
        uIDefaults.put("ToolTip.background", lipstikColorTheme.getTooltipBackground());
        uIDefaults.put("ToolTip.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("ToggleButton.border", lazyValue9);
        uIDefaults.put("ToggleButton.background", lipstikColorTheme.getControl());
        uIDefaults.put("Tree.expandedIcon", LipstikIconFactory.expandedTreeIcon);
        uIDefaults.put("Tree.collapsedIcon", LipstikIconFactory.collapsedTreeIcon);
        uIDefaults.put("Tree.font", lipstikColorTheme.getStdFont());
        uIDefaults.put("Tree.hash", lipstikColorTheme.getBorderDisabled());
        uIDefaults.put("Tree.leafIcon", LookAndFeel.makeIcon(this.getClass(), "icons/leaf.gif"));
        uIDefaults.put("Tree.closedIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folder_closed.gif"));
        uIDefaults.put("Tree.openIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folder_opened.gif"));
        uIDefaults.put("Tree.selectionBorderColor", lipstikColorTheme.getControlDarkShadow());
        uIDefaults.put("Tree.selectionBackground", lipstikColorTheme.getControlSelectedBackground());
    }

    protected static void installDefaultThemes() {
        do = new ArrayList();
        int n2 = do.length - 1;
        while (n2 >= 0) {
            LipstikLookAndFeel.installTheme(LipstikLookAndFeel.createTheme(do[n2]));
            --n2;
        }
    }

    public static List getInstalledThemes() {
        if (do == null) {
            LipstikLookAndFeel.installDefaultThemes();
        }
        return do;
    }

    public static void installTheme(LipstikColorTheme lipstikColorTheme) {
        if (do == null) {
            LipstikLookAndFeel.installDefaultThemes();
        }
        do.add(lipstikColorTheme);
    }

    protected static LipstikColorTheme createTheme(String string) {
        String string2 = "com.lipstikLF.theme." + string;
        try {
            Class<?> clazz = Class.forName(string2);
            return (LipstikColorTheme)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        return null;
    }

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            System.out.println("Can't read the System property " + string + ".");
            return null;
        }
    }

    public static Boolean getBooleanSystemProperty(String string) {
        String string2 = LipstikLookAndFeel.getSystemProperty(string);
        if (string2 == null) {
            return null;
        }
        return "true".equals(string2.toLowerCase());
    }
}

