/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticSpinnerUI;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public final class PlasticXPSpinnerUI
extends PlasticSpinnerUI {
    private static final ExtBasicArrowButtonHandler NEXT_BUTTON_HANDLER = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler PREVIOUS_BUTTON_HANDLER = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent b2) {
        return new PlasticXPSpinnerUI();
    }

    protected Component createPreviousButton() {
        return new SpinnerXPArrowButton(5, PREVIOUS_BUTTON_HANDLER);
    }

    protected Component createNextButton() {
        return new SpinnerXPArrowButton(1, NEXT_BUTTON_HANDLER);
    }

    private static final class SpinnerXPArrowButton
    extends PlasticArrowButton {
        private SpinnerXPArrowButton(int direction, ExtBasicArrowButtonHandler handler) {
            super(direction, UIManager.getInt("ScrollBar.width") - 2, false);
            this.addActionListener(handler);
            this.addMouseListener(handler);
        }

        protected int calculateArrowHeight(int height, int width) {
            int arrowHeight = Math.min((height - 4) / 3, (width - 4) / 3);
            return Math.max(arrowHeight, 3);
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }

        protected void paintNorth(Graphics g2, boolean leftToRight, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w2, int h2, int arrowHeight, int arrowOffset, boolean paintBottom) {
            if (!this.isFreeStanding) {
                ++height;
                g2.translate(0, -1);
                if (!leftToRight) {
                    ++width;
                    g2.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g2.setColor(arrowColor);
            int startY = (h2 + 1 - arrowHeight) / 2;
            int startX = w2 / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g2.fillRect(startX - line - arrowOffset, startY + line, 2 * (line + 1), 1);
            }
            if (isEnabled) {
                Color shadowColor = UIManager.getColor("ScrollBar.darkShadow");
                g2.setColor(shadowColor);
                g2.drawLine(0, 0, width - 2, 0);
                g2.drawLine(0, 0, 0, height - 1);
                g2.drawLine(width - 2, 1, width - 2, height - 1);
                if (paintBottom) {
                    g2.fillRect(0, height - 1, width - 1, 1);
                }
            } else {
                PlasticUtils.drawDisabledBorder(g2, 0, 0, width, height + 1);
                if (paintBottom) {
                    g2.setColor(PlasticLookAndFeel.getControlShadow());
                    g2.fillRect(0, height - 1, width - 1, 1);
                }
            }
            if (!this.isFreeStanding) {
                --height;
                g2.translate(0, 1);
                if (!leftToRight) {
                    --width;
                    g2.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        }

        protected void paintSouth(Graphics g2, boolean leftToRight, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w2, int h2, int arrowHeight, int arrowOffset) {
            if (!this.isFreeStanding) {
                ++height;
                if (!leftToRight) {
                    ++width;
                    g2.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g2.setColor(arrowColor);
            int startY = (h2 + 0 - arrowHeight) / 2 + arrowHeight - 1;
            int startX = w2 / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g2.fillRect(startX - line - arrowOffset, startY - line, 2 * (line + 1), 1);
            }
            if (isEnabled) {
                Color shadowColor = UIManager.getColor("ScrollBar.darkShadow");
                g2.setColor(shadowColor);
                g2.drawLine(0, 0, 0, height - 2);
                g2.drawLine(width - 2, 0, width - 2, height - 2);
            } else {
                PlasticUtils.drawDisabledBorder(g2, 0, -1, width, height + 1);
            }
            if (!this.isFreeStanding) {
                --height;
                if (!leftToRight) {
                    --width;
                    g2.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        }
    }
}

