MODULE Node;

IMPORT
    Sys := mscorlib_System,
    Frm := System_Windows_Forms_,
    Drw := System_Drawing_,
    Cpm := System__ComponentModel;

TYPE
    TNode* = POINTER TO EXTENSIBLE
(*      RECORD (Frm.UserControl) *)
        RECORD (Frm.ContainerControl)
            components: Cpm.Container;
            clrFace: Drw.Color;
            key*: INTEGER;
            visible: BOOLEAN;
        END;

VAR
    Diameter: INTEGER;

PROCEDURE (n: TNode) InitializeComponent(), NEW;
BEGIN
    n.components := Cpm.Container.init();
END InitializeComponent;

PROCEDURE (n: TNode) Init*(keyVal: INTEGER), NEW, EXTENSIBLE;
BEGIN
    n.InitializeComponent();
    n.key := keyVal;
    n.visible := TRUE;
END Init;

PROCEDURE (n: TNode) Dispose*(disposing: BOOLEAN);
BEGIN
    IF disposing THEN
        IF n.components # NIL THEN
            n.components.Dispose();
        END; (* IF *)
    END; (* IF *)
    n.Dispose^(disposing);
END Dispose;

PROCEDURE GetDiameter*(): INTEGER;
BEGIN
    RETURN Diameter;
END GetDiameter;

PROCEDURE SetDiameter*(dia: INTEGER);
BEGIN
    Diameter := dia;
END SetDiameter;

PROCEDURE (n: TNode) SetNodeColor*(clr: Drw.Color), NEW;
BEGIN
    n.clrFace := clr;
END SetNodeColor;

PROCEDURE (n: TNode) Erase*(pe: Frm.PaintEventArgs), NEW;
VAR
    orig: Drw.Point;
    rect: Drw.Rectangle;
    penF: Drw.SolidBrush;    (* face pen *)
    penL: Drw.Pen;           (* line pen *)
    font: Drw.Font;
    penC: Drw.SolidBrush;    (* char pen *)
    fmtC: Drw.StringFormat;  (* char format *)
    labl: Sys.String;
    xoff: SHORTREAL;
    yoff: SHORTREAL;
BEGIN
    orig := Drw.Point.init(0, 0);
    rect := Drw.Rectangle.init(orig, Drw.Size.init(Diameter, Diameter));
    (* fill area *)
    penF := Drw.SolidBrush.init(Drw.Color.get_White());
    pe.get_Graphics().FillEllipse(penF, rect);
    (* draw perimeter *)
    penL := Drw.Pen.init(Drw.Color.get_White());
    pe.get_Graphics().DrawEllipse(penL, rect);
    (* Create font and brush *)
    font := Drw.Font.init("Arial", 10);
    penC := Drw.SolidBrush.init(Drw.Color.get_White());
    (* Set format of character string *)
    fmtC := Drw.StringFormat.init();
    fmtC.set_FormatFlags(Drw.StringFormatFlags.DirectionRightToLeft);
    (* draw characters to control *)
    yoff := SHORT(8.0);
    xoff := SHORT(32.0);
    labl := Sys.Convert.ToString(n.key);
    xoff := xoff - 3 * (4 - labl.get_Length());
    pe.get_Graphics().DrawString(labl, font, penC, 
                                 orig.get_X()+xoff, orig.get_Y()+yoff, fmtC);
END Erase;

PROCEDURE (n: TNode) Draw*(pe: Frm.PaintEventArgs), NEW;
VAR
    orig: Drw.Point;
    rect: Drw.Rectangle;
    penF: Drw.SolidBrush;    (* face pen *)
    penL: Drw.Pen;           (* line pen *)
    font: Drw.Font;
    penC: Drw.SolidBrush;    (* char pen *)
    fmtC: Drw.StringFormat;  (* char format *)
    labl: Sys.String;
    xoff: SHORTREAL;
    yoff: SHORTREAL;
BEGIN
    IF n.visible THEN
        n.Erase(pe);
        orig := Drw.Point.init(0, 0);
        rect := Drw.Rectangle.init(orig, Drw.Size.init(Diameter, Diameter));
        (* fill area *)
        penF := Drw.SolidBrush.init(n.clrFace);
        pe.get_Graphics().FillEllipse(penF, rect);
        (* draw perimeter *)
        penL := Drw.Pen.init(Drw.Color.get_Black());
        pe.get_Graphics().DrawEllipse(penL, rect);
        (* Create font and brush *)
        font := Drw.Font.init("Arial", 10);
        penC := Drw.SolidBrush.init(Drw.Color.get_Black());
        (* Set format of character string *)
        fmtC := Drw.StringFormat.init();
        fmtC.set_FormatFlags(Drw.StringFormatFlags.DirectionRightToLeft);
        (* draw characters to control *)
        yoff := SHORT(8.0);
        xoff := SHORT(32.0);
        labl := Sys.Convert.ToString(n.key);
        xoff := xoff - 3 * (4 - labl.get_Length());
        pe.get_Graphics().DrawString(labl, font, penC, 
                             orig.get_X()+xoff, orig.get_Y()+yoff, fmtC);
    END; (* IF *)
END Draw;


END Node.
