// --------------------------------------------------------------------------
// The jSyncManager Project -- Source File.
// Copyright (c) 1998 - 2003 Brad BARCLAY <bbarclay@jsyncmanager.org>
// --------------------------------------------------------------------------
// OSI Certified Open Source Software
// --------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published 
// by the Free Software Foundation; either version 2.1 of the License, or 
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public 
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// --------------------------------------------------------------------------
// $Id: DataObject.java,v 1.2 2003/11/20 17:50:58 yaztromo Exp $
// --------------------------------------------------------------------------

package org.jSyncManager.JSerial.TestSuite;

/* Data Object Class                   */
/* Written by Brad Barclay             */
/* Creation Date: July 19th, 1998      */
/* Last Modified Date: July 19th, 1998 */

import java.io.*;

/** A class to represent a piece of data to be passed between hosts.
 ** This class is designed to be a demonstration of one of the potential
 ** uses for the SerialInterface class.  In this demonstration, an object
 ** of the Data Object class is passed back and forth between two or more hosts,
 ** with each host adding itself to the pass list with a date/timestame, and
 ** by incrementing a counter.
 ** @author Brad Barclay.
 ** @version 1.0
 */

public class DataObject implements Serializable {

   private StampObject stamp[];     // Used to store the date/timestamp objects
   private int counter=0;           // Used to count the number of times this object has been passed
   private int passLimit=0;         // Used to store the maximum number of times to pass this object.
    
   

   /** The DataObject constructor.
   ** This constructor simply stores a new StampObject and initializes the starting speed.
   ** @param passLimit the maximum number of times to pass this object between hosts.
   */

   public DataObject(int passLimit) {
     this.passLimit=passLimit;
     stamp=new StampObject[passLimit];
   }         
/**
 * This method returns the current value of the counter.
 * @return int the current counter value.
 */
public int getCounter() {
   return counter;
}
   /** A method for retrieving the last Date/Timestamp object.
   ** @return the last received date/timestamp object.
   */

   public StampObject getLastTimeStamp() {
     if (counter==0) {
       return null;
     } else {
       return stamp[counter-1];
     } /* endif */
   }      
/**
 * This method returns the limit to the number of times this object should be passed.
 * @return int the pass limit for this object.
 */
public int getPassLimit() {
   return passLimit;
}
   /** A method for preparing this object for sending to the next host.
   ** This method adds a new StampObject to the queue, and increments the counter,
   ** in preparation of being passed to the next host.
   ** @throws IndexOutOfBoundsException thrown if we've gone beyond the maximum pass limit.
   */

   public void updateObject(String hostName) throws IndexOutOfBoundsException {
     if (counter==passLimit) {
       throw new IndexOutOfBoundsException("We've reached the maximum pass limit of "+passLimit+" passes.");
     } /* endif */

     stamp[counter]=new StampObject(hostName);
     counter++;
   }         
}
