/*
 * JavaCC.CMD
 * OS/2 and eComStation command file for running JavaCC
 *
 * Jarda KACER, jkacer@kiv.zcu.cz
 */

OldLocal = SETLOCAL()

/*
 * First add JavaCC ZIP file to CLASSPATH
 */
JavaCCZip = GetScriptPath() || "\lib\JavaCC.zip" 
CALL AddEnvironment "CLASSPATH", JavaCCZip

/*
 * Then grab all arguments and pass them to JavaCC
 */
JavaCCArguments = ARG(1) 
"java COM.sun.labs.javacc.Main " || JavaCCArguments

OldLocal = ENDLOCAL()
EXIT
/* End of program */




/*
 * Procedures and functions
 */

/*
 * Sets an environment variable or appends a value to it
 */
AddEnvironment: PROCEDURE
PARSE ARG VarName, VarValue
IF (Value(VarName, , "OS2ENVIRONMENT")="")
     THEN CALL SetEnvironment VarName, VarValue
     ELSE CALL Value VarName, GetEnvironment(VarName) || ";" || VarValue, "OS2ENVIRONMENT"
RETURN


/*
 * Sets an environment variable
 */
SetEnvironment: PROCEDURE
PARSE ARG VarName, VarValue
CALL Value VarName, VarValue, "OS2ENVIRONMENT"
RETURN


/*
 * Returns the value of an environment variable
 */
GetEnvironment: PROCEDURE
PARSE ARG VarName
RETURN Value(VarName,,"OS2ENVIRONMENT")


/*
 * Returns the current script name.
 */
GetScriptName: PROCEDURE
PARSE SOURCE Result
RETURN WORD(Result, 3)


/*
 * Returns the current script path, without "\" at the end.
 */
GetScriptPath: PROCEDURE
Name = GetScriptName()
RETURN SUBSTR(Name, 1, LASTPOS("\", Name)-1)

