/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.tabs.Tab;

public class AttachmentTab
extends Tab {
    private JButton add;
    private JButton remove;
    private JList list;
    private MainForm mainForm;
    private DefaultListModel lm;

    public AttachmentTab(MainForm mainForm) {
        super(new BorderLayout());
        this.mainForm = mainForm;
        this.add = new JButton("Add attachment...");
        this.add((Component)this.add, "North");
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                if (jFileChooser.showOpenDialog(AttachmentTab.this.mainForm) == 0) {
                    AttachmentTab.this.lm.addElement(jFileChooser.getSelectedFile());
                }
            }
        });
        this.lm = new DefaultListModel();
        this.list = new JList(this.lm);
        this.add(this.list, "Center");
        this.remove = new JButton("Remove");
        this.add((Component)this.remove, "South");
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = AttachmentTab.this.list.getSelectedIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    AttachmentTab.this.lm.remove(nArray[i]);
                }
            }
        });
    }

    public String getTabName() {
        return "Attachments";
    }

    public PdfTweak run(PdfTweak pdfTweak) throws IOException, DocumentException {
        for (int i = 0; i < this.lm.getSize(); ++i) {
            File file = (File)this.lm.get(i);
            pdfTweak.addFile(file);
        }
        return pdfTweak;
    }
}

