/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpdftweak.cli.AttachOption;
import jpdftweak.cli.BookmarksOption;
import jpdftweak.cli.BurstImagesOption;
import jpdftweak.cli.CommandOption;
import jpdftweak.cli.CropOption;
import jpdftweak.cli.DocInfoOption;
import jpdftweak.cli.EncryptOptions;
import jpdftweak.cli.InfoOption;
import jpdftweak.cli.PageNumberOption;
import jpdftweak.cli.PreserveHyperlinksOption;
import jpdftweak.cli.RotateOption;
import jpdftweak.cli.ScaleOption;
import jpdftweak.cli.ShuffleOption;
import jpdftweak.cli.SignOptions;
import jpdftweak.cli.TransitionOption;
import jpdftweak.cli.ViewerOptions;
import jpdftweak.cli.WatermarkOptions;
import jpdftweak.core.IntegerList;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfPageRange;
import jpdftweak.core.PdfTweak;

public class CommandLineInterface {
    private List<CommandOption[]> options = new ArrayList<CommandOption[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandLineInterface(String[] stringArray) throws IOException, DocumentException, NoSuchFieldException {
        PdfTweak pdfTweak;
        Object object;
        PdfInputFile pdfInputFile = null;
        ArrayList<PdfPageRange> arrayList = new ArrayList<PdfPageRange>();
        HashMap<String, PdfInputFile> hashMap = new HashMap<String, PdfInputFile>();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string2 = "";
        boolean bl7 = false;
        int n = 0;
        Pattern pattern = Pattern.compile("-i((~?[0-9]+)(-(~?[0-9]+)?)?)?([eo]?)(\\+[0-9,]+)?");
        Pattern pattern2 = Pattern.compile("-o[mubistc]*");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-help") || stringArray[i].equals("-?") || stringArray[i].equals("/?")) {
                if (i == stringArray.length - 1) {
                    this.showHelp();
                } else {
                    this.showHelpFor(stringArray[i + 1]);
                }
                return;
            }
            if (stringArray[i].equals("-v") || stringArray[i].equals("-version")) {
                System.out.println("JPDF Tweak 1.1");
                return;
            }
            if (stringArray[i].equals("--")) {
                this.options.add(this.buildOptions());
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                if (i == stringArray.length - 1) {
                    System.err.println("Option without parameters: " + stringArray[i]);
                    return;
                }
                if (stringArray[i].equals("-password")) {
                    string2 = stringArray[i + 1];
                } else if (stringArray[i].equals("-interleave")) {
                    n = Integer.parseInt(stringArray[i + 1]);
                } else if (pattern.matcher(stringArray[i]).matches()) {
                    int n2;
                    int n3;
                    object = pattern.matcher(stringArray[i]);
                    ((Matcher)object).matches();
                    if (((Matcher)object).group(2) == null) {
                        n3 = 1;
                        n2 = -1;
                    } else {
                        n3 = Integer.parseInt(((Matcher)object).group(2).replace('~', '-'));
                        n2 = ((Matcher)object).group(3) == null ? n3 : (((Matcher)object).group(4) == null ? -1 : Integer.parseInt(((Matcher)object).group(4).replace('~', '-')));
                    }
                    if (!hashMap.containsKey(stringArray[i + 1])) {
                        hashMap.put(stringArray[i + 1], new PdfInputFile(new File(stringArray[i + 1]), string2));
                    }
                    IntegerList integerList = new IntegerList(((Matcher)object).group(6) == null ? "0" : ((Matcher)object).group(6).substring(1));
                    PdfPageRange pdfPageRange = new PdfPageRange((PdfInputFile)hashMap.get(stringArray[i + 1]), n3, n2, !((Matcher)object).group(5).equals("e"), !((Matcher)object).group(5).equals("o"), integerList);
                    arrayList.add(pdfPageRange);
                } else if (stringArray[i].startsWith("-i=")) {
                    hashMap.put(stringArray[i].substring(3), new PdfInputFile(new File(stringArray[i + 1]), string2));
                } else if (pattern2.matcher(stringArray[i]).matches()) {
                    string = stringArray[i + 1];
                    bl4 = stringArray[i].contains("m");
                    bl3 = stringArray[i].contains("u");
                    bl = stringArray[i].contains("b");
                    bl2 = stringArray[i].contains("i");
                    bl7 = stringArray[i].contains("t");
                    bl5 = stringArray[i].contains("s");
                    bl6 = stringArray[i].contains("c");
                } else {
                    if (this.options.size() == 0) {
                        this.options.add(this.buildOptions());
                    }
                    boolean bl8 = false;
                    for (CommandOption commandOption : this.options.get(this.options.size() - 1)) {
                        if (!commandOption.supportsOption(stringArray[i])) continue;
                        if (!commandOption.setOption(stringArray[i], stringArray[i + 1])) {
                            return;
                        }
                        bl8 = true;
                        break;
                    }
                    if (!bl8) {
                        System.err.println("Unknown option: " + stringArray[i]);
                        return;
                    }
                }
                ++i;
                continue;
            }
            if (string != null) {
                if (!hashMap.containsKey(stringArray[i])) {
                    hashMap.put(stringArray[i], new PdfInputFile(new File(stringArray[i]), string2));
                }
                object = new PdfPageRange((PdfInputFile)hashMap.get(stringArray[i]), 1, -1, true, true, new IntegerList("0"));
                arrayList.add((PdfPageRange)object);
                continue;
            }
            if (pdfInputFile != null || arrayList.size() > 0 || hashMap.size() > 0) {
                string = stringArray[i];
                continue;
            }
            pdfInputFile = new PdfInputFile(new File(stringArray[i]), string2);
        }
        if (pdfInputFile != null && arrayList.size() > 0) {
            System.err.println("Invalid combination of input files.");
            return;
        }
        if (pdfInputFile == null && arrayList.size() == 0) {
            System.err.println("No input files.");
            return;
        }
        if (pdfInputFile != null) {
            pdfTweak = new PdfTweak(pdfInputFile, bl7);
        } else if (hashMap.containsKey("master")) {
            pdfInputFile = (PdfInputFile)hashMap.get("master");
            pdfTweak = new PdfTweak(pdfInputFile, arrayList, bl7, n);
        } else {
            pdfInputFile = ((PdfPageRange)arrayList.get(0)).getInputFile();
            pdfTweak = new PdfTweak(pdfInputFile, arrayList, bl7, n);
        }
        try {
            for (CommandOption[] commandOptionArray : this.options) {
                for (CommandOption commandOption : commandOptionArray) {
                    commandOption.run(pdfTweak, pdfInputFile);
                }
            }
            if (string == null) {
                System.err.println("Cannot write PDF: No output file.");
            } else {
                if (bl4) {
                    if (bl3) {
                        pdfTweak.addPageMarks();
                    } else {
                        pdfTweak.removePageMarks();
                    }
                }
                if (bl2 && pdfTweak.getPdfImages() == null) {
                    object = new BurstImagesOption();
                    ((BurstImagesOption)object).setOption("-burstfiletype", "TIFF");
                    ((BurstImagesOption)object).run(pdfTweak, pdfInputFile);
                }
                pdfTweak.writeOutput(string, bl2, bl, bl3, bl5, bl6);
                System.err.println("Output file written successfully.");
            }
        }
        finally {
            pdfTweak.cleanup();
        }
    }

    private CommandOption[] buildOptions() {
        return new CommandOption[]{new PreserveHyperlinksOption(), new CropOption(), new RotateOption(), new ScaleOption(), new WatermarkOptions(), new ShuffleOption(), new PageNumberOption(), new BookmarksOption(), new AttachOption(), new TransitionOption(), new ViewerOptions(), new DocInfoOption(), new EncryptOptions(), new SignOptions(), new InfoOption(), new BurstImagesOption()};
    }

    private void showHelp() {
        System.out.println("jPDF Tweak 1.1\n\nUsage: jpdftweak {inputfile} [-o[opt]] {outputfile}\n       jpdftweak -i[opt] {inputfile} [...] [-o[opt]] {outputfile}\n       jpdftweak -o[opt] {outputfile} [-i[opt]] {inputfile} [...]\n\nThe first syntax handles a single input file, the second and third one use\nmultiple file input. The third syntax is especially useful if you want to use\nwildcards (like *.pdf) for the input file.\nYou may add options and transformation and their parameter everywhere in the\ncommandline, except between a -i/-o switch and the filename.\nThe order of tranformations is the one printed below. To change the order\nor to perform a transformation more than once, separate transformation\nblock by two dashes (--).\nParameters are case sensitive.\n\nParameters\n~~~~~~~~~~\n -help                   Show this help.\n -help {transformation}  Show help for a transformation\n -v[ersion]              Show version\n -password {password}    Use password for opening next input file\n -interleave {pages}     Interleave documents in blocks of {pages}\n -i[{options}]           next parameter is input file, see '-help -i'\n -i={ALIAS}              use ALIAS for next input file name, '-help -i'\n -o[{options}]           next parameter is output file, see '-help -o'\n\nTransformations\n~~~~~~~~~~~~~~~");
        for (CommandOption commandOption : this.buildOptions()) {
            System.out.print(commandOption.getSummary());
        }
    }

    private void showHelpFor(String string) {
        if (!string.startsWith("-")) {
            string = "-" + string;
        }
        if (string.equals("-i")) {
            System.out.println("\nInput Files\n~~~~~~~~~~~\nIf you use -i without options, or no -i parameters at all, all pages of the\ngiven PDF file will be loaded. You can also use the following terms:\n -i3                       Load page 3 only\n -i~2                      Load the page before the last page only\n -i3-9                     Load pages 3-9\n -i5-                      Load pages 5-end\n -ie                       Load even pages only\n -i+3                      Add 3 empty pages to the beginning\n -i+5,6                    Add 5 or 6 empty pages depending whether the current\n                           position is odd or even\n -i1-~3o+1                 Load all but the last two pages, only odd pages, \n                           and add one empty page\nYou can load the file to an alias name using -i=ALIAS and use that alias name\nlater; this is useful if you want to reference a file more than once and it has\na long path/filename, or it requires a password. If you know 'pdftk', you know\naliases as well, only that they are optional in jPDF Tweak and not limited to a\nsingle character.\n\nExample:\n  jpdftweak -o mixedmode.pdf -password secret -i=A secret.pdf \\\n            -password moresecret -i=Ox knox.pdf \\\n            -i Ox -i1-3 A -i Ox -i4- A -i Ox\nThis will take knox.pdf, then page 1-3 of secret.pdf, then knox.pdf again,\nthen the rest of secret.pdf and finally knox.pdf again.");
        } else if (string.equals("-o")) {
            System.out.println("\nOutput files\n~~~~~~~~~~~~\nUse -o to specify the output filename; you can add flags:\n  -ou  save uncompressed, -om add Pdfmarks, -ob burst pages,\n  -ot  use temp files,  -os optimize for size,\n  -oc use better compression (Acrobat 6.0). \nFlags can be combined like -oub.");
        } else {
            System.out.println();
            for (CommandOption commandOption : this.buildOptions()) {
                if (!commandOption.supportsOption(string)) continue;
                System.out.println(commandOption.getHelp(string));
                return;
            }
            System.out.println("No help found for option " + string + ".\n" + "Use -help without option to get a list of options.");
        }
    }
}

