/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.components.collapsingpanel;

import it.flavianopetrocchi.reshelper.ResHelper;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class CollapsingPanel
extends JPanel {
    private static final String PROPERTIES_PATH = "it/flavianopetrocchi/components/collapsingpanel/CollapsingPanel";
    protected final JPanel innerPanelsContainer = new JPanel();
    protected JComboBox tabsCombo = new JComboBox();
    private final JPanel openLeftPanelContainer = new JPanel();
    private JSplitPane containerSplitter;
    private int dividerLocation;
    protected final CardLayout cardLayout = new CardLayout();
    private ResHelper resHelper;
    private int state = 1;
    private boolean firstRestore = true;
    public static final int COLLAPSING_PANEL_LEFT = 0;
    public static final int COLLAPSING_PANEL_RIGHT = 1;
    public static final int PANEL_COLLAPSED = 0;
    public static final int PANEL_OPENED = 1;

    public CollapsingPanel(JSplitPane containerSplitter) {
        this(containerSplitter, 0);
    }

    public CollapsingPanel(JSplitPane containerSplitter, int collapsingSide) {
        this.containerSplitter = containerSplitter;
        this.initComponents();
    }

    private void initComponents() {
        this.innerPanelsContainer.setLayout(this.cardLayout);
        JPanel cardsManagerPanel = new JPanel();
        cardsManagerPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 5, 3));
        cardsManagerPanel.setLayout(new BoxLayout(cardsManagerPanel, 0));
        this.tabsCombo.setEditable(false);
        cardsManagerPanel.add(this.tabsCombo);
        this.tabsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CollapsingPanel.this.cardLayout.show(CollapsingPanel.this.innerPanelsContainer, (String)e.getItem());
            }
        });
        this.resHelper = new ResHelper(this.getClass(), PROPERTIES_PATH);
        this.openLeftPanelContainer.setBorder(BorderFactory.createEmptyBorder(5, 1, 0, 1));
        this.openLeftPanelContainer.setLayout(new BoxLayout(this.openLeftPanelContainer, 1));
        JButton openPanelButton = new JButton(this.resHelper.getIcon("gfx16/open-panel.png"));
        openPanelButton.setToolTipText(this.resHelper.getString("OPEN_PANEL_BUTTON_DESCR"));
        openPanelButton.setContentAreaFilled(false);
        openPanelButton.setRolloverEnabled(true);
        openPanelButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        openPanelButton.addMouseListener(new ButtonRolloverListener(openPanelButton));
        openPanelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CollapsingPanel.this.setPanelState(1);
            }
        });
        this.openLeftPanelContainer.add(openPanelButton);
        this.setLayout(new BorderLayout());
        JButton closePanelButton = new JButton(this.resHelper.getIcon("gfx16/close-panel.png"));
        closePanelButton.addMouseListener(new ButtonRolloverListener(closePanelButton));
        closePanelButton.setContentAreaFilled(false);
        closePanelButton.setToolTipText(this.resHelper.getString("CLOSE_PANEL_BUTTON_DESCR"));
        cardsManagerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        cardsManagerPanel.add(closePanelButton);
        closePanelButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        closePanelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CollapsingPanel.this.setPanelState(0);
            }
        });
        this.add((Component)cardsManagerPanel, "North");
        this.add((Component)this.innerPanelsContainer, "Center");
        this.containerSplitter.addContainerListener(new SplitterContainerListener(closePanelButton, openPanelButton));
    }

    public void addInnerPanel(JPanel innerPanel, String name) {
        this.innerPanelsContainer.add((Component)innerPanel, name);
        this.tabsCombo.addItem(name);
    }

    public int getPanelState() {
        return this.state;
    }

    public int setPanelState(int state) {
        int oldState = this.state;
        if (state == 0) {
            if (!this.firstRestore) {
                this.dividerLocation = this.containerSplitter.getDividerLocation();
            } else {
                this.firstRestore = false;
            }
            this.containerSplitter.setLeftComponent(this.openLeftPanelContainer);
            this.containerSplitter.setOneTouchExpandable(false);
            this.containerSplitter.setEnabled(false);
        } else {
            this.containerSplitter.setDividerLocation(this.dividerLocation);
            this.containerSplitter.setLeftComponent(this);
            this.containerSplitter.setOneTouchExpandable(true);
            this.containerSplitter.setEnabled(true);
        }
        this.state = state;
        return oldState;
    }

    public int getDividerLocation() {
        if (this.state == 1) {
            return this.containerSplitter.getDividerLocation();
        }
        return this.dividerLocation;
    }

    public void setDividerLocation(int location) {
        this.dividerLocation = location;
    }

    public void updateComponentsUI() {
        if (this.state == 0) {
            SwingUtilities.updateComponentTreeUI(this);
        } else {
            SwingUtilities.updateComponentTreeUI(this.openLeftPanelContainer);
        }
    }

    public JComboBox getComboBoxSelector() {
        return this.tabsCombo;
    }

    public CardLayout getCardLayout() {
        return this.cardLayout;
    }

    public JPanel getCardsContainerPanel() {
        return this.innerPanelsContainer;
    }

    private class ButtonRolloverListener
    extends MouseAdapter {
        JButton btn;

        public ButtonRolloverListener(JButton btn) {
            this.btn = btn;
        }

        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            this.btn.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            this.btn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    private static class SplitterContainerListener
    implements ContainerListener {
        JButton closePanelButton;
        JButton openPanelButton;
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public SplitterContainerListener(JButton closePanelButton, JButton openPanelButton) {
            this.closePanelButton = closePanelButton;
            this.openPanelButton = openPanelButton;
        }

        public void componentAdded(ContainerEvent e) {
            this.closePanelButton.setBorder(this.emptyBorder);
        }

        public void componentRemoved(ContainerEvent e) {
            this.openPanelButton.setBorder(this.emptyBorder);
        }
    }
}

