/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import com.lowagie.text.exceptions.BadPasswordException;
import it.flavianopetrocchi.jpdfbookmarks.IPdfView;
import it.flavianopetrocchi.jpdfbookmarks.JPedalViewPanel;
import it.flavianopetrocchi.jpdfbookmarks.PasswordDialog;
import it.flavianopetrocchi.jpdfbookmarks.Prefs;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.IBookmarksConverter;
import it.flavianopetrocchi.utilities.FileOperationEvent;
import it.flavianopetrocchi.utilities.FileOperationListener;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.management.ServiceNotFoundException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class UnifiedFileOperator {
    private IPdfView viewPanel = new JPedalViewPanel();
    private String filePath;
    private File file;
    private File tmpForViewPanel;
    private boolean showOnOpen = false;
    private Bookmark root;
    private Prefs userPrefs = new Prefs();
    private byte[] ownerPassword;
    private byte[] userPassword;
    private boolean readonly = false;
    private boolean fileChanged = false;
    private ArrayList<FileOperationListener> fileOperationListeners = new ArrayList();

    public File getFile() {
        return this.file;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public String getFilePath() {
        return this.filePath;
    }

    private boolean askOwnerPassword(String string) {
        PasswordDialog passwordDialog = new PasswordDialog(null, true, string);
        passwordDialog.setLocationRelativeTo((Component)((Object)this.viewPanel));
        passwordDialog.setVisible(true);
        if (passwordDialog.okPressed()) {
            this.ownerPassword = passwordDialog.getPassword();
            if (this.ownerPassword.length == 0) {
                this.ownerPassword = null;
            }
        }
        return passwordDialog.okPressed();
    }

    private boolean askUserPassword(String string) {
        PasswordDialog passwordDialog = new PasswordDialog(null, true, string);
        passwordDialog.setLocationRelativeTo((Component)((Object)this.viewPanel));
        passwordDialog.setVisible(true);
        if (passwordDialog.okPressed()) {
            this.userPassword = passwordDialog.getPassword();
            if (this.userPassword.length == 0) {
                this.userPassword = null;
            }
        }
        return passwordDialog.okPressed();
    }

    public void open(File file) throws Exception {
        FileOperationEvent.Operation operation;
        this.file = file;
        try {
            this.filePath = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.filePath = file.getAbsolutePath();
        }
        IBookmarksConverter iBookmarksConverter = Bookmark.getBookmarksConverter();
        if (iBookmarksConverter == null) {
            throw new ServiceNotFoundException(Res.getString("ERROR_BOOKMARKS_CONVERTER_NOT_FOUND"));
        }
        boolean bl = false;
        block6: while (true) {
            try {
                iBookmarksConverter.open(this.filePath, this.userPassword);
            }
            catch (BadPasswordException badPasswordException) {
                bl = true;
                this.userPassword = null;
                do {
                    if (this.userPassword != null) continue block6;
                } while (this.askUserPassword(Res.getString("DIALOG_USER_PASSWORD")));
                this.root = null;
                return;
            }
            break;
        }
        boolean bl2 = false;
        if (bl) {
            if (!iBookmarksConverter.isBookmarksEditingPermitted()) {
                bl2 = true;
            }
        } else if (iBookmarksConverter.isEncryped()) {
            bl2 = true;
        }
        block8: while (bl2) {
            this.ownerPassword = null;
            while (this.ownerPassword == null) {
                if (this.askOwnerPassword(Res.getString("DIALOG_OWNER_PASSWORD"))) continue;
                if (!bl || this.userPassword != null) break block8;
                this.root = null;
                return;
            }
            try {
                iBookmarksConverter.close();
                iBookmarksConverter.open(this.filePath, this.ownerPassword);
                if (!iBookmarksConverter.isBookmarksEditingPermitted()) continue;
                bl2 = false;
            }
            catch (Exception exception) {
                this.ownerPassword = null;
            }
        }
        if (bl) {
            this.tmpForViewPanel = File.createTempFile("jpdf", ".pdf");
            this.tmpForViewPanel.deleteOnExit();
            iBookmarksConverter.createUnencryptedCopy(this.tmpForViewPanel);
            this.viewPanel.open(this.tmpForViewPanel);
        } else {
            this.viewPanel.open(file);
        }
        this.showOnOpen = iBookmarksConverter.showBookmarksOnOpen();
        this.root = iBookmarksConverter.getRootBookmark(this.userPrefs.getConvertNamedDestinations());
        iBookmarksConverter.close();
        iBookmarksConverter = null;
        if (bl2 && this.ownerPassword == null) {
            operation = FileOperationEvent.Operation.FILE_READONLY;
            this.readonly = true;
        } else {
            operation = FileOperationEvent.Operation.FILE_OPENED;
        }
        this.fireFileOperationEvent(new FileOperationEvent((Object)this, this.filePath, operation));
    }

    public Bookmark getRootBookmark() {
        return this.root;
    }

    public void close() {
        this.viewPanel.close();
        if (this.tmpForViewPanel != null) {
            this.tmpForViewPanel.delete();
            this.tmpForViewPanel = null;
        }
        this.fileChanged = false;
        this.fireFileOperationEvent(new FileOperationEvent((Object)this, this.filePath, FileOperationEvent.Operation.FILE_CLOSED));
        this.filePath = null;
        this.file = null;
        if (this.ownerPassword != null) {
            Arrays.fill(this.ownerPassword, (byte)0);
            this.ownerPassword = null;
        }
        if (this.userPassword != null) {
            Arrays.fill(this.userPassword, (byte)0);
            this.userPassword = null;
        }
        this.readonly = false;
    }

    public void setFileChanged(boolean bl) {
        if (this.fileChanged != bl) {
            this.fileChanged = bl;
            this.fireFileOperationEvent(new FileOperationEvent((Object)this, this.filePath, FileOperationEvent.Operation.FILE_CHANGED));
        }
    }

    public boolean getFileChanged() {
        return this.fileChanged;
    }

    public boolean save(Bookmark bookmark) {
        return this.saveAs(bookmark, this.filePath);
    }

    public boolean saveAs(Bookmark bookmark, String string) {
        boolean bl = false;
        try {
            IBookmarksConverter iBookmarksConverter = Bookmark.getBookmarksConverter();
            if (iBookmarksConverter == null) {
                throw new ServiceNotFoundException(Res.getString("ERROR_BOOKMARKS_CONVERTER_NOT_FOUND"));
            }
            iBookmarksConverter.open(this.filePath, this.userPassword);
            iBookmarksConverter.setShowBookmarksOnOpen(this.showOnOpen);
            iBookmarksConverter.rebuildBookmarksFromTreeNodes(bookmark);
            iBookmarksConverter.save(string, this.userPassword, this.ownerPassword);
            bl = true;
            this.filePath = string;
            this.file = new File(string);
            if (this.tmpForViewPanel != null) {
                this.viewPanel.reopen(this.tmpForViewPanel);
            } else {
                this.viewPanel.reopen(this.file);
            }
            this.fireFileOperationEvent(new FileOperationEvent((Object)this, string, FileOperationEvent.Operation.FILE_SAVED));
            this.setFileChanged(false);
            iBookmarksConverter.close();
            iBookmarksConverter = null;
            return bl;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "JPdfBookmarks", 0);
            return false;
        }
    }

    public IPdfView getViewPanel() {
        return this.viewPanel;
    }

    public void addFileOperationListener(FileOperationListener fileOperationListener) {
        this.fileOperationListeners.add(fileOperationListener);
    }

    public void removeFileOperationListener(FileOperationListener fileOperationListener) {
        this.fileOperationListeners.remove(fileOperationListener);
    }

    public boolean getShowBookmarksOnOpen() {
        return this.showOnOpen;
    }

    public void setShowBookmarksOnOpen(boolean bl) {
        this.showOnOpen = bl;
        this.setFileChanged(true);
    }

    private void fireFileOperationEvent(FileOperationEvent fileOperationEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (FileOperationListener fileOperationListener : this.fileOperationListeners) {
                fileOperationListener.fileOperation(fileOperationEvent);
            }
        } else {
            SwingUtilities.invokeLater(new FireInEventThread(fileOperationEvent));
        }
    }

    public ArrayList<Bookmark> getLinksOnPage(int n) {
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
        try {
            IBookmarksConverter iBookmarksConverter = Bookmark.getBookmarksConverter();
            if (iBookmarksConverter == null) {
                throw new ServiceNotFoundException(Res.getString("ERROR_BOOKMARKS_CONVERTER_NOT_FOUND"));
            }
            iBookmarksConverter.open(this.filePath, this.userPassword);
            ArrayList arrayList2 = iBookmarksConverter.getLinks(n, this.userPrefs.getConvertNamedDestinations());
            Collections.sort(arrayList2, new Comparator<IBookmarksConverter.AnnotationRect>(){

                @Override
                public int compare(IBookmarksConverter.AnnotationRect annotationRect, IBookmarksConverter.AnnotationRect annotationRect2) {
                    if (annotationRect.lly > annotationRect2.lly) {
                        return -1;
                    }
                    if (annotationRect.lly < annotationRect2.lly) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (IBookmarksConverter.AnnotationRect annotationRect : arrayList2) {
                JPedalViewPanel jPedalViewPanel = (JPedalViewPanel)this.viewPanel;
                String string = jPedalViewPanel.extractTextInRect(annotationRect.llx, annotationRect.ury, annotationRect.urx, annotationRect.lly);
                for (int i = 0; string == null && i < 10; ++i) {
                    string = jPedalViewPanel.extractTextInRect(annotationRect.llx, ++annotationRect.ury, annotationRect.urx, --annotationRect.lly);
                }
                if (string != null) {
                    annotationRect.bookmark.setTitle(string);
                }
                arrayList.add(annotationRect.bookmark);
            }
            iBookmarksConverter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "JPdfBookmarks", 0);
        }
        return arrayList;
    }

    byte[] getPassword() {
        return this.userPassword;
    }

    private class FireInEventThread
    implements Runnable {
        FileOperationEvent e;

        public FireInEventThread(FileOperationEvent fileOperationEvent) {
            this.e = fileOperationEvent;
        }

        @Override
        public void run() {
            UnifiedFileOperator.this.fireFileOperationEvent(this.e);
        }
    }
}

