/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public abstract class UndoableBookmarksAction
extends AbstractUndoableEdit {
    protected DefaultTreeModel treeModel;
    protected ArrayList<Bookmark> selectedBookmarks;
    protected ArrayList<Bookmark> backupBookmarks;
    protected JTree tree;

    protected UndoableBookmarksAction(JTree jTree) {
        this.tree = jTree;
        this.treeModel = (DefaultTreeModel)jTree.getModel();
        this.selectedBookmarks = this.getSelectedBookmarks();
        this.backupBookmarks = this.backupBookmarks(this.selectedBookmarks);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doEdit();
    }

    public abstract void doEdit();

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = 0; i < this.selectedBookmarks.size(); ++i) {
            this.selectedBookmarks.get(i).cloneDestination(this.backupBookmarks.get(i));
            this.selectedBookmarks.get(i).cloneAppearance(this.backupBookmarks.get(i));
        }
    }

    private ArrayList<Bookmark> backupBookmarks(ArrayList<Bookmark> arrayList) {
        ArrayList<Bookmark> arrayList2 = new ArrayList<Bookmark>(arrayList.size());
        for (Bookmark bookmark : arrayList) {
            Bookmark bookmark2 = Bookmark.cloneBookmark((Bookmark)bookmark, (boolean)false);
            arrayList2.add(bookmark2);
        }
        return arrayList2;
    }

    protected final Bookmark getSelectedBookmark() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Bookmark bookmark = null;
        try {
            bookmark = (Bookmark)treePath.getLastPathComponent();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return bookmark;
    }

    protected final ArrayList<Bookmark> getSelectedBookmarks() {
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                arrayList.add((Bookmark)treePath.getLastPathComponent());
            }
        }
        return arrayList;
    }
}

