/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.CursorToolkit;
import it.flavianopetrocchi.jpdfbookmarks.DummyPageProducer;
import it.flavianopetrocchi.jpdfbookmarks.FitType;
import it.flavianopetrocchi.jpdfbookmarks.IPage;
import it.flavianopetrocchi.jpdfbookmarks.IPageProducer;
import it.flavianopetrocchi.jpdfbookmarks.IPdfView;
import it.flavianopetrocchi.jpdfbookmarks.JPdfBookmarks;
import it.flavianopetrocchi.jpdfbookmarks.PageChangedEvent;
import it.flavianopetrocchi.jpdfbookmarks.PageChangedListener;
import it.flavianopetrocchi.jpdfbookmarks.PageDimension;
import it.flavianopetrocchi.jpdfbookmarks.RenderingStartEvent;
import it.flavianopetrocchi.jpdfbookmarks.RenderingStartListener;
import it.flavianopetrocchi.jpdfbookmarks.TextCopiedListener;
import it.flavianopetrocchi.jpdfbookmarks.ViewChangedEvent;
import it.flavianopetrocchi.jpdfbookmarks.ViewChangedListener;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.IBookmarksConverter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class PdfViewAdapter
extends JScrollPane
implements IPdfView {
    private ArrayList<PageChangedListener> pageChangedListeners = new ArrayList();
    private ArrayList<ViewChangedListener> viewChangedListeners = new ArrayList();
    private ArrayList<RenderingStartListener> renderingStartListeners = new ArrayList();
    private int top = -1;
    private int left = -1;
    private int bottom = -1;
    private int right = -1;
    private float scale = 1.0f;
    private int currentPage;
    private int oldPage = -2;
    private PdfRenderPanel rendererPanel;
    private FitType fitType = FitType.FitPage;
    private int numberOfPages;
    private IPage currentPageObject;
    private IPageProducer pageProducer;
    private boolean drawingComplete = true;
    private Rectangle rect = null;
    private BufferedImage img;
    private float oldScale;
    volatile boolean painting = false;
    private IBookmarksConverter converter = null;

    public PdfViewAdapter() {
        this.rendererPanel = new PdfRenderPanel();
        this.viewport.setBackground(Color.gray);
        this.setViewportView(this.rendererPanel);
        this.addComponentListener(new ResizeListener());
    }

    public PdfViewAdapter(FitType fitType) {
        this();
        this.fitType = fitType;
    }

    @Override
    public void open(File file) {
        this.pageProducer = new DummyPageProducer();
        DummyPageProducer dummyPageProducer = (DummyPageProducer)this.pageProducer;
        dummyPageProducer.setIBookmarksConverter(this.converter);
    }

    @Override
    public void reopen(File file) throws Exception {
        this.close();
        this.open(file);
    }

    @Override
    public void close() {
        this.img = null;
        this.currentPage = 0;
        if (this.converter != null) {
            try {
                this.converter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.converter = null;
        }
        this.numberOfPages = 1;
        this.rendererPanel.repaint();
    }

    @Override
    public void goToFirstPage() {
        this.goToPage(1);
    }

    @Override
    public void goToPreviousPage() {
        this.goToPage(this.currentPage);
    }

    @Override
    public void goToPage(int n) {
        boolean bl = true;
        boolean bl2 = true;
        if (this.numberOfPages == 1) {
            this.currentPage = 0;
            bl2 = false;
            bl = false;
        } else if (n <= 1) {
            this.currentPage = 0;
            bl2 = false;
        } else if (n >= this.numberOfPages) {
            this.currentPage = this.numberOfPages - 1;
            bl = false;
        } else {
            this.currentPage = n - 1;
        }
        try {
            this.currentPageObject = this.pageProducer.getPage(this.currentPage + 1);
        }
        catch (Exception exception) {
            JPdfBookmarks.printErrorForDebug(exception);
        }
        this.rendererPanel.repaint();
        this.firePageChangedEvent(new PageChangedEvent(this, this.currentPage + 1, bl, bl2));
    }

    @Override
    public void goToNextPage() {
        this.goToPage(this.currentPage + 2);
    }

    @Override
    public void goToLastPage() {
        this.goToPage(this.numberOfPages);
    }

    public void goToBookmark(Bookmark bookmark) {
        int n = bookmark.getPageNumber();
        this.goToPage(n);
    }

    @Override
    public void setFitWidth(int n) {
        this.top = n;
        this.setFit(FitType.FitWidth);
    }

    @Override
    public void setFitHeight(int n) {
        this.left = n;
        this.setFit(FitType.FitHeight);
    }

    @Override
    public void setFitPage() {
        this.setFit(FitType.FitPage);
    }

    @Override
    public void setFitRect(Rectangle rectangle) {
        this.rect = rectangle;
        this.drawingComplete = true;
        this.setFit(FitType.FitRect);
    }

    @Override
    public void setFitRect(int n, int n2, int n3, int n4) {
        this.drawingComplete = true;
        PageDimension pageDimension = this.currentPageObject.getSize(1.0f);
        this.rect = new Rectangle(n2, Math.round(pageDimension.getHeight() - (float)n), n4 - n2, n - n3);
        this.setFit(FitType.FitRect);
    }

    @Override
    public void setTopLeftZoom(int n, int n2, float f) {
        this.left = n2;
        this.top = n;
        if (f > 0.001f) {
            this.scale = f;
        }
        this.setFit(FitType.TopLeftZoom);
    }

    @Override
    public int getNumPages() {
        if (this.converter != null) {
            this.numberOfPages = this.converter.getCountOfPages();
        }
        return this.numberOfPages;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage + 1;
    }

    @Override
    public FitType getFitType() {
        return this.fitType;
    }

    @Override
    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.pageChangedListeners.add(pageChangedListener);
    }

    @Override
    public void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.pageChangedListeners.remove(pageChangedListener);
    }

    @Override
    public void setFitNative() {
        this.setFit(FitType.FitNative);
    }

    public void setFit(FitType fitType) {
        this.fitType = fitType;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PdfViewAdapter.this.fitType == FitType.FitRect) {
                    PdfViewAdapter.this.setCursor(Cursor.getPredefinedCursor(1));
                } else {
                    PdfViewAdapter.this.rect = null;
                    PdfViewAdapter.this.setCursor(Cursor.getDefaultCursor());
                }
                PdfViewAdapter.this.calcScaleFactor();
                PdfViewAdapter.this.adjustPreferredSize();
                PdfViewAdapter.this.adjustViewportPosition();
            }
        });
        this.rendererPanel.repaint();
    }

    private void movePanel(int n, int n2) {
        Point point = this.viewport.getViewPosition();
        point.x = n;
        point.y = n2;
        point.x = Math.max(0, point.x);
        point.x = Math.min(this.getMaxXExtent(), point.x);
        point.y = Math.max(0, point.y);
        point.y = Math.min(this.getMaxYExtent(), point.y);
        this.viewport.setViewPosition(point);
    }

    private int getMaxXExtent() {
        return this.viewport.getView().getWidth() - this.viewport.getWidth();
    }

    private int getMaxYExtent() {
        return this.viewport.getView().getHeight() - this.viewport.getHeight();
    }

    private void calcScaleFactor() {
        PageDimension pageDimension = this.currentPageObject.getSize(1.0f);
        switch (this.fitType) {
            case FitWidth: {
                this.scale = (float)this.viewport.getWidth() / pageDimension.getWidth();
                break;
            }
            case FitHeight: {
                this.scale = (float)this.viewport.getHeight() / pageDimension.getHeight();
                break;
            }
            case FitNative: {
                this.scale = 1.0f;
                break;
            }
            case FitRect: {
                if (this.rect == null || !this.drawingComplete) break;
                float f = (float)this.viewport.getWidth() / (float)this.rect.width;
                float f2 = (float)this.viewport.getHeight() / (float)this.rect.height;
                this.scale = Math.min(f, f2);
                break;
            }
            case FitPage: {
                float f = (float)this.viewport.getWidth() / pageDimension.getWidth();
                float f3 = (float)this.viewport.getHeight() / pageDimension.getHeight();
                this.scale = Math.min(f, f3);
            }
        }
    }

    private void adjustPreferredSize() {
        this.rendererPanel.setSize(this.calcViewSize());
    }

    @Override
    public Bookmark getBookmarkFromView() {
        Bookmark bookmark = new Bookmark();
        bookmark.setPageNumber(this.getCurrentPage());
        bookmark.setType(this.getFitType().convertToBookmarkType());
        PageDimension pageDimension = this.currentPageObject.getSize(1.0f);
        Point point = this.viewport.getViewPosition();
        switch (bookmark.getType()) {
            case FitWidth: {
                bookmark.setTop(Math.round(pageDimension.getHeight() - (float)point.y / this.scale));
                bookmark.setThousandthsTop(Bookmark.thousandthsVertical((int)bookmark.getTop(), (float)pageDimension.getHeight()));
                break;
            }
            case FitHeight: {
                bookmark.setLeft(Math.round((float)point.x / this.scale));
                bookmark.setThousandthsLeft(Bookmark.thousandthsHorizontal((int)bookmark.getLeft(), (float)pageDimension.getWidth()));
                break;
            }
            case TopLeftZoom: {
                bookmark.setTop(Math.round(pageDimension.getHeight() - (float)point.y / this.scale));
                bookmark.setThousandthsTop(Bookmark.thousandthsVertical((int)bookmark.getTop(), (float)pageDimension.getHeight()));
                bookmark.setLeft(Math.round((float)point.x / this.scale));
                bookmark.setThousandthsLeft(Bookmark.thousandthsHorizontal((int)bookmark.getLeft(), (float)pageDimension.getWidth()));
                bookmark.setZoom(this.scale);
                break;
            }
            case FitRect: {
                if (this.rect == null) break;
                float f = this.drawingComplete ? 1.0f : this.scale;
                Point point2 = this.rect.getLocation();
                Dimension dimension = this.rect.getSize();
                bookmark.setLeft(Math.round((float)point2.x / f));
                bookmark.setThousandthsLeft(Bookmark.thousandthsHorizontal((int)bookmark.getLeft(), (float)pageDimension.getWidth()));
                bookmark.setTop(Math.round(pageDimension.getHeight() - (float)Math.round((float)point2.y / f)));
                bookmark.setThousandthsTop(Bookmark.thousandthsVertical((int)bookmark.getTop(), (float)pageDimension.getHeight()));
                bookmark.setRight(Math.round((float)point2.x / f) + Math.round((float)dimension.width / f));
                bookmark.setThousandthsRight(Bookmark.thousandthsHorizontal((int)bookmark.getRight(), (float)pageDimension.getWidth()));
                bookmark.setBottom(Math.round(pageDimension.getHeight() - (float)(Math.round((float)point2.y / f) + Math.round((float)dimension.height / f))));
                bookmark.setThousandthsBottom(Bookmark.thousandthsVertical((int)bookmark.getBottom(), (float)pageDimension.getWidth()));
            }
        }
        return bookmark;
    }

    private Dimension calcViewSize() {
        PageDimension pageDimension = this.currentPageObject.getSize(this.scale);
        int n = Math.max(Math.round(pageDimension.getWidth()), this.viewport.getWidth());
        int n2 = Math.max(Math.round(pageDimension.getHeight()), this.viewport.getHeight());
        switch (this.fitType) {
            case FitWidth: {
                n2 = Math.round(pageDimension.getHeight() + (float)this.viewport.getHeight());
                break;
            }
            case FitHeight: {
                n = Math.round(pageDimension.getWidth()) + this.viewport.getWidth();
                break;
            }
            case FitPage: {
                break;
            }
            case FitNative: 
            case FitRect: 
            case TopLeftZoom: {
                n = this.viewport.getWidth() + Math.round(pageDimension.getWidth());
                n2 = this.viewport.getHeight() + Math.round(pageDimension.getHeight());
            }
        }
        return new Dimension(n, n2);
    }

    private void adjustViewportPosition() {
        PageDimension pageDimension = this.currentPageObject.getSize(this.scale);
        switch (this.fitType) {
            case FitPage: {
                this.movePanel(0, 0);
                break;
            }
            case FitWidth: {
                if (this.top == -1) break;
                float f = pageDimension.getHeight() - (float)this.top * this.scale;
                this.movePanel(0, Math.round(f));
                break;
            }
            case FitHeight: {
                if (this.left == -1) break;
                float f = (float)this.left * this.scale;
                this.movePanel(Math.round(f), 0);
                break;
            }
            case FitRect: {
                if (this.rect == null || !this.drawingComplete) break;
                this.movePanel(Math.round((float)this.rect.x * this.scale), Math.round((float)this.rect.y * this.scale));
                break;
            }
            case TopLeftZoom: {
                Point point = this.viewport.getViewPosition();
                int n = this.top != -1 ? Math.round(pageDimension.getHeight() - (float)this.top * this.scale) : point.y;
                int n2 = this.left != -1 ? Math.round((float)this.left * this.scale) : point.x;
                this.movePanel(n2, n);
            }
        }
    }

    private void firePageChangedEvent(PageChangedEvent pageChangedEvent) {
        for (PageChangedListener pageChangedListener : this.pageChangedListeners) {
            pageChangedListener.pageChanged(pageChangedEvent);
        }
    }

    private void fireViewChangedEvent(ViewChangedEvent viewChangedEvent) {
        for (ViewChangedListener viewChangedListener : this.viewChangedListeners) {
            viewChangedListener.viewChanged(viewChangedEvent);
        }
    }

    private void fireRenderingStartEvent(RenderingStartEvent renderingStartEvent) {
        for (RenderingStartListener renderingStartListener : this.renderingStartListeners) {
            renderingStartListener.renderingStart(renderingStartEvent);
        }
    }

    @Override
    public void addViewChangedListener(ViewChangedListener viewChangedListener) {
        this.viewChangedListeners.add(viewChangedListener);
    }

    @Override
    public void removeViewChangedListener(ViewChangedListener viewChangedListener) {
        this.viewChangedListeners.remove(viewChangedListener);
    }

    @Override
    public void addRenderingStartListener(RenderingStartListener renderingStartListener) {
        this.renderingStartListeners.add(renderingStartListener);
    }

    @Override
    public void removeRenderingStartListener(RenderingStartListener renderingStartListener) {
        this.renderingStartListeners.remove(renderingStartListener);
    }

    void setIBookmarksConverter(IBookmarksConverter iBookmarksConverter) {
        this.converter = iBookmarksConverter;
        this.numberOfPages = this.converter.getCountOfPages();
    }

    @Override
    public void setTextSelectionMode(boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setConnectToClipboard(Boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addTextCopiedListener(TextCopiedListener textCopiedListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeTextCopiedListener(TextCopiedListener textCopiedListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void open(File file, String string) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String extractText(Rectangle rectangle) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JScrollPane getThumbnails() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class PdfRenderPanel
    extends JPanel
    implements Scrollable {
        public PdfRenderPanel() {
            this.setFocusable(true);
            PdfPanelMouseListener pdfPanelMouseListener = new PdfPanelMouseListener();
            this.addMouseListener(pdfPanelMouseListener);
            this.addMouseMotionListener(pdfPanelMouseListener);
            this.setBackground(Color.gray);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            Object object;
            super.paintComponent(graphics);
            if (PdfViewAdapter.this.currentPageObject == null) {
                this.setPreferredSize(PdfViewAdapter.this.viewport.getSize());
                this.revalidate();
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = false;
            PdfViewAdapter.this.calcScaleFactor();
            if (PdfViewAdapter.this.oldScale != PdfViewAdapter.this.scale || PdfViewAdapter.this.currentPage != PdfViewAdapter.this.oldPage || PdfViewAdapter.this.img == null) {
                CursorToolkit.startWaitCursor(PdfViewAdapter.this);
                try {
                    PdfViewAdapter.this.img = PdfViewAdapter.this.currentPageObject.getImage(PdfViewAdapter.this.scale);
                    PdfViewAdapter.this.oldScale = PdfViewAdapter.this.scale;
                    PdfViewAdapter.this.oldPage = PdfViewAdapter.this.currentPage;
                }
                catch (Exception exception) {
                    JPdfBookmarks.printErrorForDebug(exception);
                }
                finally {
                    CursorToolkit.stopWaitCursor(PdfViewAdapter.this);
                }
            }
            this.setPreferredSize(PdfViewAdapter.this.calcViewSize());
            this.revalidate();
            if (PdfViewAdapter.this.fitType == FitType.FitRect && !PdfViewAdapter.this.drawingComplete && PdfViewAdapter.this.rect != null && PdfViewAdapter.this.img != null) {
                object = new BufferedImage(PdfViewAdapter.this.img.getWidth(), PdfViewAdapter.this.img.getHeight(), PdfViewAdapter.this.img.getType());
                Graphics graphics2 = ((BufferedImage)object).getGraphics();
                graphics2.drawImage(PdfViewAdapter.this.img, 0, 0, null);
                Graphics2D graphics2D2 = (Graphics2D)((BufferedImage)object).getGraphics();
                graphics2D2.setStroke(new BasicStroke(2.0f));
                graphics2D2.setColor(Color.red);
                graphics2D2.drawRect(((PdfViewAdapter)PdfViewAdapter.this).rect.x, ((PdfViewAdapter)PdfViewAdapter.this).rect.y, ((PdfViewAdapter)PdfViewAdapter.this).rect.width, ((PdfViewAdapter)PdfViewAdapter.this).rect.height);
                graphics2D.drawImage((Image)object, 0, 0, this);
            } else if (PdfViewAdapter.this.img != null) {
                graphics2D.drawImage((Image)PdfViewAdapter.this.img, 0, 0, this);
            }
            object = PdfViewAdapter.this.getBookmarkFromView();
            PdfViewAdapter.this.fireViewChangedEvent(new ViewChangedEvent(this, PdfViewAdapter.this.fitType, PdfViewAdapter.this.scale, (Bookmark)object));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        private class PdfPanelMouseListener
        extends MouseAdapter {
            private int xDiff;
            private int yDiff;

            private PdfPanelMouseListener() {
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (PdfViewAdapter.this.fitType != FitType.FitRect) {
                    Point point = PdfViewAdapter.this.viewport.getViewPosition();
                    int n = point.x - (mouseEvent.getX() - this.xDiff);
                    int n2 = point.y - (mouseEvent.getY() - this.yDiff);
                    Dimension dimension = PdfViewAdapter.this.viewport.getPreferredSize();
                    int n3 = dimension.width - PdfViewAdapter.this.viewport.getWidth();
                    int n4 = dimension.height - PdfViewAdapter.this.viewport.getHeight();
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > n3) {
                        n = n3;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 > n4) {
                        n2 = n4;
                    }
                    PdfViewAdapter.this.viewport.setViewPosition(new Point(n, n2));
                } else {
                    if (mouseEvent.getX() < this.xDiff) {
                        PdfViewAdapter.this.rect.setLocation(mouseEvent.getX(), ((PdfViewAdapter)PdfViewAdapter.this).rect.y);
                    }
                    if (mouseEvent.getY() < this.yDiff) {
                        PdfViewAdapter.this.rect.setLocation(((PdfViewAdapter)PdfViewAdapter.this).rect.x, mouseEvent.getY());
                    }
                    int n = Math.abs(mouseEvent.getX() - this.xDiff);
                    int n5 = Math.abs(mouseEvent.getY() - this.yDiff);
                    PdfViewAdapter.this.rect.setSize(n, n5);
                    PdfRenderPanel.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                PdfRenderPanel.this.requestFocusInWindow();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.xDiff = mouseEvent.getX();
                this.yDiff = mouseEvent.getY();
                if (PdfViewAdapter.this.fitType != FitType.FitRect) {
                    PdfRenderPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    PdfViewAdapter.this.rect = new Rectangle();
                    PdfViewAdapter.this.rect.setLocation(this.xDiff, this.yDiff);
                    PdfViewAdapter.this.drawingComplete = false;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (PdfViewAdapter.this.fitType == FitType.FitRect) {
                    PdfViewAdapter.this.drawingComplete = true;
                    PdfViewAdapter.this.rect.setSize(Math.round((float)((PdfViewAdapter)PdfViewAdapter.this).rect.width / PdfViewAdapter.this.scale), Math.round((float)((PdfViewAdapter)PdfViewAdapter.this).rect.height / PdfViewAdapter.this.scale));
                    PdfViewAdapter.this.rect.setLocation(Math.round((float)((PdfViewAdapter)PdfViewAdapter.this).rect.x / PdfViewAdapter.this.scale), Math.round((float)((PdfViewAdapter)PdfViewAdapter.this).rect.y / PdfViewAdapter.this.scale));
                    PdfViewAdapter.this.setFitRect(PdfViewAdapter.this.rect);
                    PdfRenderPanel.this.repaint();
                } else {
                    PdfRenderPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            super.componentResized(componentEvent);
        }
    }
}

