/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.utilities;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerTextField
extends JTextField {
    public IntegerTextField(int cols) {
        super(cols);
        this.setMaximumSize(new Dimension(this.getColumnWidth() * cols, 24));
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IntegerTextField.this.setSelectionStart(0);
                IntegerTextField.this.setSelectionEnd(IntegerTextField.this.getText().length());
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    public int getInteger() {
        int num = 0;
        try {
            num = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    public void setInteger(int num) {
        this.setText(String.valueOf(num));
    }

    protected Document createDefaultModel() {
        return new NumberTextDocument();
    }

    static class NumberTextDocument
    extends PlainDocument {
        NumberTextDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] origin = str.toCharArray();
            StringBuffer numbersOnly = new StringBuffer("");
            for (int i = 0; i < origin.length; ++i) {
                if (!Character.isDigit(origin[i])) continue;
                numbersOnly.append(origin[i]);
            }
            super.insertString(offs, numbersOnly.toString(), a);
        }
    }
}

