/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.mousedraggabletree;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class UndoableNodeMoved
extends AbstractUndoableEdit {
    private DefaultTreeModel defaultModel;
    private MutableTreeNode movedNode;
    private MutableTreeNode oldParent;
    private int oldParentIndex;
    private MutableTreeNode newParent;
    private int newParentIndex;
    private String presentation = "";

    public UndoableNodeMoved(DefaultTreeModel treeModel, MutableTreeNode moved, MutableTreeNode oldParent, int oldParentIndex, MutableTreeNode newParent, int newParentIndex) {
        this.movedNode = moved;
        this.oldParent = oldParent;
        this.oldParentIndex = oldParentIndex;
        this.newParent = newParent;
        this.newParentIndex = newParentIndex;
        this.defaultModel = treeModel;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.oldParent.insert(this.movedNode, this.oldParentIndex);
        this.defaultModel.nodeStructureChanged(this.oldParent);
        this.defaultModel.nodeStructureChanged(this.newParent);
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.doEdit();
    }

    public void doEdit() {
        this.newParent.insert(this.movedNode, this.newParentIndex);
        this.defaultModel.nodeStructureChanged(this.newParent);
        this.defaultModel.nodeStructureChanged(this.oldParent);
    }

    public String getPresentationName() {
        return this.presentation;
    }

    public void setPresentationName(String presentation) {
        this.presentation = presentation;
    }
}

