/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.objects.TextStyle;
import emsl.text.TextData;
import emsl.text.TextObject;
import emsl.text.TextPanel;
import emsl.text.TextWord;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class TextLine
extends TextObject {
    private TextPanel parent;
    private Vector wordList;
    private int totalCharWidth;
    private int totalSpaces;
    private double interWordSpace;
    private boolean isParagraphEnd;

    public TextLine(TextData textData, int n, TextPanel textPanel) {
        super(textData, n);
        this.parent = textPanel;
        this.wordList = new Vector();
        this.interWordSpace = 0.0;
        this.totalSpaces = 0;
        this.totalCharWidth = 0;
        this.isParagraphEnd = false;
        this.setWidth(textPanel.getPixelBounds().width - textPanel.getInsets().left - textPanel.getInsets().right);
    }

    public Vector getWordList() {
        return this.wordList;
    }

    public boolean isEmpty() {
        return this.getWidthIndex() <= 0;
    }

    public boolean isParagraphEnd() {
        return this.isParagraphEnd;
    }

    public boolean isParagraphStart() {
        if (this.getStartIndex() == 0) {
            return true;
        }
        return this.getTextData().isNewLine(this.getStartIndex());
    }

    public void layoutLine() {
        Vector vector = new Vector();
        boolean bl = true;
        boolean bl2 = true;
        do {
            int n = this.getStartIndex() + this.getWidthIndex();
            Object object = this.getTextWords(n, bl2);
            bl2 = false;
            bl = this.testWordsToLine(object);
            if (!bl) continue;
            this.addWordsToLine(vector, object);
        } while (bl);
        this.wordList = vector;
        this.getLineMetrics();
        this.getWordSpacing();
        this.setWordCoordinates();
    }

    public Object getTextWords(int n, boolean bl) {
        TextWord textWord = new TextWord(this.getTextData(), this, n, bl);
        if (textWord.isEmpty()) {
            this.isParagraphEnd = true;
            return null;
        }
        if (this.getTextData().isNewLine(n) && !bl) {
            this.isParagraphEnd = true;
            return null;
        }
        if (textWord.isSplitable()) {
            return textWord;
        }
        Vector<TextWord> vector = new Vector<TextWord>();
        vector.addElement(textWord);
        do {
            int n2 = textWord.getEndIndex() + 1;
            textWord = new TextWord(this.getTextData(), this, n2, false);
            if (textWord.isEmpty()) {
                return vector;
            }
            vector.addElement(textWord);
        } while (!textWord.isSplitable());
        return vector;
    }

    private boolean testWordsToLine(Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n = this.totalCharWidth;
        if (object instanceof TextWord) {
            object2 = (TextWord)object;
            n = ((TextWord)object2).isTab() ? (n += this.getTabWidth((TextWord)object2, n)) : (n += ((TextObject)object2).getWidth());
        }
        if (object instanceof Vector) {
            object2 = (Vector)object;
            int n2 = ((Vector)object2).size() - 1;
            while (n2 >= 0) {
                TextWord textWord = (TextWord)((Vector)object2).elementAt(n2);
                n += textWord.getWidth();
                --n2;
            }
        }
        return n <= this.getWidth();
    }

    private int getTabWidth(TextWord textWord, int n) {
        TextStyle textStyle = textWord.getTextStyle();
        int n2 = textStyle.getAlignment();
        if (n2 != 1) {
            return textWord.getWidth();
        }
        int n3 = (n / 36 + 1) * 36;
        int n4 = n3 - n;
        textWord.setWidth(n4);
        return n4;
    }

    private void addWordsToLine(Vector vector, Object object) {
        if (object instanceof TextWord) {
            this.addWordToLine(vector, (TextWord)object);
        }
        if (object instanceof Vector) {
            Vector vector2 = (Vector)object;
            int n = 0;
            while (n < vector2.size()) {
                this.addWordToLine(vector, (TextWord)vector2.elementAt(n));
                ++n;
            }
        }
        ++this.totalSpaces;
    }

    private void addWordToLine(Vector vector, TextWord textWord) {
        vector.addElement(textWord);
        this.totalCharWidth += textWord.getWidth();
        this.setWidthIndex(this.getWidthIndex() + textWord.getWidthIndex());
    }

    private void getLineMetrics() {
        Enumeration enumeration = this.wordList.elements();
        while (enumeration.hasMoreElements()) {
            TextWord textWord = (TextWord)enumeration.nextElement();
            if (this.getAscent() < textWord.getAscent()) {
                this.setAscent(textWord.getAscent());
            }
            if (this.getDescent() < textWord.getDescent()) {
                this.setDescent(textWord.getDescent());
            }
            if (this.getLineSpace() >= textWord.getLineSpace()) continue;
            this.setLineSpace(textWord.getLineSpace());
        }
        this.setLineSpace(this.getLineSpace() * 2);
    }

    private void getWordSpacing() {
        this.interWordSpace = 0.0;
        int n = this.getWidth() - this.totalCharWidth;
        if (n <= 0) {
            return;
        }
        if (this.totalSpaces - 1 < 1) {
            return;
        }
        this.interWordSpace = (double)n / (double)(this.totalSpaces - 1);
    }

    private void setWordCoordinates() {
        if (this.wordList.size() <= 0) {
            return;
        }
        TextWord textWord = (TextWord)this.wordList.elementAt(0);
        TextStyle textStyle = textWord.getTextStyle();
        int n = textStyle.getAlignment();
        double d = 0.0;
        if (n == 3) {
            d = (double)(this.getWidth() - this.totalCharWidth) / 2.0;
        }
        if (n == 2) {
            d = this.getWidth() - this.totalCharWidth;
        }
        if (n == 4 && this.isParagraphEnd) {
            n = 1;
        }
        if (n != 4) {
            this.interWordSpace = 0.0;
        }
        int n2 = 0;
        while (n2 < this.wordList.size()) {
            textWord = (TextWord)this.wordList.elementAt(n2);
            textWord.setX((int)d);
            textWord.setAscent(this.getAscent());
            textWord.setDescent(this.getDescent());
            textWord.setLineSpace(this.getLineSpace());
            d += (double)textWord.getWidth();
            if (this.getTextData().isBreak(textWord.getEndIndex() + 1)) {
                d += this.interWordSpace;
            }
            ++n2;
        }
    }

    public boolean equals(TextLine textLine) {
        if (textLine == null) {
            return false;
        }
        if (this.getY() != textLine.getY()) {
            return false;
        }
        if (this.getStartIndex() != textLine.getStartIndex()) {
            return false;
        }
        if (this.getWidthIndex() != textLine.getWidthIndex()) {
            return false;
        }
        if (this.getWidth() != textLine.getWidth()) {
            return false;
        }
        if (this.getAscent() != textLine.getAscent()) {
            return false;
        }
        if (this.getDescent() != textLine.getDescent()) {
            return false;
        }
        if (this.getLineSpace() != textLine.getLineSpace()) {
            return false;
        }
        return !textLine.isEmpty() && !this.isEmpty();
    }

    public int getCharacterAt(int n, int n2) {
        TextWord textWord = (TextWord)TextObject.getObject(this.wordList, (double)(n -= this.getX()));
        return textWord.getCharacterAt(n, n2 -= this.getY());
    }

    public Rectangle getCharacterBounds(int n) {
        TextWord textWord = (TextWord)TextObject.getObject(this.wordList, n);
        if (textWord == null) {
            return null;
        }
        Rectangle rectangle = textWord.getCharacterBounds(n);
        if (rectangle == null) {
            return null;
        }
        rectangle.y += this.getY();
        rectangle.x += this.getX();
        return rectangle;
    }

    public TextStyle paint(Graphics graphics, TextStyle textStyle, int n, boolean bl) {
        int n2 = (this.getY() + this.getAscent()) * n / 100;
        int n3 = this.getX() * n / 100;
        try {
            int n4 = 0;
            while (n4 < this.wordList.size()) {
                TextWord textWord = (TextWord)this.wordList.elementAt(n4);
                textWord.setParent(this.parent);
                textStyle = textWord.paint(graphics, textStyle, n3, n2, n, bl);
                ++n4;
            }
        }
        catch (Exception exception) {
            System.out.println("Paint exception = " + exception.toString());
        }
        return textStyle;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TextLine object:");
        stringBuffer.append(" x=" + this.getX() + " y=" + this.getY());
        stringBuffer.append(" ascent=" + this.getAscent() + " descent=" + this.getDescent());
        stringBuffer.append("\n > ");
        Enumeration enumeration = this.wordList.elements();
        while (enumeration.hasMoreElements()) {
            TextWord textWord = (TextWord)enumeration.nextElement();
            stringBuffer.append("'" + textWord.toString() + "' ");
        }
        return stringBuffer.toString();
    }
}

