/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.text.TextPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class TextCursor
implements Runnable {
    private TextPanel textPanel;
    private Rectangle cursorBounds;
    private int cursorPosition;
    private Thread motor;
    private boolean isPainted;
    private boolean cursorOff;
    private Color cursorColor;
    private int lastCursorY;

    public TextCursor(TextPanel textPanel) {
        this.textPanel = textPanel;
        this.cursorHome();
        this.motor = new Thread(this);
        this.motor.start();
        this.isPainted = false;
        this.cursorOff = false;
        this.setCursorColor(null);
    }

    public void setCursorPosition(int n) {
        if (this.textPanel.getTextData() == null) {
            return;
        }
        if (this.isPainted) {
            this.paint();
        }
        this.cursorBounds = null;
        if (n >= this.textPanel.getTextData().getSize() - 2) {
            n = this.textPanel.getTextData().getSize() - 2;
        }
        if (n <= 0) {
            n = 0;
        }
        this.cursorPosition = n;
        if (n > this.textPanel.getTextDataEnd()) {
            this.textPanel.pageChange(n);
        }
        if (n < this.textPanel.getTextDataStart() - 1) {
            this.textPanel.pageChange(n);
        }
        this.paint();
        Rectangle rectangle = this.getCursorBounds();
        if (rectangle != null && rectangle.y != this.lastCursorY) {
            this.textPanel.sendActionEvent("Cursor Position Changed");
            this.lastCursorY = rectangle.y;
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean isOnScreen() {
        if (this.cursorPosition > this.textPanel.getTextDataEnd()) {
            return false;
        }
        return this.cursorPosition >= this.textPanel.getTextDataStart() - 1;
    }

    public void setCursorPosition(int n, int n2) {
        int n3 = this.textPanel.getCharacterAt(n, n2);
        if (n3 != -1) {
            this.setCursorPosition(n3);
        }
    }

    public Rectangle getCursorBounds() {
        if (this.cursorBounds == null) {
            this.cursorBounds = this.textPanel.getCharacterBounds(this.getCursorPosition());
        }
        if (this.cursorBounds == null) {
            return null;
        }
        return new Rectangle(this.cursorBounds);
    }

    public void cursorLeft() {
        this.setCursorPosition(this.getCursorPosition() - 1);
    }

    public void cursorRight() {
        this.setCursorPosition(this.getCursorPosition() + 1);
    }

    public void cursorUp() {
        Rectangle rectangle = this.getCursorBounds();
        if (rectangle == null) {
            return;
        }
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y - 2);
        this.setCursorPosition(point.x, point.y);
    }

    public void cursorDown() {
        Rectangle rectangle = this.getCursorBounds();
        if (rectangle == null) {
            return;
        }
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height + 2);
        this.setCursorPosition(point.x, point.y);
    }

    public void cursorHome() {
        int n = this.textPanel.getTextDataStart() - 1;
        if (this.textPanel.getTextData() != null && this.textPanel.getTextData().isNewPage(n + 1)) {
            ++n;
        }
        this.setCursorPosition(n);
    }

    public void cursorEnd() {
        this.setCursorPosition(this.textPanel.getTextDataEnd());
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
            this.paint();
        }
    }

    public void cursorOff() {
        if (this.isPainted) {
            this.paint();
        }
        this.cursorOff = true;
    }

    public void cursorOn() {
        this.cursorOff = false;
        if (!this.isPainted) {
            this.paint();
        }
    }

    public void cursorNew() {
        this.isPainted = false;
    }

    public void setCursorColor(Color color) {
        if (this.isPainted) {
            this.paint();
        }
        this.cursorColor = color;
        this.paint();
    }

    public void paint() {
        Graphics graphics = this.textPanel.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.cursorOff) {
            return;
        }
        if (!this.isOnScreen()) {
            return;
        }
        Rectangle rectangle = this.getCursorBounds();
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width - 1, rectangle.y, 2, rectangle.height);
        int n = this.textPanel.getViewScale();
        rectangle2.x = rectangle2.x * n / 100;
        rectangle2.y = rectangle2.y * n / 100;
        rectangle2.width = Math.max(1, rectangle2.width * n / 100);
        rectangle2.height = rectangle2.height * n / 100;
        if (this.cursorColor == null) {
            return;
        }
        graphics.setXORMode(this.cursorColor);
        graphics.setColor(this.textPanel.getBackground());
        Rectangle rectangle3 = this.textPanel.getScaledPixelBounds();
        Insets insets = this.textPanel.getInsets();
        rectangle3.x = insets.left;
        rectangle3.y = insets.top;
        rectangle3.width = rectangle3.width - insets.left - insets.right;
        rectangle3.height = rectangle3.height - insets.top - insets.bottom;
        graphics.setClip(rectangle3);
        graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.setPaintMode();
        if (this.isPainted) {
            this.isPainted = false;
            return;
        }
        this.isPainted = true;
    }
}

