/*
 * Decompiled with CFR 0.152.
 */
package emsl.objects;

import java.io.Serializable;
import java.util.Vector;

public class ReferenceStyle
implements Serializable {
    private String inlineFormat;
    private String entryFormat;
    private Vector keywords;

    public ReferenceStyle() {
        this.setInlineFormat("[<#>]");
        this.setEntryFormat("<authorF><authorS><coEtAl>,<i><journal><p><year><b><volume><p><page>");
        this.prepareKeywords();
    }

    public Object clone() {
        ReferenceStyle referenceStyle = new ReferenceStyle();
        referenceStyle.setInlineFormat(this.getInlineFormat());
        referenceStyle.setEntryFormat(this.getEntryFormat());
        return referenceStyle;
    }

    public void setInlineFormat(String string) {
        this.inlineFormat = new String(string);
    }

    public void setEntryFormat(String string) {
        this.entryFormat = new String(string);
    }

    public String getInlineFormat() {
        return this.inlineFormat;
    }

    public String getEntryFormat() {
        return this.entryFormat;
    }

    public Vector getKeywords() {
        return this.keywords;
    }

    public String getKeywordStart() {
        return "<";
    }

    public String getKeywordEnd() {
        return ">";
    }

    private void addKeyword(String string, String string2) {
        String string3 = String.valueOf(string) + "  " + this.getKeywordStart() + string2 + this.getKeywordEnd();
        if (string.equals("")) {
            string3 = "";
        }
        this.keywords.addElement(string3);
    }

    private void prepareKeywords() {
        this.keywords = new Vector();
        this.addKeyword("Author Firstname(s)", "authorF");
        this.addKeyword("Author Firstname Initial", "authorI");
        this.addKeyword("Author Surname", "authorS");
        this.addKeyword("", "");
        this.addKeyword("CoAuthor(s) as et al", "coEtAl");
        this.addKeyword("CoAuthor(s) as names", "coNames");
        this.addKeyword("", "");
        this.addKeyword("Paper Title", "title");
        this.addKeyword("", "");
        this.addKeyword("Journal Name", "journal");
        this.addKeyword("Journal Volume", "volume");
        this.addKeyword("Journal Page", "page");
        this.addKeyword("Journal Year", "year");
        this.addKeyword("", "");
        this.addKeyword("Reference Number", "#");
        this.addKeyword("", "");
        this.addKeyword("Plain Text", "p");
        this.addKeyword("Italic Text", "i");
        this.addKeyword("Bold Text", "b");
        this.addKeyword("Underline Text", "u");
        this.addKeyword("", "");
        this.addKeyword("Normal Script Text", "s");
        this.addKeyword("SuperScript Text", "s+");
        this.addKeyword("SubScript Text", "s-");
        this.addKeyword("", "");
        this.addKeyword("All lowercase", "cl");
        this.addKeyword("All uppercase", "cu");
        this.addKeyword("Normal case", "c");
        this.addKeyword("", "");
        this.addKeyword("New Line", "nl");
        this.addKeyword("Tab", "tab");
    }
}

