/*
 * Decompiled with CFR 0.152.
 */
package emsl.io;

import emsl.awt.GUIProgressBox;
import emsl.inch.ComponentObjectInputStream;
import emsl.io.FileManager;
import emsl.io.FileWriter;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;

public class FileReader {
    private Frame parentFrame;
    private FileManager fileManager;
    private GUIProgressBox progressBox;
    private ByteArrayInputStream byteStream;
    private ComponentObjectInputStream inputStream;

    public FileReader(Frame frame, FileManager fileManager) {
        this.parentFrame = frame;
        this.fileManager = fileManager;
    }

    public String loadText() {
        byte[] byArray = this.startProgressBox();
        String string = null;
        try {
            string = new String(byArray);
            String string2 = System.getProperty("line.separator");
            int n = 0;
            this.progressBox.setProgress("Converting Text...");
            do {
                if ((n = string.indexOf(string2, n + 1)) == -1) continue;
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
                stringBuffer.append("\n");
                stringBuffer.append(string.substring(n + string2.length()));
                string = stringBuffer.toString();
            } while (n != -1);
        }
        catch (Exception exception) {
            FileWriter.error(this.parentFrame, "Read Text File", exception, this.fileManager.getFile(), null);
            string = null;
        }
        this.stopProgressBox();
        return string;
    }

    public Hashtable loadData(ClassLoader classLoader) {
        byte[] byArray = this.startProgressBox();
        try {
            this.byteStream = new ByteArrayInputStream(byArray);
            this.inputStream = new ComponentObjectInputStream(classLoader, this.byteStream);
        }
        catch (Exception exception) {
            String string = "If you are trying to read in a Text File, use the menu item 'Open Text...'";
            FileWriter.error(this.parentFrame, "Open File", exception, this.fileManager.getFile(), string);
            this.stopProgressBox();
            return null;
        }
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        do {
            bl = this.loadObject(hashtable);
            Object v = hashtable.get("ITEM-COUNT");
            if (v == null) continue;
            this.progressBox.setTotalIncrements((Integer)v);
            hashtable.remove("ITEM-COUNT");
        } while (bl);
        this.stopProgressBox();
        return hashtable;
    }

    private boolean loadObject(Hashtable hashtable) {
        this.progressBox.setProgress("DeSerializing Object...");
        String string = null;
        Object object = null;
        try {
            String string2 = this.inputStream.readUTF();
            if (!string2.equals("EMSL-OBJECT-SECTION")) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        try {
            string = this.inputStream.readUTF();
        }
        catch (Exception exception) {
            FileWriter.error(this.parentFrame, "DeSerialize Object Name", exception, "Object Key", null);
            return true;
        }
        try {
            object = this.inputStream.readObject();
        }
        catch (Exception exception) {
            FileWriter.error(this.parentFrame, "DeSerialize Object", exception, string, null);
            return true;
        }
        if (object != null && string != null) {
            hashtable.put(string, object);
        }
        return true;
    }

    private byte[] startProgressBox() {
        this.progressBox = new GUIProgressBox(this.parentFrame);
        this.progressBox.setTotalIncrements(3);
        this.progressBox.display();
        this.progressBox.setProgress("Loading Data from Disk...");
        byte[] byArray = this.fileManager.getFileData();
        return byArray;
    }

    private void stopProgressBox() {
        this.progressBox.dispose();
    }
}

