/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIIcon;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpManager;
import emsl.awt.GUIProgressBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;

public class GUIProgressBox
extends GUIPanel {
    private GUIIcon textBox;
    private GUIProgressBar progressBar;
    private GUIPopUpManager popUpManager;
    private Container parent;

    public GUIProgressBox(Container container, int n) {
        super(new Dimension(400, 130), 1);
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.setLayout(new FlowLayout(1, 10, 15));
        this.parent = container;
        this.textBox = new GUIIcon(new Dimension(300, 30), "");
        this.textBox.setAlignment(n);
        this.add(this.textBox);
        this.progressBar = new GUIProgressBar();
        this.progressBar.setSize(new Dimension(300, 30));
        this.add(this.progressBar);
    }

    public GUIProgressBox(Container container) {
        this(container, 1);
    }

    public GUIProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setTotalIncrements(int n) {
        this.progressBar.setTotalIncrements(n);
    }

    public void setProgress(int n) {
        if (!this.progressBar.setProgress(n)) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paintAll(graphics);
        this.paintComponents(graphics);
    }

    public void setProgress() {
        if (!this.progressBar.setProgress()) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paintAll(graphics);
        this.paintComponents(graphics);
    }

    public void setProgress(String string) {
        this.textBox.setText(string);
        this.setProgress();
    }

    public void setProgress(int n, String string) {
        this.textBox.setText(string);
        this.setProgress(n);
    }

    public void display() {
        this.getPopUpManager();
        if (this.popUpManager == null) {
            return;
        }
        this.popUpManager.showPanel(this);
        this.setProgress(0, "Starting");
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paintAll(graphics);
        this.paintComponents(graphics);
        this.setCursor(new Cursor(3));
        this.parent.setCursor(new Cursor(3));
    }

    public void dispose() {
        this.setProgress(100, "Finished");
        this.getPopUpManager();
        if (this.popUpManager == null) {
            return;
        }
        this.popUpManager.hidePanel();
        this.parent.setCursor(new Cursor(0));
    }

    private void getPopUpManager() {
        Container container;
        if (this.popUpManager != null) {
            return;
        }
        Container container2 = container = this.parent;
        do {
            int n;
            if (container2 == null || (n = (container = container2).getComponentCount()) <= 0) continue;
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component instanceof GUIPopUpManager) {
                    this.popUpManager = (GUIPopUpManager)component;
                    return;
                }
                ++n2;
            }
        } while ((container2 = container.getParent()) != null);
        if (this.popUpManager == null) {
            System.out.println("Error using the ProgressBox facility of this program:");
            System.out.println("   A popUp manager could not be found");
            System.out.println("   Base level object = " + container);
        }
    }
}

