/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIButton;
import emsl.awt.GUIIconBox;
import emsl.awt.GUIPopUpManager;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class GUIPopUpButton
extends GUIButton
implements Runnable {
    private ActionListener actionListener;
    private GUIIconBox popUpBox;
    private GUIPopUpManager popUpManager;
    private Thread motor;
    private long stopClock;
    private GUIButton lastButtonSelected;
    private String runOwner;
    private int activationButton;
    private boolean isPoppedUp;

    public GUIPopUpButton(Dimension dimension, GUIIconBox gUIIconBox) {
        super(dimension);
        this.setName("popUpTrigger");
        this.setBehaviour(0);
        this.popUpBox = gUIIconBox;
    }

    public GUIPopUpButton(Dimension dimension) {
        this(dimension, (GUIIconBox)null);
    }

    public String getName() {
        if (this.popUpBox == null) {
            return "";
        }
        return this.popUpBox.getName();
    }

    public void setIconBox(GUIIconBox gUIIconBox) {
        this.popUpBox = gUIIconBox;
    }

    public GUIButton getSelectedButton() {
        return this.popUpBox.getSelectedButton();
    }

    public String getSelectedButtonName() {
        GUIButton gUIButton = this.getSelectedButton();
        String string = "";
        if (gUIButton != null) {
            string = gUIButton.getName();
        }
        return string;
    }

    public void select(GUIButton gUIButton, boolean bl) {
        if (gUIButton == null) {
            return;
        }
        this.popUpBox.deSelectAll(false);
        this.popUpBox.select(gUIButton, false);
        if (this.lastButtonSelected == gUIButton) {
            return;
        }
        this.lastButtonSelected = gUIButton;
        this.setBackground(gUIButton.getBackground());
        if (gUIButton.getImage() != null) {
            this.setImage(gUIButton.getImage());
        }
        if (this.getImage() == null) {
            this.setText(gUIButton.getText());
        }
        if (bl) {
            this.repaint();
        }
    }

    public void select(Color color, boolean bl) {
        this.popUpBox.select(color, false);
        GUIButton gUIButton = this.popUpBox.getSelectedButton();
        this.select(gUIButton, bl);
    }

    public void select(String string, boolean bl) {
        this.popUpBox.select(string, false);
        GUIButton gUIButton = this.popUpBox.getSelectedButton();
        this.select(gUIButton, bl);
    }

    private void getPopUpManager() {
        if (this.popUpManager != null) {
            return;
        }
        Container container = this;
        Container container2 = null;
        do {
            int n;
            if ((container2 = container.getParent()) == null || (n = (container = container2).getComponentCount()) <= 0) continue;
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component instanceof GUIPopUpManager) {
                    this.popUpManager = (GUIPopUpManager)component;
                    return;
                }
                ++n2;
            }
        } while (container2 != null);
        if (this.popUpManager == null) {
            System.out.println("Error using the PopUp menu facility of this program:");
            System.out.println("   A popUp manager could not be found");
            System.out.println("   Base level object = " + container);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        super.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
        super.removeActionListener(actionListener);
    }

    public void popUpManagerFinished() {
        GUIButton gUIButton = this.popUpBox.getSelectedButton();
        this.select(gUIButton, false);
        this.isPoppedUp = false;
        if (this.getBehaviour() != 0) {
            this.setState(1);
        }
        if (this.getBehaviour() == 0) {
            this.setState(0);
        }
        this.repaint();
        if (this.actionListener != null && gUIButton != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, this.getName()));
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.isPoppedUp) {
            if (this.popUpManager != null) {
                this.popUpManager.eventFired(mouseEvent);
            }
            return;
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isPoppedUp) {
            if (this.popUpManager != null) {
                this.popUpManager.eventFired(mouseEvent);
            }
            return;
        }
        super.processMouseEvent(mouseEvent);
        this.stopTimer();
        if (this.getPrivateState() == 1 && mouseEvent.getID() == 501) {
            this.startTimer();
        }
    }

    private void startTimer() {
        if (this.motor != null) {
            this.stopTimer();
        }
        this.stopClock = 0L;
        this.motor = new Thread(this);
        this.runOwner = "PopUp";
        this.motor.start();
    }

    private void stopTimer() {
        this.runOwner = null;
        if (this.stopClock == 100L) {
            this.getPopUpManager();
            this.popUpBox.layoutIcons();
            if (this.getBehaviour() != 0) {
                this.setState(1);
            }
            this.popUpBox.deSelectAll(false);
            if (this.popUpBox.getBackground() == null) {
                this.popUpBox.setBackground(this.getBackground());
            }
            if (this.popUpManager != null) {
                this.popUpManager.managePopUp(this, this.popUpBox);
            }
            this.isPoppedUp = true;
        }
        this.stopClock = 0L;
        if (this.motor != null) {
            this.motor.stop();
        }
        this.motor = null;
    }

    public void run() {
        if (this.runOwner == null) {
            super.run();
            return;
        }
        this.stopClock = 0L;
        try {
            int n = 500;
            if (this.getBehaviour() == 0) {
                n = 1;
            }
            Thread.sleep(n);
            this.stopClock = 100L;
        }
        catch (Exception exception) {
            System.out.println("Error " + exception);
        }
        this.stopTimer();
    }

    public void simulateButtonSelection(Point point) {
        GUIButton gUIButton = this.popUpBox.getTargetButton(point);
        if (gUIButton == null) {
            this.popUpBox.deSelectAll(true);
            return;
        }
        if (gUIButton.getState() == 0) {
            this.popUpBox.deSelectAll(true);
            gUIButton.setState(1);
            this.popUpBox.paintButton(gUIButton);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = this.getDrawableSize().width - 6;
        nArray2[0] = this.getDrawableSize().y;
        nArray[1] = nArray[0] + 6;
        nArray2[1] = nArray2[0] + 3;
        nArray[2] = nArray[0];
        nArray2[2] = nArray2[1] + 3;
        nArray[3] = nArray[0];
        nArray2[3] = nArray2[0];
        graphics.setColor(Color.yellow);
        graphics.fillPolygon(nArray, nArray2, 4);
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, 4);
    }
}

