/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIButton;
import emsl.awt.GUIIconBox;
import java.awt.Color;
import java.awt.Dimension;

public class GUIColorIconBox
extends GUIIconBox {
    private transient Dimension iconSize;
    private transient int columns;
    private transient boolean transparent;

    public GUIColorIconBox(boolean bl) {
        super(0, 0, "ColorIconBox");
        this.setBackground(Color.lightGray);
        this.columns = 18;
        this.setColumns(this.columns);
        this.iconSize = new Dimension(14, 14);
        this.transparent = bl;
        this.addGrays();
        this.addColors(1.0f, 0.5f);
        this.addColors(1.0f, 0.75f);
        this.addColors(1.0f, 1.0f);
        this.addColors(0.6f, 1.0f);
        this.addColors(0.4f, 1.0f);
        this.layoutIcons();
    }

    public GUIColorIconBox() {
        this(false);
    }

    public void addGrays() {
        int n = this.columns - 1;
        GUIButton gUIButton = null;
        if (this.transparent) {
            gUIButton = new GUIButton(this.iconSize, "Transparent");
            gUIButton.setBorderThickness(1);
            this.add(gUIButton);
            n = this.columns - 2;
        }
        int n2 = 0;
        while (n2 <= n) {
            float f = (float)n2 / (float)n;
            Color color = new Color(f, f, f);
            gUIButton = new GUIButton(this.iconSize, color);
            gUIButton.setBorderThickness(1);
            this.add(gUIButton);
            ++n2;
        }
    }

    public void addColors(float f, float f2) {
        int n = 0;
        while (n <= this.columns - 1) {
            float f3 = (float)n / (float)this.columns;
            int n2 = Color.HSBtoRGB(f3, f, f2);
            Color color = new Color(n2);
            GUIButton gUIButton = new GUIButton(this.iconSize, color);
            gUIButton.setBorderThickness(1);
            this.add(gUIButton);
            ++n;
        }
    }
}

