/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIButton;
import emsl.awt.GUIChoice;
import emsl.awt.GUIDialogueBox;
import emsl.awt.GUIFrame;
import emsl.awt.GUIIconBox;
import emsl.awt.GUIPanel;
import emsl.system.UndoGroup;
import emsl.text.TextPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;

public class SymbolCharacters
extends GUIDialogueBox {
    private GUIChoice choice;
    private GUIIconBox greekBox;
    private GUIIconBox dingbatsBox;
    private GUIIconBox symbolBox;
    private GUIButton undoButton;
    private GUIPanel centerPanel;
    private GUIFrame parent;

    public SymbolCharacters(GUIFrame gUIFrame) {
        super(gUIFrame, "Symbol Characters...", true);
        this.parent = gUIFrame;
        this.setModal(false);
        this.greekBox = this.createGreekBox();
        this.dingbatsBox = this.createDingbatsBox();
        this.symbolBox = this.createSymbolBox();
        this.greekBox.addActionListener(this);
        this.dingbatsBox.addActionListener(this);
        this.symbolBox.addActionListener(this);
        this.choice = new GUIChoice(new Dimension(100, 30), "Symbols..., Greek..., Dingbats...");
        this.choice.addActionListener(this);
        GUIPanel gUIPanel = this.getDisplayPanel();
        gUIPanel.setLayout(new BorderLayout(10, 10));
        gUIPanel.add("North", this.choice);
        this.centerPanel = new GUIPanel(new Dimension(400, 200), 2);
        gUIPanel.add("Center", this.centerPanel);
        this.setChoice("Symbols...");
        this.undoButton = this.addExitButton("Undo", false);
        this.setWindowCloseButton(this.addExitButton("Close", false));
    }

    public void setChoice(String string) {
        this.centerPanel.removeAll();
        GUIIconBox gUIIconBox = this.dingbatsBox;
        if (string.indexOf("Symbol") >= 0) {
            gUIIconBox = this.symbolBox;
        }
        if (string.indexOf("Greek") >= 0) {
            gUIIconBox = this.greekBox;
        }
        gUIIconBox.deSelectAll(true);
        this.centerPanel.add(gUIIconBox);
        gUIIconBox.layoutIcons();
        this.invalidate();
        this.validate();
    }

    public void setChar(GUIIconBox gUIIconBox) {
        if (gUIIconBox == null) {
            return;
        }
        String string = gUIIconBox.getSelectedButton().getText();
        try {
            TextPanel textPanel = (TextPanel)this.parent.getFocusTextPanel();
            UndoGroup undoGroup = textPanel.getTextUndo().getUndoGroup("Insert Symbol");
            int n = textPanel.getTextCursor().getCursorPosition() + 1;
            textPanel.insert(string, n, undoGroup);
            textPanel.getTextUndo().setUndoGroup(undoGroup);
            textPanel.layoutAfterChange(n);
        }
        catch (Exception exception) {}
        gUIIconBox.deSelectAll(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.choice) {
            this.setChoice(this.choice.getText());
        }
        if (object == this.dingbatsBox) {
            this.setChar((GUIIconBox)object);
        }
        if (object == this.symbolBox) {
            this.setChar((GUIIconBox)object);
        }
        if (object == this.greekBox) {
            this.setChar((GUIIconBox)object);
        }
        super.actionPerformed(actionEvent);
    }

    protected boolean exitButtonPressed(GUIButton gUIButton) {
        if (gUIButton == null) {
            return false;
        }
        if (gUIButton == this.undoButton) {
            this.parent.actionPerformed(new ActionEvent(this, 0, "Undo"));
            return false;
        }
        return super.exitButtonPressed(gUIButton);
    }

    private GUIIconBox createGreekBox() {
        GUIIconBox gUIIconBox = new GUIIconBox(15, 0, "MathIconBox");
        gUIIconBox.setBorder(0);
        this.addCharacters(gUIIconBox, 945, 25);
        this.addCharacters(gUIIconBox, 981, 2);
        this.addCharacters(gUIIconBox, 913, 25);
        this.addCharacters(gUIIconBox, 977, 2);
        this.addCharacters(gUIIconBox, 8704, 1);
        this.addCharacters(gUIIconBox, 8706, 2);
        this.addCharacters(gUIIconBox, 8709, 5);
        this.addCharacters(gUIIconBox, 8717, 1);
        this.addCharacters(gUIIconBox, 8719, 1);
        this.addCharacters(gUIIconBox, 8721, 1);
        this.addCharacters(gUIIconBox, 8727, 4);
        this.addCharacters(gUIIconBox, 8733, 2);
        this.addCharacters(gUIIconBox, 8743, 5);
        this.addCharacters(gUIIconBox, 8756, 1);
        this.addCharacters(gUIIconBox, 8764, 1);
        this.addCharacters(gUIIconBox, 8773, 1);
        this.addCharacters(gUIIconBox, 8776, 1);
        this.addCharacters(gUIIconBox, 8800, 2);
        this.addCharacters(gUIIconBox, 8804, 2);
        this.addCharacters(gUIIconBox, 8834, 3);
        this.addCharacters(gUIIconBox, 8838, 2);
        this.addCharacters(gUIIconBox, 8853, 1);
        this.addCharacters(gUIIconBox, 8855, 1);
        this.addCharacters(gUIIconBox, 8869, 1);
        return gUIIconBox;
    }

    private GUIIconBox createSymbolBox() {
        GUIIconBox gUIIconBox = new GUIIconBox(15, 0, "SymbolIconBox");
        gUIIconBox.setBorder(0);
        this.addCharacters(gUIIconBox, 161, 95);
        return gUIIconBox;
    }

    private GUIIconBox createDingbatsBox() {
        GUIIconBox gUIIconBox = new GUIIconBox(15, 0, "DingbatsIconBox");
        gUIIconBox.setBorder(0);
        this.addCharacters(gUIIconBox, 9985, 2);
        this.addCharacters(gUIIconBox, 9990, 4);
        this.addCharacters(gUIIconBox, 9996, 2);
        this.addCharacters(gUIIconBox, 10036, 3);
        this.addCharacters(gUIIconBox, 10132, 1);
        this.addCharacters(gUIIconBox, 10153, 1);
        this.addCharacters(gUIIconBox, 10102, 20);
        return gUIIconBox;
    }

    private void addCharacters(GUIIconBox gUIIconBox, int n, int n2) {
        Dimension dimension = new Dimension(25, 25);
        Font font = new Font("SansSerif", 0, 14);
        int n3 = 0;
        while (n3 < n2) {
            Character c = new Character((char)(n3 + n));
            GUIButton gUIButton = new GUIButton(dimension, c.toString());
            gUIIconBox.add(gUIButton);
            gUIButton.setFont(font);
            ++n3;
        }
    }
}

