/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIMenuBar;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionListener;

public class GUIMenus
extends GUIMenuBar {
    public GUIMenus(ActionListener actionListener) {
        super(actionListener);
        this.createFileMenu();
        this.createEditMenu();
        this.createPageMenu();
        this.createViewMenu();
        this.createBeansMenu();
        this.createSpecialMenu();
        this.createHelpMenu();
        this.setUndoMenu(false, null);
        this.setRedoMenu(false, null);
        this.setSelectionMenus(false);
        this.setFocusMenus(false);
    }

    private void createFileMenu() {
        Menu menu = this.addMenu("File");
        this.addMenuItem(menu, "New Window...", 0);
        this.addSeparator(menu);
        this.addMenuItem(menu, "New Document", 0);
        this.addMenuItem(menu, "Open Document...", 0);
        this.addMenuItem(menu, "Open Text...", 0);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Save Document", 83);
        this.addMenuItem(menu, "Save Document As...", 0);
        this.addMenuItem(menu, "Save Text As...", 0);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Document Size...", 0);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Print...", 80);
        this.addMenuItem(menu, "Print Page...", 0);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Quit", 81);
    }

    private void createEditMenu() {
        Menu menu = this.addMenu("Edit");
        this.addMenuItem(menu, "Undo", 90);
        this.addMenuItem(menu, "Redo", 89);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Cut", 88);
        this.addMenuItem(menu, "Copy", 67);
        this.addMenuItem(menu, "Paste", 86);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Delete", 0);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Select All", 65);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Find...", 70);
        this.addMenuItem(menu, "Replace...", 82);
    }

    private void createPageMenu() {
        Menu menu = this.addMenu("Page");
        this.addMenuItem(menu, "New Page", 78);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Page Up", 33);
        this.addMenuItem(menu, "Page Down", 34);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Add Pages...", 0);
        this.addMenuItem(menu, "Remove Pages...", 0);
        this.addSeparator(menu);
        this.addCheckMenuItem(menu, "Text Mode");
        this.addCheckMenuItem(menu, "Layout Mode", true);
    }

    private void createViewMenu() {
        Menu menu = this.addMenu("View");
        this.addCheckMenuItem(menu, "200 %");
        this.addCheckMenuItem(menu, "175 %");
        this.addCheckMenuItem(menu, "150 %");
        this.addCheckMenuItem(menu, "125 %");
        this.addCheckMenuItem(menu, "100 %");
        this.addCheckMenuItem(menu, "75 %");
        this.addCheckMenuItem(menu, "50 %");
        this.addCheckMenuItem(menu, "25 %");
        this.addCheckMenuItem(menu, "Fit to Window");
        this.addSeparator(menu);
        this.addCheckMenuItem(menu, "Text Border", true);
        this.addCheckMenuItem(menu, "Page Border", true);
        this.addSeparator(menu);
        this.addSubMenu(menu, this.createViewComponentsSubMenu());
    }

    private Menu createViewComponentsSubMenu() {
        Menu menu = this.addMenu("Components");
        this.addMenuItem(menu, "Hide All", 0);
        this.addMenuItem(menu, "Show All", 0);
        this.addSeparator(menu);
        this.addCheckMenuItem(menu, "Command Bar", true);
        this.addCheckMenuItem(menu, "Text Style Bar", true);
        this.addCheckMenuItem(menu, "Page Bar", true);
        this.addSeparator(menu);
        this.addCheckMenuItem(menu, "Horizontal Ruler", false);
        this.addCheckMenuItem(menu, "Vertical Ruler", false);
        return menu;
    }

    private void createBeansMenu() {
        Menu menu = this.addMenu("Beans");
        this.addSeparator(menu);
        this.addMenuItem(menu, "Load Beans...", 0);
    }

    private void createSpecialMenu() {
        Menu menu = this.addMenu("Special");
        this.addMenuItem(menu, "Insert Page Break", 0);
        this.addMenuItem(menu, "Insert Symbol Characters...", 0);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Set Background Color...", 0);
        this.addSeparator(menu);
        this.addMenuItem(menu, "Chemical Equations...", 0);
    }

    private void createHelpMenu() {
        Menu menu = this.addHelpMenu();
        this.addMenuItem(menu, "About...", 0);
        this.addMenuItem(menu, "Feedback...", 0);
    }

    public void setUndoMenu(boolean bl, String string) {
        Menu menu = this.getMenu("Edit");
        MenuItem menuItem = menu.getItem(0);
        if (!menuItem.getLabel().equals(string)) {
            menu.remove(0);
            if (string == null) {
                string = "Undo Not Available";
            }
            menuItem = this.addMenuItem(null, string, 90);
            menu.insert(menuItem, 0);
        }
        menuItem.setEnabled(bl);
    }

    public void setRedoMenu(boolean bl, String string) {
        Menu menu = this.getMenu("Edit");
        MenuItem menuItem = menu.getItem(1);
        if (!menuItem.getLabel().equals(string)) {
            menu.remove(1);
            if (string == null) {
                string = "Redo Not Available";
            }
            menuItem = this.addMenuItem(null, string, 89);
            menu.insert(menuItem, 1);
        }
        menuItem.setEnabled(bl);
    }

    public void setSelectionMenus(boolean bl) {
        this.setEnabled("Edit", "Copy", bl);
        this.setEnabled("Edit", "Cut", bl);
        this.setEnabled("Edit", "Delete", bl);
    }

    public void setFocusMenus(boolean bl) {
        this.setEnabled("Edit", "Select All", bl);
        this.setEnabled("Edit", "Paste", bl);
        this.setEnabled("Edit", "Find...", bl);
        this.setEnabled("Edit", "Replace...", bl);
    }
}

