/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MVMolecule
implements Serializable {
    private String moleculeName;
    private Vector atomList;
    private Vector bondList;
    private double[] rotation;
    private boolean recalculate;
    private boolean movedToOrigin;
    private Point mouseDownPoint;
    private double scaleFactor;
    private Dimension size;
    private double[] zBounds;
    private boolean drawAtomLabels;
    private boolean drawAtomShade;
    private boolean drawWireframe;
    private boolean drawColor;

    public MVMolecule(String string) {
        this.moleculeName = string;
        this.atomList = new Vector();
        this.bondList = new Vector();
        this.rotation = new double[3];
        this.rotation[2] = 0.0;
        this.rotation[1] = 0.0;
        this.rotation[0] = 0.0;
        this.recalculate = true;
        this.movedToOrigin = false;
        this.size = new Dimension(0, 0);
        this.drawAtomShade = true;
        this.drawAtomLabels = true;
        this.drawWireframe = false;
        this.drawColor = false;
    }

    public MVMolecule(MVMolecule mVMolecule, String string) {
        this(string);
        if (mVMolecule == null) {
            return;
        }
        this.setDisplayMode("Shade", mVMolecule.getDisplayMode("Shade"));
        this.setDisplayMode("Color", mVMolecule.getDisplayMode("Color"));
        this.setDisplayMode("Wireframe", mVMolecule.getDisplayMode("Wireframe"));
        this.setDisplayMode("Label", mVMolecule.getDisplayMode("Label"));
    }

    public synchronized void setMoleculeName(String string) {
        this.moleculeName = string;
    }

    public String getMoleculeName() {
        return this.moleculeName;
    }

    public synchronized void setDimension(Dimension dimension) {
        if (dimension.width != this.size.width || dimension.height != this.size.height) {
            this.size = new Dimension(dimension.width, dimension.height);
            this.getScaleFactor();
        }
    }

    public synchronized void setDisplayMode(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (string.indexOf("Shade") >= 0) {
            this.drawAtomShade = bl;
        }
        if (string.indexOf("Label") >= 0) {
            this.drawAtomLabels = bl;
        }
        if (string.indexOf("Wireframe") >= 0) {
            this.drawWireframe = bl;
        }
        if (string.indexOf("Color") >= 0) {
            this.drawColor = bl;
        }
    }

    public boolean getDisplayMode(String string) {
        if (string.indexOf("Shade") >= 0) {
            return this.drawAtomShade;
        }
        if (string.indexOf("Label") >= 0) {
            return this.drawAtomLabels;
        }
        if (string.indexOf("Wireframe") >= 0) {
            return this.drawWireframe;
        }
        if (string.indexOf("Color") >= 0) {
            return this.drawColor;
        }
        return false;
    }

    public synchronized void addAtom(int n, double d, double d2, double d3) {
        MVAtom mVAtom = new MVAtom(n, d, d2, d3);
        this.atomList.addElement(mVAtom);
    }

    public synchronized void addAtom(String string, double d, double d2, double d3) {
        MVAtom mVAtom = new MVAtom(string, d, d2, d3);
        this.atomList.addElement(mVAtom);
    }

    public synchronized void autoBond() {
        int n = this.atomList.size();
        int n2 = 0;
        while (n2 < n - 1) {
            MVAtom mVAtom = (MVAtom)this.atomList.elementAt(n2);
            double[] dArray = mVAtom.getXYZ();
            double d = mVAtom.getRadius();
            int n3 = n2 + 1;
            while (n3 < n) {
                MVAtom mVAtom2 = (MVAtom)this.atomList.elementAt(n3);
                double[] dArray2 = mVAtom2.getXYZ();
                double d2 = mVAtom2.getRadius();
                double d3 = dArray2[0] - dArray[0];
                double d4 = dArray2[1] - dArray[1];
                double d5 = dArray2[2] - dArray[2];
                double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                if (d6 < (d + d2) * 1.2) {
                    this.addBond(n2, n3, 1);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public synchronized void addBond(int n, int n2, int n3) {
        try {
            MVAtom mVAtom = (MVAtom)this.atomList.elementAt(n);
            MVAtom mVAtom2 = (MVAtom)this.atomList.elementAt(n2);
            MVBond mVBond = new MVBond(mVAtom, mVAtom2, n3);
            this.bondList.addElement(mVBond);
            return;
        }
        catch (Exception exception) {
            System.out.println("Error adding bond");
            return;
        }
    }

    public void print(String string) {
    }

    public synchronized void paint(Graphics graphics, Color color, Color color2) {
        graphics.setColor(color2);
        graphics.fillRect(0, 0, this.size.width, this.size.height);
        if (!this.movedToOrigin) {
            this.moveMoleculeToOrigin();
        }
        if (this.recalculate) {
            this.recalculate();
        }
        Enumeration enumeration = this.atomList.elements();
        while (enumeration.hasMoreElements()) {
            MVAtom mVAtom = (MVAtom)enumeration.nextElement();
            mVAtom.paint(graphics, color, color2, this.drawColor, this.drawWireframe, this.drawAtomLabels, this.drawAtomShade);
            Enumeration enumeration2 = this.bondList.elements();
            while (enumeration2.hasMoreElements()) {
                MVBond mVBond = (MVBond)enumeration2.nextElement();
                boolean bl = mVBond.isDrawableBond(mVAtom, this.atomList);
                if (!bl) continue;
                mVBond.paint(graphics, color, color2, this.drawColor, this.drawWireframe);
            }
        }
    }

    public synchronized void setRotation(double d, double d2) {
        this.rotation[0] = d;
        this.rotation[1] = d2;
        this.recalculate = true;
    }

    public synchronized boolean mouseDown(int n, int n2) {
        this.mouseDownPoint = new Point(n, n2);
        return true;
    }

    public synchronized boolean mouseUp(int n, int n2) {
        return true;
    }

    public synchronized boolean mouseDrag(int n, int n2) {
        this.rotation[0] = (this.mouseDownPoint.y - n2) * 360 / this.size.width;
        this.rotation[1] = (n - this.mouseDownPoint.x) * 360 / this.size.height;
        this.mouseDownPoint = new Point(n, n2);
        this.recalculate = true;
        return true;
    }

    public synchronized void moveMoleculeToOrigin() {
        this.movedToOrigin = true;
        double[] dArray = this.getMoleculeBounds();
        double[] dArray2 = new double[]{-(dArray[3] + dArray[0]) / 2.0, -(dArray[4] + dArray[1]) / 2.0, -(dArray[5] + dArray[2]) / 2.0};
        MVMatrix mVMatrix = new MVMatrix();
        mVMatrix.shiftMatrix(dArray2);
        Enumeration enumeration = this.atomList.elements();
        while (enumeration.hasMoreElements()) {
            MVAtom mVAtom = (MVAtom)enumeration.nextElement();
            double[] dArray3 = mVAtom.getXYZ();
            dArray3 = mVMatrix.transformPoint(dArray3);
            mVAtom.setXYZ(dArray3);
        }
        this.getScaleFactor();
        this.recalculate = true;
    }

    public synchronized void getScaleFactor() {
        double[] dArray = this.getMoleculeBounds();
        double d = (double)this.size.width / (dArray[3] - dArray[0]);
        double d2 = (double)this.size.height / (dArray[4] - dArray[1]);
        double d3 = (double)this.size.height / (dArray[5] - dArray[2]);
        this.scaleFactor = Math.min(d, d2);
        this.scaleFactor = Math.min(this.scaleFactor, d3) * 0.7;
        this.recalculate = true;
        this.zBounds = new double[2];
        this.zBounds[0] = Math.min(dArray[0], dArray[1]);
        this.zBounds[0] = Math.min(this.zBounds[0], dArray[2]);
        this.zBounds[1] = Math.max(dArray[3], dArray[4]);
        this.zBounds[1] = Math.max(this.zBounds[1], dArray[5]);
    }

    public synchronized void recalculate() {
        this.recalculate = false;
        this.rotateAtoms();
        this.print("After rotation");
        this.scaleAtoms();
        this.print("After Scale");
        double[] dArray = new double[]{(double)this.size.width / 2.0, (double)this.size.height / 2.0, 0.0};
        MVMatrix mVMatrix = new MVMatrix();
        mVMatrix.shiftMatrix(dArray);
        this.transformMolecule(mVMatrix);
        this.print("After Shift to Applet Center");
        this.sortAtoms();
    }

    public synchronized double[] getMoleculeBounds() {
        double[] dArray = new double[6];
        int n = 0;
        while (n <= 2) {
            dArray[n] = 9999.0;
            dArray[n + 3] = -9999.0;
            ++n;
        }
        Enumeration enumeration = this.atomList.elements();
        while (enumeration.hasMoreElements()) {
            MVAtom mVAtom = (MVAtom)enumeration.nextElement();
            double[] dArray2 = mVAtom.getXYZ();
            int n2 = 0;
            while (n2 <= 2) {
                dArray[n2] = Math.min(dArray[n2], dArray2[n2]);
                dArray[n2 + 3] = Math.max(dArray[n2 + 3], dArray2[n2]);
                ++n2;
            }
        }
        return dArray;
    }

    public synchronized void rotateAtoms() {
        MVMatrix mVMatrix = new MVMatrix();
        mVMatrix.rotateMatrix(this.rotation[0], "X");
        MVMatrix mVMatrix2 = new MVMatrix();
        mVMatrix2.rotateMatrix(this.rotation[1], "Y");
        Enumeration enumeration = this.atomList.elements();
        while (enumeration.hasMoreElements()) {
            MVAtom mVAtom = (MVAtom)enumeration.nextElement();
            double[] dArray = mVAtom.getXYZ();
            dArray = mVMatrix.transformPoint(dArray);
            dArray = mVMatrix2.transformPoint(dArray);
            mVAtom.setXYZ(dArray);
            mVAtom.setScreenXYZ(dArray);
        }
    }

    public synchronized void scaleAtoms() {
        double[] dArray = new double[3];
        dArray[1] = dArray[2] = this.scaleFactor;
        dArray[0] = dArray[2];
        MVMatrix mVMatrix = new MVMatrix();
        mVMatrix.scaleMatrix(dArray);
        this.transformMolecule(mVMatrix);
        Enumeration enumeration = this.atomList.elements();
        while (enumeration.hasMoreElements()) {
            MVAtom mVAtom = (MVAtom)enumeration.nextElement();
            double d = mVAtom.getZ();
            double d2 = mVAtom.getRadius() * 0.4;
            d2 *= this.scaleFactor;
            double d3 = (d - this.zBounds[0]) / (this.zBounds[1] - this.zBounds[0]);
            double d4 = d3 + 0.5;
            if (d4 < 0.5) {
                d4 = 0.5;
            }
            if (d4 > 1.5) {
                d4 = 1.5;
            }
            mVAtom.setScreenRadius(d2 * d4);
        }
    }

    public synchronized void transformMolecule(MVMatrix mVMatrix) {
        Enumeration enumeration = this.atomList.elements();
        while (enumeration.hasMoreElements()) {
            MVAtom mVAtom = (MVAtom)enumeration.nextElement();
            double[] dArray = mVAtom.getScreenXYZ();
            dArray = mVMatrix.transformPoint(dArray);
            mVAtom.setScreenXYZ(dArray);
        }
    }

    public synchronized void sortAtoms() {
        boolean bl;
        do {
            bl = true;
            int n = 0;
            while (n < this.atomList.size() - 1) {
                try {
                    MVAtom mVAtom = (MVAtom)this.atomList.elementAt(n);
                    MVAtom mVAtom2 = (MVAtom)this.atomList.elementAt(n + 1);
                    double d = mVAtom.getZ();
                    double d2 = mVAtom2.getZ();
                    if (d > d2) {
                        bl = false;
                        this.atomList.setElementAt(mVAtom, n + 1);
                        this.atomList.setElementAt(mVAtom2, n);
                    }
                    if (d == d2) {
                        mVAtom2.setZ(d2 + 1.0E-6);
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
        } while (!bl);
    }
}

