<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="common4css.xsl"/>
	<xsl:output method="text" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
/* ********************************** */
/*                                    */
/*     GENERATED GY XISS WEB          */
/*  LAST UPDATE IN VERSION 1.6.7      */	
/*                                    */
/* CSS COMPONENTS FILE FOR <xsl:value-of select="skin/@name"/> SKIN  */
/* ********************************** */

	<xsl:apply-templates select="skin/component"/>
   </xsl:template>

   <xsl:template match="component">
li a {
	margin: 0;
 	display: block;
 	text-decoration: none;
 	border: 0;
}
 
ul {
   margin: 0;
   padding: 0;
   list-style-type: none;
}

/***************************
 *
 * HOME LINK
 *
 ***************************/
a.home {
}

a.home span {
	display: inline;
}

/****************************
*
* COPYRIGHT
*
****************************/
.copyright {
   <xsl:apply-templates select="copyright/font"/>
}



/***************************
 *
 * MAIN IMAGE CONTAINER
 *
 ***************************/
div#image-container {
	margin: <xsl:choose><xsl:when test="image-area/@margin"><xsl:value-of select="image-area/@margin"/></xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose>px;
	margin-left: auto;
	margin-right: auto;
	padding: 0px;
	text-align: center;
	border: <xsl:apply-templates select="image-area/border"/> <xsl:apply-templates select="image-area/color"/>;
  <xsl:if test="image-area/background">
  background: <xsl:apply-templates select="image-area/background"/>;
  </xsl:if>
}

/**** COMMENT STYLE ****/
div#image-comment {
	margin: 0 5px;
	<xsl:apply-templates select="image-area/font"/>
	color: <xsl:apply-templates select="image-area/color"/>;
}

div#image-comment.top-comment {
}

div#image-comment.bottom-comment {
}

div#image-comment div {
}

.image-num {
	margin-right: 2em;
}

/** METADATA STYMLE **/
div#metaData {
	<xsl:apply-templates select="image-area/meta-data"/>
	color : <xsl:apply-templates select="/skin/colors/foreground"/>;
}
div#metaData.top-metadata {
}
div#metaData.bottom-metadata {
}
div#metaData div {
}

/***************************
* LOCAL INDEX
*
***************************/
div#defualt-index p {
   border: 1px solid <xsl:apply-templates select="image-area/local-index/border-color"/>;
   background: <xsl:apply-templates select="image-area/local-index/background"/>;
}

div#defualt-index p {
	margin-top: 50px;
}

div#standard-index {
   border: 1px solid <xsl:apply-templates select="image-area/local-index/border-color"/>;
   background: <xsl:apply-templates select="image-area/local-index/background"/>;
}
div#standard-index p {
   padding: 15px 0;
}

div#map-index {
	border: 1px solid <xsl:apply-templates select="image-area/local-index/border-color"/>;
}
div#map {
}
div.marker-info {
	<xsl:apply-templates select="image-area/font"/>
	color: <xsl:apply-templates select="image-area/color"/>;
}
div#map p {
   margin: 5px;
   padding: 0;
}

<xsl:apply-templates select="image-area/animation"/>

/***************************
 *
 * ANIMATION CONTROL PANEL
 *
 ***************************/
#ctrl-wrapper {
	font-size: 70%;
	text-align: left;
}
#ctrl-wrapper a {
	border: 0;
}
#ctrl-wrapper span {
	display: inline;
}
#ctrl-panel {
	padding: 2px 2px;
	opacity: 0.9;
	background: <xsl:apply-templates select="image-area/local-index/background"/>;
}
#comment-disp li {
	padding-left: 10px;
}
#comment-disp li.title {
	padding: 0;
}
#mdata-disp li {
	padding-left: 10px;
}
#mdata-disp li.title {
	padding: 0;
}
li.title {
	font-weight: bold;
}
li#decrease {
	padding-left: 20px;
}
li#anim-speed-value {
	padding-left: 10px;
	color: rgb(90,90,90);
}
li#increase {
	padding-left: 20px;
}

/***************************
 *
 * THUMBNAILS CONTAINER
 *
 ***************************/

.section {
    padding-left: 1em;
    padding-right: 1em;
    padding-top: 1em;
    font-size: 80%;
    font-weight: bold;
    text-align: center;
 }

.thumbnailsRow {
   padding: 2px;
}

.currentThumbnail {
	padding: 0;
	border: <xsl:apply-templates select="thumbnail/current"/> <xsl:apply-templates select="../colors/link-hover"/>;
}

a.thumbnailLink {
	border: 0;
	margin: 0;
	padding: 0;
	text-decoration: none;
}

/**      FOR IE !    **/
a.thumbnailLink:hover {
	border: 0;
	margin: 0;
	padding: 0;
	text-decoration: none;
}
/**      FOR IE !    **/
a.thumbnailLink:visited {
	border: 0;
	margin: 0;
	padding: 0;
	text-decoration: none;
}

a.thumbnailLink img {
	padding: 0px;
	border: <xsl:apply-templates select="thumbnail/link/normal"/> <xsl:apply-templates select="../colors/link-background"/>;
	text-decoration: none;
}

a.thumbnailLink:hover img {
	padding: 0px;
	border: <xsl:apply-templates select="thumbnail/link/hover"/> <xsl:apply-templates select="../colors/link-hover"/>;
	text-decoration: none;
}


/***************************
 *
 * NAVIGATION BAR
 *
 ***************************/
 
a.backward {
 	margin: 0;
	padding: 0;
 	width: 52px;
 	height: 20px;
 	border: 0;
 }
 
a.backward:hover {
   font-weight: bold;
   color: <xsl:apply-templates select="../colors/link-hover"/>;
}

a.forward {
	margin: 0;
	padding: 0;
 	width: 52px;
 	height: 20px;
  	border: 0;
}
 
a.forward:hover {
   font-weight: bold;
   color: <xsl:apply-templates select="../colors/link-hover"/>;
}

a.init {
	margin: 0;
	padding: 0;
  	width: 40px;
 	height: 20px;
 	border: 0;
}

a.init:hover {
   font-weight: bold;
   color: <xsl:apply-templates select="../colors/link-hover"/>;
}

/********* Horizontal bar ****/

div.h-navbar-div {
	text-align: center;
	margin: 0;
	padding: 0;
	width: 144px;
	margin-left: auto;
	margin-right: auto;	
}

ul.h-nav-bar li {
   list-style-type: none;
   height: 20px;
   float: left;
}

li.h-backward-disabled {
	color: <xsl:apply-templates select="../colors/disabled-foreground"/>;
	font-weight: bold;
	width: 52px;
	height: 20px;
	float: left;
}

li.h-forward-disabled {
	color: <xsl:apply-templates select="../colors/disabled-foreground"/>;
	font-weight: bold;
	width: 52px;
	height: 20px;
	float: left;
}

div.h-next {
   float: right;
}
div.h-previous {
   float: left;
}

/****** Vertical bar ***/

div.v-navbar-div {
	margin: 0;
	padding: 0;
	width: 52px;
}

ul.v-nav-bar li {
   list-style-type: none;
   width: 52px;
   height: 20px;
   margin-top: 2px;
}

li.v-backward-disabled {
	color: <xsl:apply-templates select="../colors/disabled-foreground"/>;
	font-weight: bold;
  	width: 52px;
 	height: 20px;
}

li.v-forward-disabled {
	color: <xsl:apply-templates select="../colors/disabled-foreground"/>;
	font-weight: bold;
  	width: 52px;
 	height: 20px;
}
 
li.init {
 	margin-left: 6px;
 	margin-right: 6px;
}
   </xsl:template>

<xsl:template match="animation">
/**** ANIMATION LOAD SCREEN STYLE ***/
#load {
	margin: <xsl:choose><xsl:when test="../@margin"><xsl:value-of select="../@margin"/></xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose>px;
	background: <xsl:value-of select="@background"/> url(<xsl:value-of select="@icon-style"/>-<xsl:value-of select="@background"/>.gif) no-repeat center center;
	opacity: <xsl:value-of select="@opacity"/>;
	<xsl:if test="../border">
	border: <xsl:apply-templates select="../border"/> <xsl:value-of select="@background"/>;
	</xsl:if>
}
</xsl:template>
   
</xsl:stylesheet>
