﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 Creation date: 2010-06-22
	 Author: Gleam
	-->
	<xsl:import href="mainImageRenderer.xsl"/>
	<xsl:import href="thumbnailRenderer.xsl"/>
	<xsl:import href="navigationBarRenderer.xsl"/>
	<xsl:import href="properties.xsl"/>
	
	<xsl:output method="xml" version="1.0" indent="yes"/>
	
	<xsl:param name="currentImage"/>
	<xsl:param name="lang"/>
	<xsl:param name="localIndex"/>
	<xsl:param name="web"/>
	<xsl:param name="layout"/>
	
	<xsl:param name="contentFile"/><!-- only here for because it is needed by imported xsl -->
	
	<xsl:variable name="layoutDoc" select="document($layout)"/>
	<!--
	 -->
	<xsl:template match="/slideshow-content">
		<images lang="{$lang}" animation="{$layoutDoc/slideshow-layout/animation/@kind}" transition="{$layoutDoc/slideshow-layout/animation/@transition}" wait-screen-size="{$layoutDoc/slideshow-layout/animation/@wait-screen-size}" control-panel="{$layoutDoc/slideshow-layout/animation/@control-panel}">
			<xsl:attribute name="comment-pos"><xsl:value-of select="$layoutDoc//image-area/comment/@position"/></xsl:attribute>
			<xsl:attribute name="metadata-pos"><xsl:value-of select="$layoutDoc//image-area/meta-data/@position"/></xsl:attribute>
			<xsl:attribute name="navigation"><xsl:apply-templates select="$layoutDoc//navigation-bar[1]" mode="TYPE"/></xsl:attribute>
			<xsl:if test="next-show">
				<xsl:attribute name="next-link">
					<xsl:apply-templates select="next-show" mode="ANIMATION"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="previous-show">
				<xsl:attribute name="previous-link">
					<xsl:apply-templates select="previous-show" mode="ANIMATION"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="$layoutDoc//image-location-on-map">
				<xsl:copy-of select="$layoutDoc//image-location-on-map"/>
			</xsl:if>
			<navigation-links>
				<xsl:attribute name="backward">
					<xsl:call-template name="properties">
						<xsl:with-param name="lang" select="$lang"/>
						<xsl:with-param name="key">link.backward.title</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="forward">
					<xsl:call-template name="properties">
						<xsl:with-param name="lang" select="$lang"/>
						<xsl:with-param name="key">link.forward.title</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="next">
					<xsl:call-template name="properties">
						<xsl:with-param name="lang" select="$lang"/>
						<xsl:with-param name="key">link.next.title</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="previous">
					<xsl:call-template name="properties">
						<xsl:with-param name="lang" select="$lang"/>
						<xsl:with-param name="key">link.previous.title</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="start">
					<xsl:call-template name="properties">
						<xsl:with-param name="lang" select="$lang"/>
						<xsl:with-param name="key">link.forward.start</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</navigation-links>
			<xsl:apply-templates select="//image" mode="ANIMATION"/>
		</images>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="next-show | previous-show" mode="ANIMATION">
		<xsl:call-template name="link">
			<xsl:with-param name="ref" select="@href"/>
			<xsl:with-param name="animation" select="'true'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="image" mode="ANIMATION">
		<!--xsl:message>image <xsl:value-of select="@number"/> <xsl:value-of select="$layout"/></xsl:message-->
		<image>
			<xsl:attribute name="number"><xsl:value-of select="@number"/></xsl:attribute>
			<xsl:attribute name="src"><xsl:value-of select="concat(../../@images, '/', @filename, '.', main-image/@extention)"/></xsl:attribute>
			<xsl:attribute name="top">
				<xsl:apply-templates select="." mode="TOP">
					<xsl:with-param name="mainImageSize" select="$layoutDoc//image-area/@height"/>
				</xsl:apply-templates>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="meta-data/@latitude">
					<xsl:attribute name="has-location">yes</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="has-location">no</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<comment>
				<xsl:apply-templates select="." mode="COMMENT">
					<xsl:with-param name="nb-images" select="count(//image)"/>
					<xsl:with-param name="number-format" select="$layoutDoc//image-area/comment/@number-format"/>
				</xsl:apply-templates>
			</comment>
			<metadata>
				<xsl:apply-templates select="." mode="META_DATA">
					<xsl:with-param name="imageAreaNode" select="$layoutDoc//image-area"/>
				</xsl:apply-templates>
			</metadata>
			<thumbnail title="{concat(@number,'. ',@comment)}">
				<xsl:apply-templates select="." mode="THUMBNAIL_IMG">
					<xsl:with-param name="current" select="'true'"/>
				</xsl:apply-templates>
			</thumbnail>
	   </image>
	</xsl:template>
	<!--
	 -->
</xsl:stylesheet>
