/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.worker;

import javax.swing.SwingUtilities;
import org.xissweb.gui.worker.ProcessLauncher;

public abstract class SwingWorker {
    protected ProcessLauncher launcher;
    protected boolean stop;
    protected boolean inPause;
    protected boolean inProgress;
    protected long time;
    protected long timeInPause;
    protected long totalInPause;
    protected ThreadVar threadVar;

    public SwingWorker() {
        Thread t = new Thread(this.createDoConstruct());
        this.threadVar = new ThreadVar(t);
    }

    public void setLauncher(ProcessLauncher launcher) {
        this.launcher = launcher;
    }

    public ProcessLauncher getLauncher() {
        return this.launcher;
    }

    public synchronized boolean isInPause() {
        return this.inPause;
    }

    public abstract boolean construct();

    public void finished() {
        if (this.launcher != null) {
            this.launcher.processFinished(this, this.getTime(), !this.stop);
        }
    }

    public void interrupt(boolean end) {
        Thread t = this.threadVar.get();
        if (t != null) {
            if (end) {
                this.stop = end;
            } else {
                boolean bl = this.inPause = !this.inPause;
                if (this.inPause) {
                    this.timeInPause = System.currentTimeMillis();
                } else {
                    this.totalInPause += System.currentTimeMillis() - this.timeInPause;
                }
            }
        }
        if (this.stop) {
            this.threadVar.clear();
        }
    }

    public long getTime() {
        return this.time;
    }

    protected Runnable createDoConstruct() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SwingWorker.this.inProgress = true;
                try {
                    while (SwingWorker.this.inProgress && !SwingWorker.this.stop) {
                        if (SwingWorker.this.inPause) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        SwingWorker.this.inProgress = SwingWorker.this.construct();
                    }
                    SwingWorker.this.time = System.currentTimeMillis() - SwingWorker.this.time - SwingWorker.this.totalInPause;
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        return doConstruct;
    }

    protected void initialize() {
        this.time = System.currentTimeMillis();
        this.totalInPause = 0L;
        this.inProgress = true;
        this.inPause = false;
        this.stop = false;
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            this.initialize();
            t.start();
        }
    }

    protected static class ThreadVar {
        private Thread thread;

        public ThreadVar(Thread t) {
            this.thread = t;
        }

        public synchronized Thread get() {
            return this.thread;
        }

        public synchronized void clear() {
            this.thread = null;
        }
    }
}

