/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.util.tree;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.xissweb.file.FileHelper;

public abstract class TreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1735685144140639762L;
    private static final Comparator fileNodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String e2;
            File f1 = (File)((DefaultMutableTreeNode)o1).getUserObject();
            File f2 = (File)((DefaultMutableTreeNode)o2).getUserObject();
            String e1 = FileHelper.fileNameExtention(f1);
            return e1.equals(e2 = FileHelper.fileNameExtention(f2)) ? f1.compareTo(f2) : e1.compareTo(e2);
        }
    };

    public TreeModel(DefaultMutableTreeNode root) {
        super(root);
    }

    public DefaultMutableTreeNode getNodeFromUserObject(Object object) {
        DefaultMutableTreeNode noeudRes = null;
        Enumeration<TreeNode> noeuds = ((DefaultMutableTreeNode)this.getRoot()).depthFirstEnumeration();
        while (noeuds.hasMoreElements() && noeudRes == null) {
            DefaultMutableTreeNode noeudCourant = (DefaultMutableTreeNode)noeuds.nextElement();
            if (!noeudCourant.getUserObject().equals(object)) continue;
            noeudRes = noeudCourant;
        }
        return noeudRes;
    }

    public DefaultMutableTreeNode getChildNodeFromUserObject(DefaultMutableTreeNode node, Object object) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!n.getUserObject().equals(object)) continue;
            return n;
        }
        return null;
    }

    public DefaultMutableTreeNode addNodeForUserObject(DefaultMutableTreeNode father, Object obj) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
        this.addNodeToParent(father, node);
        return node;
    }

    public void addNodeForUserObject(DefaultMutableTreeNode father, Object[] objs) {
        int i;
        int childCount = father.getChildCount();
        DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[childCount + objs.length];
        for (i = 0; i < objs.length; ++i) {
            nodes[i + childCount] = new DefaultMutableTreeNode(objs[i]);
        }
        for (i = father.getChildCount() - 1; i >= 0; --i) {
            nodes[i] = (DefaultMutableTreeNode)father.getChildAt(i);
            father.remove(i);
        }
        Arrays.sort(nodes, fileNodeComparator);
        for (i = 0; i < nodes.length; ++i) {
            father.add(nodes[i]);
        }
    }

    public DefaultMutableTreeNode addNodeForUserObject(Object parent, Object obj) {
        DefaultMutableTreeNode node = this.getNodeFromUserObject(obj);
        if (node == null) {
            node = new DefaultMutableTreeNode(obj);
            this.addNodeToParent(this.getNodeFromUserObject(parent), node);
        }
        return node;
    }

    private void addNodeToParent(DefaultMutableTreeNode father, DefaultMutableTreeNode node) {
        int i;
        int n = father.getChildCount();
        DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[n + 1];
        for (i = 0; i < n; ++i) {
            nodes[i] = (DefaultMutableTreeNode)father.getChildAt(i);
        }
        for (i = 0; i < n; ++i) {
            father.remove(nodes[i]);
        }
        nodes[n] = node;
        Arrays.sort(nodes, fileNodeComparator);
        for (i = 0; i < n + 1; ++i) {
            father.add(nodes[i]);
        }
    }

    public void removeNode(MutableTreeNode child) {
        super.removeNodeFromParent(child);
    }

    public void removeNodeOfUserObject(Object obj) {
        DefaultMutableTreeNode node = this.getNodeFromUserObject(obj);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (node != null) {
            node.removeFromParent();
        }
        this.nodeStructureChanged(parent);
    }
}

