/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.xissweb.data.layout.LocationOnMapInfo;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.gui.layout.editor.GoogleMapsInfoEditor;
import org.xissweb.gui.layout.editor.TransitionInfoEditor;
import org.xissweb.i18n.TextDisplayManager;

public class ImageLocationOnMapEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = 5846419695583282309L;
    private static final String[] zoomLevelValues = new String[]{"zoom.level.very.near", "zoom.level.near", "zoom.level.medium", "zoom.level.far", "zoom.level.very.far"};
    private static final String helpTag = "layoutgmaps";
    private LocationOnMapInfo locationOnMapInfo;
    private JPanel gMapsInfoPanel = null;
    private JLabel zoomLevelLabel = null;
    private JComboBox zoomLevelComboBox = null;
    private TransitionInfoEditor transitionInfoEditor = null;

    public ImageLocationOnMapEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints transitionConstraints = new GridBagConstraints();
        transitionConstraints.anchor = 17;
        transitionConstraints.gridy = 1;
        transitionConstraints.gridx = 0;
        transitionConstraints.insets = new Insets(5, 30, 5, 5);
        GridBagConstraints zoomLevelLabelConstraints = new GridBagConstraints();
        zoomLevelLabelConstraints.gridx = 1;
        zoomLevelLabelConstraints.insets = new Insets(7, 20, 7, 5);
        zoomLevelLabelConstraints.anchor = 17;
        zoomLevelLabelConstraints.gridy = 1;
        GridBagConstraints zoomLevelComboBoxConstraints = new GridBagConstraints();
        zoomLevelComboBoxConstraints.fill = 0;
        zoomLevelComboBoxConstraints.gridx = 2;
        zoomLevelComboBoxConstraints.gridy = 1;
        zoomLevelComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        zoomLevelComboBoxConstraints.anchor = 17;
        zoomLevelComboBoxConstraints.weightx = 10.0;
        this.zoomLevelLabel = new JLabel();
        this.zoomLevelLabel.setText("zoom.level.label");
        this.textDisplayer.register(this.zoomLevelLabel, "zoom.level.label");
        GridBagConstraints gMapsInfoPanelConstraints = new GridBagConstraints();
        gMapsInfoPanelConstraints.anchor = 11;
        gMapsInfoPanelConstraints.gridx = 0;
        gMapsInfoPanelConstraints.gridy = 2;
        gMapsInfoPanelConstraints.weighty = 1000.0;
        gMapsInfoPanelConstraints.gridwidth = 3;
        gMapsInfoPanelConstraints.insets = new Insets(15, 5, 5, 5);
        this.addTitle(3, helpTag);
        this.add((Component)this.getTransitionInfoEditor(), transitionConstraints);
        this.add((Component)this.zoomLevelLabel, zoomLevelLabelConstraints);
        this.add((Component)this.getZoomLevelComboBox(), zoomLevelComboBoxConstraints);
        this.add((Component)this.getGMapsInfoPanel(), gMapsInfoPanelConstraints);
    }

    protected void doSave() {
        this.locationOnMapInfo.setZoomLevel(this.getZoomLevelValue());
    }

    protected void initEdition() {
        this.getZoomLevelComboBox().setSelectedIndex(this.getZoomLevelIndexValue());
        try {
            this.transitionInfoEditor.setEditedDocument(this.locationOnMapInfo.getTransition());
            this.transitionInfoEditor.edit();
            ((GoogleMapsInfoEditor)this.gMapsInfoPanel).setEditedDocument(this.locationOnMapInfo.getMapInfo());
            ((GoogleMapsInfoEditor)this.gMapsInfoPanel).edit();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private int getZoomLevelIndexValue() {
        switch (this.locationOnMapInfo.getZoomLevel()) {
            case 18: {
                return 0;
            }
            case 15: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 2: {
                return 4;
            }
        }
        return 2;
    }

    private int getZoomLevelValue() {
        switch (this.getZoomLevelComboBox().getSelectedIndex()) {
            case 0: {
                return 18;
            }
            case 1: {
                return 15;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 2;
            }
        }
        return 10;
    }

    public void modified(boolean error) {
        if (!this.initializing && this.locationOnMapInfo != null) {
            if (!error) {
                boolean bl = this.isModified = this.locationOnMapInfo.getZoomLevel() != this.getZoomLevelValue();
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    public Object getEditedDocument() {
        return this.locationOnMapInfo;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        this.locationOnMapInfo = (LocationOnMapInfo)document;
    }

    private JPanel getGMapsInfoPanel() {
        if (this.gMapsInfoPanel == null) {
            this.gMapsInfoPanel = new GoogleMapsInfoEditor(this.mainEditor);
        }
        return this.gMapsInfoPanel;
    }

    private JComboBox getZoomLevelComboBox() {
        if (this.zoomLevelComboBox == null) {
            this.zoomLevelComboBox = new JComboBox();
            this.zoomLevelComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageLocationOnMapEditor.this.modified(false);
                }
            });
            this.textDisplayer.registerCombo(this.zoomLevelComboBox, zoomLevelValues);
        }
        return this.zoomLevelComboBox;
    }

    private TransitionInfoEditor getTransitionInfoEditor() {
        if (this.transitionInfoEditor == null) {
            this.transitionInfoEditor = new TransitionInfoEditor(this.mainEditor);
        }
        return this.transitionInfoEditor;
    }
}

