/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import org.xissweb.data.layout.Arrangeable;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.graphic.AbstractGraphicDrawer;
import org.xissweb.gui.graphic.GraphicElement;
import org.xissweb.gui.graphic.GraphicIconElement;
import org.xissweb.gui.layout.LayoutGraphicModel;

public class LayoutGraphicDrawer
extends AbstractGraphicDrawer {
    private static final long serialVersionUID = 3839977002017656821L;
    static final double pageFactor = 1.0;
    static final int pageMargin = 3;
    static final double decorationFactor = 0.125;
    static final int elementMargin = 2;

    public LayoutGraphicDrawer() {
        this.setBackground(XissWebUI.paleColor);
        this.setForeground(XissWebUI.darkColor);
        this.initialize();
    }

    private void initialize() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 1 && event.getModifiers() == 16) {
                    LayoutGraphicDrawer.this.selectionClick(event);
                }
            }
        });
    }

    private boolean isSelected(GraphicElement elt) {
        return this.getSelectionModel().getSelection() == elt;
    }

    public void draw(Graphics2D graphics, Rectangle area) {
        graphics.setPaint(this.getBackground());
        graphics.fill(area);
        graphics.setPaint(this.getBackground());
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        SlideShowLayoutInfo layoutInfo = ((LayoutGraphicModel)this.getModel()).getLayoutInfo();
        if (layoutInfo != null) {
            int size;
            int pageW = size = Math.min(area.width, area.height) - 6;
            int pageH = (int)((double)size * 1.0);
            int x0 = (area.width - pageW) / 2;
            int y0 = (area.height - pageH) / 2;
            Rectangle rect = new Rectangle(x0, y0, pageW, pageH);
            int m = 2;
            int eSize = (int)((double)size * 0.125) - 2 * m;
            GraphicElement root = this.getModel().getRootElement();
            this.updateElementArea(root, rect);
            this.drawLayoutParams(graphics, root, rect);
            this.drawPageDecoration(graphics, m, eSize, root, rect);
            GraphicElement[] elts = root.getChildren();
            GraphicElement aElt = elts[elts.length - 1];
            this.updateElementArea(aElt, rect);
            this.drawArrangement(graphics, aElt, m);
        }
    }

    private void drawLayoutParams(Graphics2D graphics, GraphicElement elt, Rectangle area) {
        ImageIcon ic;
        GraphicIconElement e;
        SlideShowLayoutInfo layoutInfo = (SlideShowLayoutInfo)elt.getUserObject();
        int dw = 0;
        int h = 0;
        int offset = 0;
        int widthInset = 4;
        if (layoutInfo.getSkin() != null) {
            e = (GraphicIconElement)elt.getChildAt(offset);
            h = Math.max(h, e.getIcon().getIconHeight());
            ++offset;
        }
        if (layoutInfo.getAnimation() != null) {
            e = (GraphicIconElement)elt.getChildAt(offset);
            h = Math.max(h, e.getIcon().getIconHeight());
            ++offset;
        }
        e = (GraphicIconElement)elt.getChildAt(offset);
        h = Math.max(h, e.getIcon().getIconHeight());
        offset = 0;
        if (layoutInfo.getSkin() != null) {
            e = (GraphicIconElement)elt.getChildAt(offset);
            ic = e.getIcon();
            this.updateElementArea(e, area.x + dw, area.y, ic.getIconWidth() + widthInset, h);
            this.getElementRenderer().draw(graphics, e, this.isSelected(e));
            dw += ic.getIconWidth() + 2 + widthInset;
            ++offset;
        }
        if (layoutInfo.getAnimation() != null) {
            e = (GraphicIconElement)elt.getChildAt(offset);
            ic = e.getIcon();
            this.updateElementArea(e, area.x + dw, area.y, ic.getIconWidth() + widthInset, h);
            this.getElementRenderer().draw(graphics, e, this.isSelected(e));
            dw += ic.getIconWidth() + 2 + widthInset;
            ++offset;
        }
        e = (GraphicIconElement)elt.getChildAt(offset);
        ic = e.getIcon();
        this.updateElementArea(e, area.x + dw, area.y, ic.getIconWidth() + widthInset, h);
        this.getElementRenderer().draw(graphics, e, this.isSelected(e));
        int dh = h + 2;
        area.y += dh;
        area.height -= dh;
    }

    private void drawArrangement(Graphics2D graphics, GraphicElement aElt, int m) {
        Rectangle r = aElt.getArea();
        ArrangementInfo arrangement = (ArrangementInfo)aElt.getUserObject();
        int size = (int)((double)Math.min(r.width, r.height) * 0.125);
        int nbComp = arrangement.getComponentsCount();
        if (nbComp == 0) {
            graphics.draw(r);
        } else {
            int varSize;
            GraphicElement[] elts = aElt.getChildren();
            int allSizes = 0;
            int nbFixedSize = 0;
            int nbVarSize = 0;
            boolean isVertical = arrangement.isVertical();
            for (int i = 0; i < nbComp; ++i) {
                Arrangeable a = arrangement.getNthComponent(i);
                elts[i].getArea().x = r.x;
                elts[i].getArea().y = r.y;
                elts[i].getArea().width = r.width;
                elts[i].getArea().height = r.height;
                if (a instanceof NavigationBarInfo) {
                    allSizes += size;
                    ++nbFixedSize;
                    if (isVertical) {
                        elts[i].getArea().height = size;
                        continue;
                    }
                    elts[i].getArea().width = size;
                    continue;
                }
                if (a instanceof ThumbnailsInfo) {
                    ++nbFixedSize;
                    ThumbnailsInfo thumb = (ThumbnailsInfo)a;
                    if (isVertical) {
                        elts[i].getArea().height = size * thumb.getRange();
                    } else {
                        elts[i].getArea().width = size * thumb.getRange();
                    }
                    allSizes += size * thumb.getRange();
                    continue;
                }
                ++nbVarSize;
            }
            int n = varSize = arrangement.isVertical() ? r.height : r.width;
            if (nbVarSize != 0) {
                varSize = (varSize - allSizes) / nbVarSize - nbFixedSize * m;
            }
            for (int i = 0; i < nbComp; ++i) {
                Arrangeable a = arrangement.getNthComponent(i);
                if (a instanceof ArrangementInfo || a instanceof ImageAreaInfo) {
                    if (isVertical) {
                        elts[i].getArea().height = varSize;
                    } else {
                        elts[i].getArea().width = varSize;
                    }
                }
                if (i > 0) {
                    if (isVertical) {
                        elts[i].getArea().y = elts[i - 1].getArea().y + elts[i - 1].getArea().height + m;
                    } else {
                        elts[i].getArea().x = elts[i - 1].getArea().x + elts[i - 1].getArea().width + m;
                    }
                }
                if (a instanceof ImageAreaInfo) {
                    this.drawImageArea(graphics, elts[i]);
                    continue;
                }
                this.getElementRenderer().draw(graphics, elts[i], this.isSelected(elts[i]));
                if (!(a instanceof ArrangementInfo)) continue;
                this.drawArrangement(graphics, elts[i], m);
            }
        }
    }

    private void drawImageArea(Graphics2D graphics, GraphicElement element) {
        int h;
        int w;
        ImageIcon ic;
        GraphicIconElement e;
        this.getElementRenderer().draw(graphics, element, this.isSelected(element));
        ImageAreaInfo areaInfo = (ImageAreaInfo)element.getUserObject();
        int offset = 0;
        int x0 = element.getArea().x;
        int y0 = element.getArea().y;
        int inset = 4;
        if (areaInfo.hasLocalIndex()) {
            e = (GraphicIconElement)element.getChildAt(offset);
            ic = e.getIcon();
            w = ic.getIconWidth() + inset;
            h = ic.getIconHeight() + inset;
            this.updateElementArea(e, x0 + (element.getArea().width - w) / 2, y0 + (element.getArea().height - h) / 2, w, h);
            ++offset;
            this.getElementRenderer().draw(graphics, e, this.isSelected(e));
        }
        if (areaInfo.hasImageLocationOnMap()) {
            e = (GraphicIconElement)element.getChildAt(offset);
            ic = e.getIcon();
            w = ic.getIconWidth() + inset;
            h = ic.getIconHeight() + inset;
            this.updateElementArea(e, x0 + element.getArea().width - w, y0 + element.getArea().height - h, w, h);
            this.getElementRenderer().draw(graphics, e, this.isSelected(e));
        }
    }

    private void drawPageDecoration(Graphics2D graphics, int m, int size, GraphicElement elt, Rectangle area) {
        GraphicElement e;
        int offset;
        SlideShowLayoutInfo layoutInfo = (SlideShowLayoutInfo)elt.getUserObject();
        int n = offset = layoutInfo.getSkin() != null ? 2 : 1;
        if (layoutInfo.getAnimation() != null) {
            ++offset;
        }
        int nbW = 0;
        int nbH = 0;
        int header = 0;
        int footer = 0;
        int left = 0;
        int index = offset;
        if (layoutInfo.hasHeader()) {
            ++nbH;
            ++header;
        }
        if (layoutInfo.hasFooter()) {
            ++nbH;
            ++footer;
        }
        if (layoutInfo.hasHeader()) {
            e = elt.getChildAt(index);
            ++index;
            this.updateElementArea(e, area.x, area.y, area.width, size);
            this.getElementRenderer().draw(graphics, e, this.isSelected(e));
        }
        if (layoutInfo.hasLeftMargin()) {
            e = elt.getChildAt(index);
            ++index;
            this.updateElementArea(e, area.x, area.y + header * (size + m), size, area.height - nbH * (size + m));
            this.getElementRenderer().draw(graphics, e, this.isSelected(e));
            ++nbW;
            ++left;
        }
        if (layoutInfo.hasRightMargin()) {
            e = elt.getChildAt(index);
            ++index;
            this.updateElementArea(e, area.x + area.width - size, area.y + header * (size + m), size, area.height - nbH * (size + m));
            this.getElementRenderer().draw(graphics, e, this.isSelected(e));
            ++nbW;
        }
        if (layoutInfo.hasFooter()) {
            e = elt.getChildAt(index);
            ++index;
            this.updateElementArea(e, area.x, area.y + area.height - size, area.width, size);
            this.getElementRenderer().draw(graphics, e, this.isSelected(e));
        }
        area.x += left * (size + m);
        area.y += header * (size + m);
        area.width -= nbW * (size + m);
        area.height -= nbH * (size + m);
    }

    void selectionClick(MouseEvent event) {
        GraphicElement element = this.getModel().getElementOn(event.getX(), event.getY());
        if (element != null) {
            GraphicElement e = this.getSelectionModel().getSelection();
            if (e == element && event.getModifiers() == 144) {
                this.getSelectionModel().clearSelection();
            } else if (element != e) {
                this.getSelectionModel().setSelection(element);
            }
        }
    }
}

