/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.GoogleMapsInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.LocalIndexGoogleMapsInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.LocationOnMapInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.data.layout.xml.FullLayoutDeserialiser;
import org.xissweb.data.layout.xml.LayoutSerializer;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.file.FileManager;
import org.xissweb.gui.graphic.GraphicElement;
import org.xissweb.gui.graphic.GraphicModel;
import org.xissweb.gui.layout.LayoutElementTransferHandler;
import org.xissweb.gui.layout.LayoutGraphicDrawer;
import org.xissweb.gui.layout.LayoutGraphicElementRenderer;
import org.xissweb.gui.layout.LayoutGraphicModel;
import org.xissweb.gui.layout.LayoutGraphicSelectionModel;
import org.xissweb.gui.layout.LayoutTreeCellRenderer;
import org.xissweb.gui.layout.LayoutTreeModel;
import org.xissweb.gui.layout.LayoutTreeSelectionModel;
import org.xissweb.gui.layout.editor.AnimationEditor;
import org.xissweb.gui.layout.editor.ArrangementEditor;
import org.xissweb.gui.layout.editor.ImageAreaEditor;
import org.xissweb.gui.layout.editor.ImageLocationOnMapEditor;
import org.xissweb.gui.layout.editor.LayoutPageEditor;
import org.xissweb.gui.layout.editor.LocalIndexGoogleMapsEditor;
import org.xissweb.gui.layout.editor.LocalIndexStandardEditor;
import org.xissweb.gui.layout.editor.NavigationBarEditor;
import org.xissweb.gui.layout.editor.PageDecorationEditor;
import org.xissweb.gui.layout.editor.SkinEditor;
import org.xissweb.gui.layout.editor.ThumbnailsEditor;
import org.xissweb.gui.layout.editor.ThumbnailsInfoEditor;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.gui.worker.SwingWorker;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.SplitPaneConfigurator;
import org.xissweb.xml.XMLHelper;

public class LayoutEditor
extends JSplitPane
implements Editor {
    private static final long serialVersionUID = 4922159617934934299L;
    private static final String HORIZONTAL_DIVIDER_POSITION = "horizontal.divider.position";
    private static final String VERTICAL_DIVIDER_POSITION = "vertical.divider.position";
    private static final int skinIndex = 0;
    private static final int animationIndex = 0;
    private static final int decorationGraphicDelta = 1;
    private static final int decorationIndex = 1;
    private EditorsContainer editorsContainer;
    File layoutFile;
    private String encoding;
    SlideShowLayoutInfo layoutInfo;
    FullLayoutDeserialiser reader = new FullLayoutDeserialiser();
    private LayoutSerializer writer = new LayoutSerializer();
    boolean isModified = false;
    LayoutTreeModel treeModel;
    LayoutGraphicModel graphicModel;
    private TextDisplayer textDisplayer;
    private DefaultMutableTreeNode nodeUnderPopupMenu;
    private Object userObjectUnderPopupMenu;
    private Editor currentEditor;
    private HashMap editors = new HashMap();
    private JScrollPane layoutTreeContainer = null;
    JTree layoutTree = null;
    private JScrollPane elementEditorContainer = null;
    private JPopupMenu layoutPopupMenu = null;
    private JMenuItem addSkinInfoMenuItem = null;
    private JMenuItem addHeaderMenuItem = null;
    private JMenuItem addLeftMarginMenuItem = null;
    private JMenuItem addRightMarginMenuItem = null;
    private JMenuItem addFooterMenuItem = null;
    private JPopupMenu arrangementPopupMenu = null;
    private JMenuItem addArrangementMenuItem = null;
    private JMenuItem addNavigationBarMenuItem = null;
    private JMenuItem addImageAreaMenuItem = null;
    private JMenuItem addThumbnailsMenuItem = null;
    private JPopupMenu commonPopupMenu = null;
    private JMenuItem deleteMenuItem = null;
    private JMenuItem deleteArrangementMenuItem = null;
    JSplitPane graphicSplitPane = null;
    private LayoutGraphicDrawer layoutGraphicDrawer = null;
    private JPopupMenu imageAreaPopupMenu = null;
    private JMenuItem addStandardIndexMenuItem = null;
    private JMenuItem addGoogleMapsIndexMenuItem = null;
    private JMenuItem addImageLocationOnMapMenuItem = null;
    private JMenuItem addAnimationMenuItem = null;
    private JPopupMenu localIndexPopupMenu = null;
    private JMenuItem changeToStandardIndexMenuItem = null;
    private JMenuItem changeToGoogleMapsIndexMenuItem = null;
    private JMenuItem deleteLocalIndexMenuItem = null;
    static /* synthetic */ Class class$org$xissweb$gui$layout$LayoutEditor;
    static /* synthetic */ Class class$org$xissweb$data$layout$NavigationBarInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$ImageAreaInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$ThumbnailsInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$ArrangementInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$ThumbnailsInfoInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$PageDecorationInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$SkinInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$SlideShowLayoutInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$LocalIndexGoogleMapsInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$LocalIndexStandardInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$LocationOnMapInfo;
    static /* synthetic */ Class class$org$xissweb$data$layout$AnimationInfo;

    public LayoutEditor() {
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$layout$LayoutEditor == null ? (class$org$xissweb$gui$layout$LayoutEditor = LayoutEditor.class$("org.xissweb.gui.layout.LayoutEditor")) : class$org$xissweb$gui$layout$LayoutEditor);
        this.initialize();
        this.editors.put(class$org$xissweb$data$layout$NavigationBarInfo == null ? (class$org$xissweb$data$layout$NavigationBarInfo = LayoutEditor.class$("org.xissweb.data.layout.NavigationBarInfo")) : class$org$xissweb$data$layout$NavigationBarInfo, new NavigationBarEditor(this));
        this.editors.put(class$org$xissweb$data$layout$ImageAreaInfo == null ? (class$org$xissweb$data$layout$ImageAreaInfo = LayoutEditor.class$("org.xissweb.data.layout.ImageAreaInfo")) : class$org$xissweb$data$layout$ImageAreaInfo, new ImageAreaEditor(this));
        this.editors.put(class$org$xissweb$data$layout$ThumbnailsInfo == null ? (class$org$xissweb$data$layout$ThumbnailsInfo = LayoutEditor.class$("org.xissweb.data.layout.ThumbnailsInfo")) : class$org$xissweb$data$layout$ThumbnailsInfo, new ThumbnailsEditor(this));
        this.editors.put(class$org$xissweb$data$layout$ArrangementInfo == null ? (class$org$xissweb$data$layout$ArrangementInfo = LayoutEditor.class$("org.xissweb.data.layout.ArrangementInfo")) : class$org$xissweb$data$layout$ArrangementInfo, new ArrangementEditor(this));
        this.editors.put(class$org$xissweb$data$layout$ThumbnailsInfoInfo == null ? (class$org$xissweb$data$layout$ThumbnailsInfoInfo = LayoutEditor.class$("org.xissweb.data.layout.ThumbnailsInfoInfo")) : class$org$xissweb$data$layout$ThumbnailsInfoInfo, new ThumbnailsInfoEditor(this));
        this.editors.put(class$org$xissweb$data$layout$PageDecorationInfo == null ? (class$org$xissweb$data$layout$PageDecorationInfo = LayoutEditor.class$("org.xissweb.data.layout.PageDecorationInfo")) : class$org$xissweb$data$layout$PageDecorationInfo, new PageDecorationEditor(this));
        this.editors.put(class$org$xissweb$data$layout$SkinInfo == null ? (class$org$xissweb$data$layout$SkinInfo = LayoutEditor.class$("org.xissweb.data.layout.SkinInfo")) : class$org$xissweb$data$layout$SkinInfo, new SkinEditor(this));
        this.editors.put(class$org$xissweb$data$layout$SlideShowLayoutInfo == null ? (class$org$xissweb$data$layout$SlideShowLayoutInfo = LayoutEditor.class$("org.xissweb.data.layout.SlideShowLayoutInfo")) : class$org$xissweb$data$layout$SlideShowLayoutInfo, new LayoutPageEditor(this));
        this.editors.put(class$org$xissweb$data$layout$LocalIndexGoogleMapsInfo == null ? (class$org$xissweb$data$layout$LocalIndexGoogleMapsInfo = LayoutEditor.class$("org.xissweb.data.layout.LocalIndexGoogleMapsInfo")) : class$org$xissweb$data$layout$LocalIndexGoogleMapsInfo, new LocalIndexGoogleMapsEditor(this));
        this.editors.put(class$org$xissweb$data$layout$LocalIndexStandardInfo == null ? (class$org$xissweb$data$layout$LocalIndexStandardInfo = LayoutEditor.class$("org.xissweb.data.layout.LocalIndexStandardInfo")) : class$org$xissweb$data$layout$LocalIndexStandardInfo, new LocalIndexStandardEditor(this));
        this.editors.put(class$org$xissweb$data$layout$LocationOnMapInfo == null ? (class$org$xissweb$data$layout$LocationOnMapInfo = LayoutEditor.class$("org.xissweb.data.layout.LocationOnMapInfo")) : class$org$xissweb$data$layout$LocationOnMapInfo, new ImageLocationOnMapEditor(this));
        this.editors.put(class$org$xissweb$data$layout$AnimationInfo == null ? (class$org$xissweb$data$layout$AnimationInfo = LayoutEditor.class$("org.xissweb.data.layout.AnimationInfo")) : class$org$xissweb$data$layout$AnimationInfo, new AnimationEditor(this));
        this.initLayoutTree();
        this.initLayoutGraphic();
        this.applyPreferences();
    }

    public SlideShowLayoutInfo getLayoutInfo() {
        return this.layoutInfo;
    }

    private void applyPreferences() {
        SplitPaneConfigurator.configure((JSplitPane)this, (String)this.getClass().getName(), (String)VERTICAL_DIVIDER_POSITION);
        SplitPaneConfigurator.configure((JSplitPane)this.getGraphicSplitPane(), (String)this.getClass().getName(), (String)HORIZONTAL_DIVIDER_POSITION);
    }

    void savePreferences(String divider, int location) {
        Main.preferences.putInt(divider, this.getClass(), location);
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setRightComponent(this.getElementEditorContainer());
        this.setLeftComponent(this.getGraphicSplitPane());
        this.setDividerLocation(400);
        this.setOrientation(1);
    }

    private void initLayoutTree() {
        if (this.treeModel == null) {
            this.treeModel = new LayoutTreeModel();
            this.getLayoutTree().setModel(this.treeModel);
            this.getLayoutTree().setCellRenderer(new LayoutTreeCellRenderer());
            this.getLayoutTree().setSelectionModel(new LayoutTreeSelectionModel(this));
            this.getLayoutTree().setTransferHandler(new LayoutElementTransferHandler(this));
            this.getLayoutTree().setDragEnabled(true);
            this.getLayoutTree().setRootVisible(true);
        }
    }

    private void initLayoutGraphic() {
        if (this.graphicModel == null) {
            this.graphicModel = new LayoutGraphicModel();
            this.getLayoutGraphicDrawer().setModel(this.graphicModel);
            LayoutGraphicSelectionModel selModel = new LayoutGraphicSelectionModel(this);
            this.getLayoutGraphicDrawer().setSelectionModel(selModel);
            selModel.drawer = this.getLayoutGraphicDrawer();
            this.getLayoutGraphicDrawer().setElementRenderer(new LayoutGraphicElementRenderer());
        }
    }

    GraphicModel getGraphicModel() {
        return this.graphicModel;
    }

    private JScrollPane getLayoutTreeContainer() {
        if (this.layoutTreeContainer == null) {
            this.layoutTreeContainer = new JScrollPane();
            this.layoutTreeContainer.setViewportView(this.getLayoutTree());
        }
        return this.layoutTreeContainer;
    }

    private JTree getLayoutTree() {
        if (this.layoutTree == null) {
            this.layoutTree = new JTree();
            this.layoutTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1 && (e.getModifiers() == 4 || e.getModifiers() == 18)) {
                        LayoutEditor.this.onTreeRightClick(e);
                    }
                }
            });
        }
        return this.layoutTree;
    }

    private JScrollPane getElementEditorContainer() {
        if (this.elementEditorContainer == null) {
            this.elementEditorContainer = new JScrollPane();
        }
        return this.elementEditorContainer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEditorsContainer(EditorsContainer editorsContainer) {
        this.editorsContainer = editorsContainer;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        File f = (File)document;
        if (!f.exists()) {
            throw new DocumentException(f.getAbsolutePath());
        }
        this.layoutFile = f;
        this.encoding = XMLHelper.getEncoding(this.layoutFile);
    }

    public Object getEditedDocument() {
        return this.layoutFile;
    }

    public boolean isReadOnly() {
        return !this.layoutFile.canWrite();
    }

    public void edit() {
        if (this.layoutInfo == null) {
            this.loadAndUpdateGUI();
            this.editorsContainer.editorStatusChange(this, 0);
        }
    }

    public JMenuItem[] getMenuItems() {
        return null;
    }

    private void loadAndUpdateGUI() {
        this.layoutInfo = this.reader.deserialize(this.layoutFile);
        this.treeModel = new LayoutTreeModel(this.layoutInfo);
        this.layoutTree.setModel(this.treeModel);
        TreeHelper.expandAll(this.layoutTree);
        this.graphicModel.setLayoutInfo(this.layoutInfo);
        this.getLayoutGraphicDrawer().repaint();
        this.isModified = false;
    }

    public void edit(Object object) {
        this.edit();
        TreeHelper.selectNode(this.layoutTree, this.treeModel.getNodeFromUserObject(object), true);
    }

    public boolean isDocumentValid() {
        return true;
    }

    public ValidProcessHandler getValidProcessHandler() {
        return null;
    }

    public void setValidProcessHandler(ValidProcessHandler handler) {
    }

    public int save() {
        this.encoding = Main.get().getCurrentProject().getProperties().getSlideshowEncoding();
        this.writer.setEncoding(this.encoding);
        this.writer.serialize(this.layoutInfo, this.layoutFile);
        this.isModified = false;
        this.editorsContainer.editorStatusChange(this, 3);
        return 0;
    }

    public void cancel() {
        this.layoutInfo = null;
        this.loadAndUpdateGUI();
        this.editorsContainer.editorStatusChange(this, 2);
    }

    public void reload() {
        this.loadAndUpdateGUI();
    }

    public String getDocumentName() {
        return FileHelper.relativePath(Main.get().getCurrentProject().getSrcDirectory(), this.layoutFile);
    }

    public boolean hasDocumentModified() {
        return this.isModified;
    }

    public Component getEditorGuiComponent() {
        return this;
    }

    public Icon getIcon() {
        return FileManager.geFileIcon(this.layoutFile);
    }

    public void modified(boolean error) {
        this.isModified = true;
        TreeHelper.expandAll(this.layoutTree);
        this.layoutGraphicDrawer.repaint();
        this.editorsContainer.editorStatusChange(this, 1);
    }

    void setElementSelection(Object element, Object origine) {
        DefaultMutableTreeNode node;
        GraphicElement e;
        this.unsetElementEditor();
        if (this.layoutGraphicDrawer.getSelectionModel() != origine && (e = this.graphicModel.getElement(element)) != null) {
            this.layoutGraphicDrawer.getSelectionModel().setSelection(e);
        }
        if (this.layoutTree.getSelectionModel() != origine && (node = this.treeModel.getNodeFromUserObject(element)) != null) {
            TreePath path = new TreePath(this.treeModel.getPathToRoot(node));
            this.layoutTree.getSelectionModel().setSelectionPath(path);
        }
        this.setElementEditor(element);
    }

    void unsetElementSelection(Object origine) {
        if (origine != this.layoutTree.getSelectionModel()) {
            this.layoutTree.getSelectionModel().clearSelection();
        }
        if (origine != this.layoutGraphicDrawer.getSelectionModel()) {
            this.layoutGraphicDrawer.getSelectionModel().clearSelection();
        }
        this.unsetElementEditor();
    }

    private void setElementEditor(Object element) {
        this.currentEditor = (Editor)this.editors.get(element.getClass());
        if (this.currentEditor != null) {
            try {
                this.currentEditor.setEditedDocument(element);
                this.currentEditor.edit();
                this.getElementEditorContainer().setViewportView((JPanel)((Object)this.currentEditor));
                this.getElementEditorContainer().validate();
                this.getElementEditorContainer().repaint();
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
    }

    private void unsetElementEditor() {
        if (this.currentEditor != null) {
            this.getElementEditorContainer().setViewportView(null);
            this.getElementEditorContainer().validate();
            this.getElementEditorContainer().repaint();
            this.currentEditor = null;
        }
    }

    void onTreeRightClick(MouseEvent e) {
        this.nodeUnderPopupMenu = TreeHelper.getNode(this.layoutTree, e);
        if (this.nodeUnderPopupMenu != null) {
            this.userObjectUnderPopupMenu = this.nodeUnderPopupMenu.getUserObject();
            if (this.nodeUnderPopupMenu != null) {
                this.openPopupMenu(this.layoutTree, e);
            }
        }
    }

    void onGrapicPanelRightClick(MouseEvent e) {
        GraphicElement elt = this.graphicModel.getElementOn(e.getX(), e.getY());
        this.userObjectUnderPopupMenu = elt != null ? elt.getUserObject() : this.layoutInfo;
        this.nodeUnderPopupMenu = this.treeModel.getNodeFromUserObject(this.userObjectUnderPopupMenu);
        if (this.nodeUnderPopupMenu != null) {
            this.openPopupMenu(this.layoutGraphicDrawer, e);
        }
    }

    private void openPopupMenu(JComponent comp, MouseEvent e) {
        JPopupMenu menu = null;
        if (this.userObjectUnderPopupMenu instanceof SlideShowLayoutInfo) {
            SlideShowLayoutInfo layout = (SlideShowLayoutInfo)this.userObjectUnderPopupMenu;
            this.getAddSkinInfoMenuItem().setEnabled(layout.getSkin() == null);
            this.getAddAnimationMenuItem().setEnabled(layout.getAnimation() == null);
            this.getAddHeaderMenuItem().setEnabled(layout.getHeader() == null);
            this.getAddLeftMarginMenuItem().setEnabled(layout.getLeftMargin() == null);
            this.getAddRightMarginMenuItem().setEnabled(layout.getRightMargin() == null);
            this.getAddFooterMenuItem().setEnabled(layout.getFooter() == null);
            menu = this.getLayoutPopupMenu();
        } else if (this.userObjectUnderPopupMenu instanceof ArrangementInfo) {
            this.getAddImageAreaMenuItem().setEnabled(!this.layoutInfo.hasImageArea());
            this.getDeleteArrangementMenuItem().setEnabled(this.layoutInfo.getArrangement() != this.userObjectUnderPopupMenu);
            menu = this.getArrangementPopupMenu();
        } else if (this.userObjectUnderPopupMenu instanceof ImageAreaInfo) {
            menu = this.getImageAreaPopupMenu();
            ImageAreaInfo imgInfo = (ImageAreaInfo)this.userObjectUnderPopupMenu;
            this.getAddImageLocationOnMapMenuItem().setEnabled(!imgInfo.hasImageLocationOnMap());
            this.getAddStandardIndexMenuItem().setEnabled(!imgInfo.hasLocalIndex() || imgInfo.getLocalIndexInfo().getType().equals("google maps"));
            this.getAddGoogleMapsIndexMenuItem().setEnabled(!imgInfo.hasLocalIndex() || imgInfo.getLocalIndexInfo().getType().equals("standard"));
        } else if (this.userObjectUnderPopupMenu instanceof LocalIndexInfo) {
            LocalIndexInfo indexinfo = (LocalIndexInfo)this.userObjectUnderPopupMenu;
            menu = this.getLocalIndexPopupMenu();
            this.getChangeToGoogleMapsIndexMenuItem().setVisible(indexinfo.getType().equals("standard"));
            this.getChangeToStandardIndexMenuItem().setVisible(indexinfo.getType().equals("google maps"));
        } else if (!(this.userObjectUnderPopupMenu instanceof ThumbnailsInfoInfo)) {
            menu = this.getCommonPopupMenu();
        }
        if (menu != null) {
            menu.show(comp, e.getX(), e.getY());
        }
    }

    void performDeleteElement() {
        ImageAreaInfo imgInfo;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.nodeUnderPopupMenu.getParent();
        Object parentElement = parent.getUserObject();
        if (parentElement instanceof ArrangementInfo) {
            ArrangementInfo aInfo = (ArrangementInfo)parentElement;
            aInfo.getComponents().remove(this.userObjectUnderPopupMenu);
        } else if (parentElement instanceof NavigationBarInfo) {
            ((NavigationBarInfo)parentElement).unsetNavigationElement((String)this.userObjectUnderPopupMenu);
        } else if (this.userObjectUnderPopupMenu instanceof PageDecorationInfo) {
            ((SlideShowLayoutInfo)parentElement).unsetPageDecoration((PageDecorationInfo)this.userObjectUnderPopupMenu);
        } else if (this.userObjectUnderPopupMenu instanceof SkinInfo) {
            this.layoutInfo.setSkin(null);
        } else if (this.userObjectUnderPopupMenu instanceof AnimationInfo) {
            this.layoutInfo.setAnimation(null);
        } else if (this.userObjectUnderPopupMenu instanceof LocalIndexInfo) {
            imgInfo = (ImageAreaInfo)parent.getUserObject();
            imgInfo.setLocalIndexInfo(null);
        } else if (this.userObjectUnderPopupMenu instanceof LocationOnMapInfo) {
            imgInfo = (ImageAreaInfo)parent.getUserObject();
            imgInfo.setLocationOnMap(null);
        }
        GraphicElement graphicE = this.graphicModel.getElement(parentElement);
        graphicE.remove(this.graphicModel.getElement(this.nodeUnderPopupMenu.getUserObject()));
        parent.remove(this.nodeUnderPopupMenu);
        this.treeModel.nodeStructureChanged(parent);
        this.modified(false);
    }

    private void addElement(DefaultMutableTreeNode parent, DefaultMutableTreeNode node) {
        parent.add(node);
        this.treeModel.nodeStructureChanged(parent);
        GraphicElement graphicE = this.graphicModel.getElement(parent.getUserObject());
        GraphicElement elt = this.graphicModel.getElement(node.getUserObject());
        if (elt == null) {
            elt = this.graphicModel.createElement(node.getUserObject());
        }
        if (elt != null) {
            graphicE.add(elt);
        }
        this.modified(false);
    }

    private void addElement(DefaultMutableTreeNode parent, DefaultMutableTreeNode node, int index) {
        parent.insert(node, index);
        this.treeModel.nodeStructureChanged(parent);
        GraphicElement graphicE = this.graphicModel.getElement(parent.getUserObject());
        GraphicElement elt = this.graphicModel.getElement(node.getUserObject());
        if (graphicE != null) {
            if (elt == null) {
                elt = this.graphicModel.createElement(node.getUserObject());
            }
            if (elt != null) {
                if (node.getUserObject() instanceof PageDecorationInfo) {
                    int offset = 1;
                    if (this.layoutInfo.getSkin() != null) {
                        ++offset;
                    }
                    if (this.layoutInfo.getAnimation() != null) {
                        ++offset;
                    }
                    graphicE.insert(elt, index - offset);
                } else {
                    graphicE.insert(elt, index);
                }
            }
        }
        this.modified(false);
    }

    void performAddSkinInfo() {
        SkinInfo skin = new SkinInfo();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(skin);
        this.layoutInfo.setSkin(skin);
        this.addElement(this.nodeUnderPopupMenu, node, 0);
    }

    void performAddAnimation() {
        AnimationInfo animation = new AnimationInfo();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(animation);
        this.layoutInfo.setAnimation(animation);
        this.addElement(this.nodeUnderPopupMenu, node, this.layoutInfo.getSkin() == null ? 0 : 1);
    }

    void performAddPageHeader() {
        PageDecorationInfo deco = new PageDecorationInfo("Header");
        DefaultMutableTreeNode node = this.treeModel.createNode(deco);
        this.layoutInfo.setPageDecoration(deco);
        int index = 1;
        if (this.layoutInfo.getSkin() != null) {
            ++index;
        }
        if (this.layoutInfo.getAnimation() != null) {
            ++index;
        }
        this.addElement(this.nodeUnderPopupMenu, node, index);
    }

    void performAddPageLeftMargin() {
        PageDecorationInfo deco = new PageDecorationInfo("Left Margin");
        DefaultMutableTreeNode node = this.treeModel.createNode(deco);
        this.layoutInfo.setPageDecoration(deco);
        int index = 1;
        if (this.layoutInfo.getSkin() != null) {
            ++index;
        }
        if (this.layoutInfo.getAnimation() != null) {
            ++index;
        }
        if (this.layoutInfo.hasHeader()) {
            ++index;
        }
        this.addElement(this.nodeUnderPopupMenu, node, index);
    }

    void performAddPageRightMargin() {
        PageDecorationInfo deco = new PageDecorationInfo("Right Margin");
        DefaultMutableTreeNode node = this.treeModel.createNode(deco);
        this.layoutInfo.setPageDecoration(deco);
        int index = 1;
        if (this.layoutInfo.getSkin() != null) {
            ++index;
        }
        if (this.layoutInfo.getAnimation() != null) {
            ++index;
        }
        if (this.layoutInfo.hasHeader()) {
            ++index;
        }
        if (this.layoutInfo.hasLeftMargin()) {
            ++index;
        }
        this.addElement(this.nodeUnderPopupMenu, node, index);
    }

    void performAddPageFotter() {
        PageDecorationInfo deco = new PageDecorationInfo("Footer");
        DefaultMutableTreeNode node = this.treeModel.createNode(deco);
        this.layoutInfo.setPageDecoration(deco);
        int index = 1;
        if (this.layoutInfo.getSkin() != null) {
            ++index;
        }
        if (this.layoutInfo.getAnimation() != null) {
            ++index;
        }
        if (this.layoutInfo.hasHeader()) {
            ++index;
        }
        if (this.layoutInfo.hasLeftMargin()) {
            ++index;
        }
        if (this.layoutInfo.hasRightMargin()) {
            ++index;
        }
        this.addElement(this.nodeUnderPopupMenu, node, index);
    }

    void performAddArrangement() {
        ArrangementInfo aParent = (ArrangementInfo)this.userObjectUnderPopupMenu;
        ArrangementInfo a = new ArrangementInfo();
        if (aParent.isHorizontal()) {
            a.setVertical();
        } else {
            a.setHorizontal();
        }
        aParent.getComponents().add(a);
        this.addElement(this.nodeUnderPopupMenu, this.treeModel.createNode(a));
    }

    void performAddNavigationBar() {
        ArrangementInfo aParent = (ArrangementInfo)this.userObjectUnderPopupMenu;
        NavigationBarInfo nav = new NavigationBarInfo();
        nav.setBackward(true);
        nav.setForward(true);
        aParent.getComponents().add(nav);
        this.addElement(this.nodeUnderPopupMenu, this.treeModel.createNode(nav));
    }

    void performAddImageArea() {
        ArrangementInfo aParent = (ArrangementInfo)this.userObjectUnderPopupMenu;
        ImageAreaInfo imgArea = new ImageAreaInfo();
        imgArea.setCommentPosition("bottom");
        imgArea.setNumberFormat("@#/%+");
        imgArea.setWidth(500);
        imgArea.setHeight(500);
        aParent.getComponents().add(imgArea);
        this.addElement(this.nodeUnderPopupMenu, this.treeModel.createNode(imgArea));
    }

    void performAddThumbnails() {
        ArrangementInfo aParent = (ArrangementInfo)this.userObjectUnderPopupMenu;
        ThumbnailsInfo thumb = new ThumbnailsInfo();
        thumb.setRange(1);
        aParent.getComponents().add(thumb);
        this.addElement(this.nodeUnderPopupMenu, this.treeModel.createNode(thumb));
    }

    DefaultMutableTreeNode addNavigationElement(String elt) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(elt);
        NavigationBarInfo navBar = (NavigationBarInfo)this.userObjectUnderPopupMenu;
        navBar.setNavigationElement(elt);
        return node;
    }

    void performAddPrevious(DefaultMutableTreeNode node) {
        this.addElement(this.nodeUnderPopupMenu, node, 0);
    }

    void performAddBackward(DefaultMutableTreeNode node) {
        int index = 0;
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasPrevious()) {
            ++index;
        }
        this.addElement(this.nodeUnderPopupMenu, node, index);
    }

    void performAddInit(DefaultMutableTreeNode node) {
        int index = 0;
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasPrevious()) {
            ++index;
        }
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasBackward()) {
            ++index;
        }
        this.addElement(this.nodeUnderPopupMenu, node, index);
    }

    void performAddForward(DefaultMutableTreeNode node) {
        int index = 0;
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasPrevious()) {
            ++index;
        }
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasBackward()) {
            ++index;
        }
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasInit()) {
            ++index;
        }
        this.addElement(this.nodeUnderPopupMenu, node, index);
    }

    void performAddNext(DefaultMutableTreeNode node) {
        int index = 0;
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasPrevious()) {
            ++index;
        }
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasBackward()) {
            ++index;
        }
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasInit()) {
            ++index;
        }
        if (((NavigationBarInfo)this.userObjectUnderPopupMenu).hasForward()) {
            ++index;
        }
        this.addElement(this.nodeUnderPopupMenu, node, index);
    }

    private JPopupMenu getLayoutPopupMenu() {
        if (this.layoutPopupMenu == null) {
            this.layoutPopupMenu = new JPopupMenu();
            this.layoutPopupMenu.add(this.getAddSkinInfoMenuItem());
            this.layoutPopupMenu.add(this.getAddAnimationMenuItem());
            this.layoutPopupMenu.add(this.getAddHeaderMenuItem());
            this.layoutPopupMenu.add(this.getAddLeftMarginMenuItem());
            this.layoutPopupMenu.add(this.getAddRightMarginMenuItem());
            this.layoutPopupMenu.add(this.getAddFooterMenuItem());
        }
        return this.layoutPopupMenu;
    }

    private JMenuItem getAddSkinInfoMenuItem() {
        if (this.addSkinInfoMenuItem == null) {
            this.addSkinInfoMenuItem = new JMenuItem();
            this.addSkinInfoMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddSkinInfo();
                }
            });
            this.textDisplayer.register(this.addSkinInfoMenuItem, "layout.menu.add.skin.info");
        }
        return this.addSkinInfoMenuItem;
    }

    private JMenuItem getAddAnimationMenuItem() {
        if (this.addAnimationMenuItem == null) {
            this.addAnimationMenuItem = new JMenuItem();
            this.addAnimationMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddAnimation();
                }
            });
            this.textDisplayer.register(this.addAnimationMenuItem, "layout.menu.add.animation");
        }
        return this.addAnimationMenuItem;
    }

    private JMenuItem getAddHeaderMenuItem() {
        if (this.addHeaderMenuItem == null) {
            this.addHeaderMenuItem = new JMenuItem();
            this.addHeaderMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddPageHeader();
                }
            });
            this.textDisplayer.register(this.addHeaderMenuItem, "layout.menu.add.header");
        }
        return this.addHeaderMenuItem;
    }

    private JMenuItem getAddLeftMarginMenuItem() {
        if (this.addLeftMarginMenuItem == null) {
            this.addLeftMarginMenuItem = new JMenuItem();
            this.addLeftMarginMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddPageLeftMargin();
                }
            });
            this.textDisplayer.register(this.addLeftMarginMenuItem, "layout.menu.add.left.margin");
        }
        return this.addLeftMarginMenuItem;
    }

    private JMenuItem getAddRightMarginMenuItem() {
        if (this.addRightMarginMenuItem == null) {
            this.addRightMarginMenuItem = new JMenuItem();
            this.addRightMarginMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddPageRightMargin();
                }
            });
            this.textDisplayer.register(this.addRightMarginMenuItem, "layout.menu.add.right.margin");
        }
        return this.addRightMarginMenuItem;
    }

    private JMenuItem getAddFooterMenuItem() {
        if (this.addFooterMenuItem == null) {
            this.addFooterMenuItem = new JMenuItem();
            this.addFooterMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddPageFotter();
                }
            });
            this.textDisplayer.register(this.addFooterMenuItem, "layout.menu.add.footer");
        }
        return this.addFooterMenuItem;
    }

    private JPopupMenu getArrangementPopupMenu() {
        if (this.arrangementPopupMenu == null) {
            this.arrangementPopupMenu = new JPopupMenu();
            this.arrangementPopupMenu.add(this.getAddArrangementMenuItem());
            this.arrangementPopupMenu.add(this.getAddNavigationBarMenuItem());
            this.arrangementPopupMenu.add(this.getAddImageAreaMenuItem());
            this.arrangementPopupMenu.add(this.getAddThumbnailsMenuItem());
            this.arrangementPopupMenu.add(this.getDeleteArrangementMenuItem());
        }
        return this.arrangementPopupMenu;
    }

    private JMenuItem getAddArrangementMenuItem() {
        if (this.addArrangementMenuItem == null) {
            this.addArrangementMenuItem = new JMenuItem();
            this.addArrangementMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddArrangement();
                }
            });
            this.textDisplayer.register(this.addArrangementMenuItem, "arrangement.menu.add.arrangement");
        }
        return this.addArrangementMenuItem;
    }

    private JMenuItem getAddNavigationBarMenuItem() {
        if (this.addNavigationBarMenuItem == null) {
            this.addNavigationBarMenuItem = new JMenuItem();
            this.addNavigationBarMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddNavigationBar();
                }
            });
            this.textDisplayer.register(this.addNavigationBarMenuItem, "arrangement.menu.add.navigation.bar");
        }
        return this.addNavigationBarMenuItem;
    }

    private JMenuItem getAddImageAreaMenuItem() {
        if (this.addImageAreaMenuItem == null) {
            this.addImageAreaMenuItem = new JMenuItem();
            this.addImageAreaMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddImageArea();
                }
            });
            this.textDisplayer.register(this.addImageAreaMenuItem, "arrangement.menu.add.image.area");
        }
        return this.addImageAreaMenuItem;
    }

    private JMenuItem getAddThumbnailsMenuItem() {
        if (this.addThumbnailsMenuItem == null) {
            this.addThumbnailsMenuItem = new JMenuItem();
            this.addThumbnailsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddThumbnails();
                }
            });
            this.textDisplayer.register(this.addThumbnailsMenuItem, "arrangement.menu.add.thumbnails");
        }
        return this.addThumbnailsMenuItem;
    }

    private JPopupMenu getCommonPopupMenu() {
        if (this.commonPopupMenu == null) {
            this.commonPopupMenu = new JPopupMenu();
            this.commonPopupMenu.add(this.getDeleteMenuItem());
        }
        return this.commonPopupMenu;
    }

    private JMenuItem getDeleteMenuItem() {
        if (this.deleteMenuItem == null) {
            this.deleteMenuItem = new JMenuItem();
            this.deleteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performDeleteElement();
                }
            });
            this.textDisplayer.register(this.deleteMenuItem, "common.menu.delete");
        }
        return this.deleteMenuItem;
    }

    private JMenuItem getDeleteArrangementMenuItem() {
        if (this.deleteArrangementMenuItem == null) {
            this.deleteArrangementMenuItem = new JMenuItem();
            this.deleteArrangementMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performDeleteElement();
                }
            });
            this.textDisplayer.register(this.deleteArrangementMenuItem, "arrangement.menu.delete");
        }
        return this.deleteArrangementMenuItem;
    }

    private JSplitPane getGraphicSplitPane() {
        if (this.graphicSplitPane == null) {
            this.graphicSplitPane = new JSplitPane();
            this.graphicSplitPane.setLeftComponent(this.getLayoutTreeContainer());
            this.graphicSplitPane.setRightComponent(this.getLayoutGraphicDrawer());
            this.graphicSplitPane.setOrientation(0);
        }
        return this.graphicSplitPane;
    }

    LayoutGraphicDrawer getLayoutGraphicDrawer() {
        if (this.layoutGraphicDrawer == null) {
            this.layoutGraphicDrawer = new LayoutGraphicDrawer();
            this.layoutGraphicDrawer.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1 && (e.getModifiers() == 4 || e.getModifiers() == 18)) {
                        LayoutEditor.this.onGrapicPanelRightClick(e);
                    }
                }
            });
        }
        return this.layoutGraphicDrawer;
    }

    private JPopupMenu getImageAreaPopupMenu() {
        if (this.imageAreaPopupMenu == null) {
            this.imageAreaPopupMenu = new JPopupMenu();
            this.imageAreaPopupMenu.add(this.getAddStandardIndexMenuItem());
            this.imageAreaPopupMenu.add(this.getAddGoogleMapsIndexMenuItem());
            this.imageAreaPopupMenu.add(this.getAddImageLocationOnMapMenuItem());
        }
        return this.imageAreaPopupMenu;
    }

    private JMenuItem getAddImageLocationOnMapMenuItem() {
        if (this.addImageLocationOnMapMenuItem == null) {
            this.addImageLocationOnMapMenuItem = new JMenuItem();
            this.addImageLocationOnMapMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddImageLocationOnMap();
                }
            });
            this.textDisplayer.register(this.addImageLocationOnMapMenuItem, "image.area.menu.add.image.location.on.map");
        }
        return this.addImageLocationOnMapMenuItem;
    }

    void performAddImageLocationOnMap() {
        ImageAreaInfo imgInfo = (ImageAreaInfo)this.userObjectUnderPopupMenu;
        LocationOnMapInfo locationOnMapInfo = new LocationOnMapInfo();
        if (imgInfo.hasLocalIndex() && imgInfo.getLocalIndexInfo().getType().equals("google maps")) {
            LocalIndexGoogleMapsInfo locIndex = (LocalIndexGoogleMapsInfo)imgInfo.getLocalIndexInfo();
            locationOnMapInfo.setMapInfo((GoogleMapsInfo)locIndex.getGMapsInfo().clone());
        }
        imgInfo.setLocationOnMap(locationOnMapInfo);
        this.addElement(this.nodeUnderPopupMenu, this.treeModel.createNode(locationOnMapInfo));
    }

    private JMenuItem getAddStandardIndexMenuItem() {
        if (this.addStandardIndexMenuItem == null) {
            this.addStandardIndexMenuItem = new JMenuItem();
            this.addStandardIndexMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddLocalIndex("standard");
                }
            });
            this.textDisplayer.register(this.addStandardIndexMenuItem, "image.area.menu.add.standard.index");
        }
        return this.addStandardIndexMenuItem;
    }

    void performChangeLocalIndex(String type) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.nodeUnderPopupMenu.getParent();
        this.performAddLocalIndex(parent, type);
    }

    void performAddLocalIndex(String type) {
        this.performAddLocalIndex(this.nodeUnderPopupMenu, type);
    }

    void performAddLocalIndex(DefaultMutableTreeNode node, String type) {
        ImageAreaInfo imgInfo = (ImageAreaInfo)node.getUserObject();
        LocalIndexInfo indexInfo = LocalIndexInfo.createInstance(type);
        if (type == "google maps" && imgInfo.hasImageLocationOnMap()) {
            LocalIndexGoogleMapsInfo gMapsIndex = (LocalIndexGoogleMapsInfo)indexInfo;
            gMapsIndex.setGMapsInfo((GoogleMapsInfo)imgInfo.getLocationOnMap().getMapInfo().clone());
        }
        if (imgInfo.hasLocalIndex()) {
            node.remove(0);
            GraphicElement graphicE = this.graphicModel.getElement(imgInfo);
            graphicE.remove(0);
        }
        imgInfo.setLocalIndexInfo(indexInfo);
        this.addElement(node, this.treeModel.createNode(indexInfo), 0);
    }

    private JMenuItem getAddGoogleMapsIndexMenuItem() {
        if (this.addGoogleMapsIndexMenuItem == null) {
            this.addGoogleMapsIndexMenuItem = new JMenuItem();
            this.addGoogleMapsIndexMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performAddLocalIndex("google maps");
                }
            });
            this.textDisplayer.register(this.addGoogleMapsIndexMenuItem, "image.area.menu.add.google.maps.index");
        }
        return this.addGoogleMapsIndexMenuItem;
    }

    private JPopupMenu getLocalIndexPopupMenu() {
        if (this.localIndexPopupMenu == null) {
            this.localIndexPopupMenu = new JPopupMenu();
            this.localIndexPopupMenu.add(this.getChangeToStandardIndexMenuItem());
            this.localIndexPopupMenu.add(this.getChangeToGoogleMapsIndexMenuItem());
            this.localIndexPopupMenu.add(this.getDeleteLoacIndexMenuItem());
        }
        return this.localIndexPopupMenu;
    }

    private JMenuItem getDeleteLoacIndexMenuItem() {
        if (this.deleteLocalIndexMenuItem == null) {
            this.deleteLocalIndexMenuItem = new JMenuItem();
            this.deleteLocalIndexMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performDeleteElement();
                }
            });
            this.textDisplayer.register(this.deleteLocalIndexMenuItem, "local.index.menu.delete");
        }
        return this.deleteLocalIndexMenuItem;
    }

    private JMenuItem getChangeToGoogleMapsIndexMenuItem() {
        if (this.changeToGoogleMapsIndexMenuItem == null) {
            this.changeToGoogleMapsIndexMenuItem = new JMenuItem();
            this.changeToGoogleMapsIndexMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performChangeLocalIndex("google maps");
                }
            });
            this.textDisplayer.register(this.changeToGoogleMapsIndexMenuItem, "local.index.menu.change.to.google.maps.index");
        }
        return this.changeToGoogleMapsIndexMenuItem;
    }

    private JMenuItem getChangeToStandardIndexMenuItem() {
        if (this.changeToStandardIndexMenuItem == null) {
            this.changeToStandardIndexMenuItem = new JMenuItem();
            this.changeToStandardIndexMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LayoutEditor.this.performChangeLocalIndex("standard");
                }
            });
            this.textDisplayer.register(this.changeToStandardIndexMenuItem, "local.index.menu.change.to.standard.index");
        }
        return this.changeToStandardIndexMenuItem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LoaderAndUpdater
    extends SwingWorker {
        LoaderAndUpdater() {
        }

        public boolean construct() {
            LayoutEditor.this.layoutInfo = LayoutEditor.this.reader.deserialize(LayoutEditor.this.layoutFile);
            LayoutEditor.this.treeModel = new LayoutTreeModel(LayoutEditor.this.layoutInfo);
            LayoutEditor.this.layoutTree.setModel(LayoutEditor.this.treeModel);
            TreeHelper.expandAll(LayoutEditor.this.layoutTree);
            LayoutEditor.this.graphicModel.setLayoutInfo(LayoutEditor.this.layoutInfo);
            LayoutEditor.this.getLayoutGraphicDrawer().repaint();
            LayoutEditor.this.isModified = false;
            return false;
        }
    }
}

